/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import com.mojang.nbt.CompoundTag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockPistonMoving;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.logic.PistonDirections;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.phys.AABB;

public class TileEntityPiston
extends TileEntity {
    private int storedBlockID;
    private int storedMetadata;
    private int field_31025_c;
    private boolean field_31024_i;
    private boolean field_31023_j;
    private float field_31022_k;
    private float field_31020_l;
    private static List field_31018_m = new ArrayList();

    public TileEntityPiston() {
    }

    public TileEntityPiston(int i, int j, int k, boolean flag, boolean flag1) {
        this.storedBlockID = i;
        this.storedMetadata = j;
        this.field_31025_c = k;
        this.field_31024_i = flag;
        this.field_31023_j = flag1;
    }

    public int getStoredBlockID() {
        return this.storedBlockID;
    }

    @Override
    public int getBlockMetadata() {
        return this.storedMetadata;
    }

    public boolean func_31015_b() {
        return this.field_31024_i;
    }

    public int func_31009_d() {
        return this.field_31025_c;
    }

    public boolean func_31012_k() {
        return this.field_31023_j;
    }

    public float func_31008_a(float f) {
        if (f > 1.0f) {
            f = 1.0f;
        }
        return this.field_31020_l + (this.field_31022_k - this.field_31020_l) * f;
    }

    public float func_31017_b(float f) {
        if (this.field_31024_i) {
            return (this.func_31008_a(f) - 1.0f) * (float)PistonDirections.xOffset[this.field_31025_c];
        }
        return (1.0f - this.func_31008_a(f)) * (float)PistonDirections.xOffset[this.field_31025_c];
    }

    public float func_31014_c(float f) {
        if (this.field_31024_i) {
            return (this.func_31008_a(f) - 1.0f) * (float)PistonDirections.yOffset[this.field_31025_c];
        }
        return (1.0f - this.func_31008_a(f)) * (float)PistonDirections.yOffset[this.field_31025_c];
    }

    public float func_31013_d(float f) {
        if (this.field_31024_i) {
            return (this.func_31008_a(f) - 1.0f) * (float)PistonDirections.zOffset[this.field_31025_c];
        }
        return (1.0f - this.func_31008_a(f)) * (float)PistonDirections.zOffset[this.field_31025_c];
    }

    private void func_31010_a(float f, float f1) {
        List<Entity> list;
        f = !this.field_31024_i ? (f -= 1.0f) : 1.0f - f;
        AABB axisalignedbb = ((BlockPistonMoving)Block.pistonMoving).func_31035_a(this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.storedBlockID, f, this.field_31025_c);
        if (axisalignedbb != null && !(list = this.worldObj.getEntitiesWithinAABBExcludingEntity(null, axisalignedbb)).isEmpty()) {
            field_31018_m.addAll(list);
            Entity entity = null;
            Iterator iterator = field_31018_m.iterator();
            do {
                if ((entity = (Entity)iterator.next()) == null || entity.noPhysics) continue;
                entity.move(f1 * (float)PistonDirections.xOffset[this.field_31025_c], f1 * (float)PistonDirections.yOffset[this.field_31025_c], f1 * (float)PistonDirections.zOffset[this.field_31025_c]);
            } while (iterator.hasNext());
            field_31018_m.clear();
        }
    }

    public void clearPistonTileEntity() {
        if (this.field_31020_l < 1.0f) {
            this.field_31022_k = 1.0f;
            this.field_31020_l = 1.0f;
            this.worldObj.removeBlockTileEntity(this.xCoord, this.yCoord, this.zCoord);
            this.invalidate();
            if (this.worldObj.getBlockId(this.xCoord, this.yCoord, this.zCoord) == Block.pistonMoving.id) {
                this.worldObj.setBlockAndMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, this.storedBlockID, this.storedMetadata);
            }
        }
    }

    @Override
    public void updateEntity() {
        this.field_31020_l = this.field_31022_k;
        if (this.field_31020_l >= 1.0f) {
            this.func_31010_a(1.0f, 0.25f);
            this.worldObj.removeBlockTileEntity(this.xCoord, this.yCoord, this.zCoord);
            this.invalidate();
            if (this.worldObj.getBlockId(this.xCoord, this.yCoord, this.zCoord) == Block.pistonMoving.id) {
                this.worldObj.setBlockAndMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, this.storedBlockID, this.storedMetadata);
            }
            return;
        }
        this.field_31022_k += 0.5f;
        if (this.field_31022_k >= 1.0f) {
            this.field_31022_k = 1.0f;
        }
        if (this.field_31024_i) {
            this.func_31010_a(this.field_31022_k, this.field_31022_k - this.field_31020_l + 0.0625f);
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.storedBlockID = nbttagcompound.getInteger("blockId");
        this.storedMetadata = nbttagcompound.getInteger("blockData");
        this.field_31025_c = nbttagcompound.getInteger("facing");
        this.field_31020_l = this.field_31022_k = nbttagcompound.getFloat("progress");
        this.field_31024_i = nbttagcompound.getBoolean("extending");
    }

    @Override
    public void writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putInt("blockId", this.storedBlockID);
        nbttagcompound.putInt("blockData", this.storedMetadata);
        nbttagcompound.putInt("facing", this.field_31025_c);
        nbttagcompound.putFloat("progress", this.field_31020_l);
        nbttagcompound.putBoolean("extending", this.field_31024_i);
    }
}

