/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.registry;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.IntTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Registry<T>
implements Iterable<T> {
    private final List<T> items = new ArrayList<T>();
    private final Map<String, T> keyItemMap = new HashMap<String, T>();
    private final Map<T, String> itemKeyMap = new HashMap<T, String>();

    public void register(String key, T item) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(item);
        this.items.add(item);
        this.keyItemMap.put(key, item);
        this.itemKeyMap.put(item, key);
        this.items.sort((t1, t2) -> this.itemKeyMap.get(t1).compareTo(this.itemKeyMap.get(t2)));
    }

    public T getItem(String key) {
        Objects.requireNonNull(key);
        return this.keyItemMap.get(key);
    }

    public String getKey(T item) {
        Objects.requireNonNull(item);
        return this.itemKeyMap.get(item);
    }

    public int getNumericIdOfItem(T item) {
        Objects.requireNonNull(item);
        return this.items.indexOf(item);
    }

    public int getNumericIdOfKey(String key) {
        Objects.requireNonNull(key);
        T item = this.getItem(key);
        if (item != null) {
            return this.getNumericIdOfItem(item);
        }
        return -1;
    }

    public T getItemByNumericId(int id) {
        if (id < 0 || id >= this.items.size()) {
            return null;
        }
        return this.items.get(id);
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    public static <T> void writeIdMapToTag(Registry<T> registry, CompoundTag tag) {
        for (T item : registry) {
            tag.putInt(registry.getKey(item), registry.getNumericIdOfItem(item));
        }
    }

    public static Map<Integer, String> readIdMapFromTag(CompoundTag tag) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (Map.Entry entry : ((Map)tag.getValue()).entrySet()) {
            if (!(entry.getValue() instanceof IntTag)) continue;
            IntTag iTag = (IntTag)entry.getValue();
            map.put((Integer)iTag.getValue(), (String)entry.getKey());
        }
        return map;
    }
}

