/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockSand;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class EntityFallingSand
extends Entity {
    public int blockID;
    public int fallTime;
    public boolean hasRemovedBlock = false;

    public EntityFallingSand(World world) {
        super(world);
        this.blockID = Block.sand.id;
        this.fallTime = 0;
    }

    public EntityFallingSand(World world, double d, double d1, double d2, int i) {
        super(world);
        this.fallTime = 0;
        this.blockID = i;
        this.blocksBuilding = true;
        this.setSize(0.98f, 0.98f);
        this.heightOffset = this.bbHeight / 2.0f;
        this.setPos(d, d1, d2);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.xo = d;
        this.yo = d1;
        this.zo = d2;
    }

    @Override
    protected boolean makeStepSound() {
        return false;
    }

    @Override
    protected void init() {
    }

    @Override
    public boolean isPickable() {
        return !this.removed;
    }

    @Override
    public void tick() {
        if (this.blockID == 0) {
            this.remove();
            return;
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        ++this.fallTime;
        this.yd -= (double)0.04f;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)0.98f;
        this.yd *= (double)0.98f;
        this.zd *= (double)0.98f;
        int i = MathHelper.floor_double(this.x);
        int j = MathHelper.floor_double(this.y);
        int k = MathHelper.floor_double(this.z);
        if (this.world.getBlockId(i, j, k) == this.blockID) {
            this.world.setBlockWithNotify(i, j, k, 0);
            this.hasRemovedBlock = true;
        }
        if (this.onGround) {
            this.xd *= (double)0.7f;
            this.zd *= (double)0.7f;
            this.yd *= -0.5;
            this.remove();
            if (!(this.world.canBlockBePlacedAt(this.blockID, i, j, k, true, Side.TOP) && !BlockSand.canFallBelow(this.world, i, j - 1, k) && this.world.setBlockWithNotify(i, j, k, this.blockID) || this.world.isClientSide || !this.hasRemovedBlock)) {
                this.spawnAtLocation(this.blockID, 1);
            }
        } else if (this.fallTime > 100 && !this.world.isClientSide) {
            if (this.hasRemovedBlock) {
                this.spawnAtLocation(this.blockID, 1);
            }
            this.remove();
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putShort("Tile", (short)this.blockID);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag tag) {
        this.blockID = tag.getShort("Tile") & 0x3FFF;
    }

    @Override
    public float getShadowHeightOffs() {
        return 0.0f;
    }

    public World getWorld() {
        return this.world;
    }

    @Override
    public boolean showBoundingBoxOnHover() {
        return true;
    }
}

