/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.achievement.AchievementList;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLog;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;

public class EntityItem
extends Entity {
    public ItemStack item;
    private int field_803_e;
    public int age = 0;
    public int delayBeforeCanPickup;
    private int health = 5;
    public float field_804_d = (float)(Math.random() * Math.PI * 2.0);
    public int dropTimer;

    public EntityItem(World world, double d, double d1, double d2, ItemStack itemstack) {
        super(world);
        this.setSize(0.25f, 0.25f);
        this.heightOffset = this.bbHeight / 2.0f;
        this.setPos(d, d1, d2);
        this.item = itemstack;
        this.yRot = (float)(Math.random() * 360.0);
        this.xd = (float)(Math.random() * (double)0.2f - (double)0.1f);
        this.yd = 0.2f;
        this.zd = (float)(Math.random() * (double)0.2f - (double)0.1f);
    }

    @Override
    protected boolean makeStepSound() {
        return false;
    }

    public EntityItem(World world) {
        super(world);
        this.setSize(0.25f, 0.25f);
        this.heightOffset = this.bbHeight / 2.0f;
    }

    @Override
    protected void init() {
    }

    @Override
    public void tick() {
        super.tick();
        if (this.item == null || this.item.stackSize <= 0) {
            this.remove();
            return;
        }
        ++this.dropTimer;
        if (this.dropTimer >= 60) {
            this.dropTimer = 0;
            this.clumpToNearbyStack();
        }
        if (this.delayBeforeCanPickup > 0) {
            --this.delayBeforeCanPickup;
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.yd -= (double)0.04f;
        if (this.world.getBlockMaterial(MathHelper.floor_double(this.x), MathHelper.floor_double(this.y), MathHelper.floor_double(this.z)) == Material.lava) {
            this.yd = 0.2f;
            this.xd = (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
            this.zd = (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
            this.world.playSoundAtEntity(this, "random.fizz", 0.4f, 2.0f + this.random.nextFloat() * 0.4f);
        }
        this.checkInTile(this.x, (this.bb.minY + this.bb.maxY) / 2.0, this.z);
        this.move(this.xd, this.yd, this.zd);
        float f = 0.98f;
        if (this.onGround) {
            f = 0.5880001f;
            int i = this.world.getBlockId(MathHelper.floor_double(this.x), MathHelper.floor_double(this.bb.minY) - 1, MathHelper.floor_double(this.z));
            if (i > 0) {
                f = Block.blocksList[i].movementScale * 0.98f;
            }
        }
        this.xd *= (double)f;
        this.yd *= (double)0.98f;
        this.zd *= (double)f;
        if (this.wasInWater && this.yd < 0.0) {
            this.xd *= (double)0.95f;
            this.yd *= (double)0.45f;
            this.zd *= (double)0.95f;
        }
        if (this.onGround) {
            this.yd *= -0.5;
        }
        ++this.field_803_e;
        ++this.age;
        if (this.age >= 6000) {
            this.remove();
        }
    }

    @Override
    public boolean checkAndHandleWater() {
        return this.world.handleMaterialAcceleration(this.bb, Material.water, this);
    }

    @Override
    protected void burn(int damage) {
        this.hurt(null, damage, DamageType.FIRE);
    }

    @Override
    public boolean hurt(Entity entity, int i, DamageType type) {
        this.markHurt();
        this.health -= i;
        if (this.health <= 0) {
            this.remove();
        }
        return false;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putShort("Health", (byte)this.health);
        tag.putShort("Age", (short)this.age);
        tag.putCompound("Item", this.item.writeToNBT(new CompoundTag()));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        this.health = tag.getShort("Health") & 0xFF;
        this.age = tag.getShort("Age");
        CompoundTag nbttagcompound1 = tag.getCompound("Item");
        this.item = ItemStack.readItemStackFromNbt(nbttagcompound1);
    }

    @Override
    public void playerTouch(EntityPlayer player) {
        if (this.world.isClientSide) {
            return;
        }
        int i = this.item.stackSize;
        if (this.delayBeforeCanPickup == 0 && player.inventory.addItemStackToInventoryWithHotbarOffset(this.item)) {
            if (this.item.itemID < 16384 && Block.blocksList[this.item.itemID] instanceof BlockLog) {
                player.triggerAchievement(AchievementList.MINE_WOOD);
            }
            if (this.item.itemID == Item.leather.id) {
                player.triggerAchievement(AchievementList.KILL_COW);
            }
            if (this.item.itemID == Block.ice.id) {
                player.triggerAchievement(AchievementList.CRUSH_BLOCKS);
            }
            this.world.playSoundAtEntity(this, "random.pop", 0.2f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            player.onItemPickup(this, this.item.itemID);
            if ((this.item.itemID == Item.lanternFireflyGreen.id || this.item.itemID == Item.lanternFireflyBlue.id || this.item.itemID == Item.lanternFireflyOrange.id || this.item.itemID == Item.lanternFireflyRed.id) && player.getStat(StatList.pickUpItemStats[Item.lanternFireflyRed.id]) > 0 && player.getStat(StatList.pickUpItemStats[Item.lanternFireflyGreen.id]) > 0 && player.getStat(StatList.pickUpItemStats[Item.lanternFireflyBlue.id]) > 0 && player.getStat(StatList.pickUpItemStats[Item.lanternFireflyOrange.id]) > 0) {
                player.triggerAchievement(AchievementList.CAUGHT_EM_ALL);
            }
            if (this.item.stackSize <= 0) {
                this.remove();
            }
        }
    }

    public void clumpToNearbyStack() {
        AABB boundingBox = new AABB(this.x - 1.0, this.y - 1.0, this.z - 1.0, this.x + 1.0, this.y + 1.0, this.z + 1.0);
        for (Entity nearbyStack : this.world.getEntitiesWithinAABB(EntityItem.class, boundingBox)) {
            if (!(nearbyStack instanceof EntityItem) || nearbyStack == this || !((EntityItem)nearbyStack).item.isItemEqual(this.item)) continue;
            ((EntityItem)nearbyStack).item.stackSize += this.item.stackSize;
            this.remove();
            return;
        }
    }
}

