/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity;

import com.mojang.nbt.CompoundTag;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumArt;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class EntityPainting
extends Entity {
    private int updateCounter = 0;
    public int direction = 0;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public EnumArt art;

    public EntityPainting(World world) {
        super(world);
        this.heightOffset = 0.0f;
        this.art = EnumArt.valueOf("Kebab");
        this.setSize(0.5f, 0.5f);
    }

    @Override
    public boolean showBoundingBoxOnHover() {
        return true;
    }

    public EntityPainting(World world, int x, int y, int z, int side, String motive) {
        this(world);
        this.xPosition = x;
        this.yPosition = y;
        this.zPosition = z;
        for (EnumArt art : EnumArt.values()) {
            if (!art.key.equals(motive)) continue;
            this.art = art;
            break;
        }
        this.setDirection(side);
    }

    @Override
    protected void init() {
    }

    public void setDirection(int direction) {
        this.direction = direction;
        this.yRotO = this.yRot = (float)(direction * 90);
        float sizeX = this.art.sizeX;
        float sizeY = this.art.sizeY;
        float sizeZ = this.art.sizeX;
        if (direction == 0 || direction == 2) {
            sizeZ = 0.5f;
        } else {
            sizeX = 0.5f;
        }
        sizeX /= 32.0f;
        sizeY /= 32.0f;
        sizeZ /= 32.0f;
        float centerX = (float)this.xPosition + 0.5f;
        float centerY = (float)this.yPosition + 0.5f;
        float centerZ = (float)this.zPosition + 0.5f;
        float offsetFromWall = 0.53f;
        if (direction == 0) {
            centerZ -= offsetFromWall;
        }
        if (direction == 1) {
            centerX -= offsetFromWall;
        }
        if (direction == 2) {
            centerZ += offsetFromWall;
        }
        if (direction == 3) {
            centerX += offsetFromWall;
        }
        if (direction == 0) {
            centerX -= this.offsetFromCenter(this.art.sizeX);
        }
        if (direction == 1) {
            centerZ += this.offsetFromCenter(this.art.sizeX);
        }
        if (direction == 2) {
            centerX += this.offsetFromCenter(this.art.sizeX);
        }
        if (direction == 3) {
            centerZ -= this.offsetFromCenter(this.art.sizeX);
        }
        this.setPos(centerX, centerY += this.offsetFromCenter(this.art.sizeY), centerZ);
        float expand = -0.0f;
        this.bb.setBounds(centerX - sizeX - expand, centerY - sizeY - expand, centerZ - sizeZ - expand, centerX + sizeX + expand, centerY + sizeY + expand, centerZ + sizeZ + expand);
        if (direction == 0 || direction == 2) {
            this.bb.minZ -= (double)0.01f;
            this.bb.maxZ += (double)0.01f;
        }
        if (direction == 1 || direction == 3) {
            this.bb.minX -= (double)0.01f;
            this.bb.maxX += (double)0.01f;
        }
    }

    private float offsetFromCenter(int i) {
        if (i == 32) {
            return 0.5f;
        }
        return i != 64 ? 0.0f : 0.5f;
    }

    @Override
    public void tick() {
        if (this.updateCounter++ == 100 && !this.world.isClientSide) {
            this.updateCounter = 0;
            if (!this.canFitPainting()) {
                this.remove();
                this.world.entityJoinedWorld(new EntityItem(this.world, this.x, this.y, this.z, new ItemStack(Item.painting)));
            }
        }
    }

    public boolean canFitPainting() {
        if (this.world.getCubes(this, this.bb).size() > 0) {
            return false;
        }
        int i = this.art.sizeX / 16;
        int j = this.art.sizeY / 16;
        int k = this.xPosition;
        int l = this.yPosition;
        int i1 = this.zPosition;
        if (this.direction == 0) {
            k = MathHelper.floor_double(this.x - (double)((float)this.art.sizeX / 32.0f));
        }
        if (this.direction == 1) {
            i1 = MathHelper.floor_double(this.z - (double)((float)this.art.sizeX / 32.0f));
        }
        if (this.direction == 2) {
            k = MathHelper.floor_double(this.x - (double)((float)this.art.sizeX / 32.0f));
        }
        if (this.direction == 3) {
            i1 = MathHelper.floor_double(this.z - (double)((float)this.art.sizeX / 32.0f));
        }
        l = MathHelper.floor_double(this.y - (double)((float)this.art.sizeY / 32.0f));
        for (int j1 = 0; j1 < i; ++j1) {
            for (int k1 = 0; k1 < j; ++k1) {
                Material material = this.direction == 0 || this.direction == 2 ? this.world.getBlockMaterial(k + j1, l + k1, this.zPosition) : this.world.getBlockMaterial(this.xPosition, l + k1, i1 + j1);
                if (material.isSolid()) continue;
                return false;
            }
        }
        List<Entity> list = this.world.getEntitiesWithinAABBExcludingEntity(this, this.bb);
        for (Entity entity : list) {
            if (!(entity instanceof EntityPainting)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPickable() {
        return true;
    }

    @Override
    public boolean hurt(Entity entity, int i, DamageType type) {
        if (!this.removed && !this.world.isClientSide) {
            this.remove();
            this.markHurt();
            if (!(entity instanceof EntityPlayer) || entity instanceof EntityPlayer && ((EntityPlayer)entity).getGamemode().dropBlockOnBreak) {
                this.world.entityJoinedWorld(new EntityItem(this.world, this.x, this.y, this.z, new ItemStack(Item.painting)));
            }
            this.world.playBlockSoundEffect(this.x, this.y + (double)this.heightOffset, this.z, Block.planksOak, EnumBlockSoundEffectType.MINE);
        }
        return true;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putByte("Dir", (byte)this.direction);
        tag.putString("Motive", this.art.key);
        tag.putInt("TileX", this.xPosition);
        tag.putInt("TileY", this.yPosition);
        tag.putInt("TileZ", this.zPosition);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        this.direction = tag.getByte("Dir");
        this.xPosition = tag.getInteger("TileX");
        this.yPosition = tag.getInteger("TileY");
        this.zPosition = tag.getInteger("TileZ");
        String motive = tag.getString("Motive");
        for (EnumArt enumart : EnumArt.values()) {
            if (!enumart.key.equals(motive)) continue;
            this.art = enumart;
        }
        if (this.art == null) {
            this.art = EnumArt.Kebab;
        }
        this.setDirection(this.direction);
    }

    @Override
    public void move(double xd, double yd, double zd) {
        if (!this.world.isClientSide && xd * xd + yd * yd + zd * zd > 0.0) {
            this.remove();
            this.world.entityJoinedWorld(new EntityItem(this.world, this.x, this.y, this.z, new ItemStack(Item.painting)));
        }
    }

    @Override
    public void push(double x, double y, double z) {
        if (!this.world.isClientSide && x * x + y * y + z * z > 0.0) {
            this.remove();
            this.world.entityJoinedWorld(new EntityItem(this.world, this.x, this.y, this.z, new ItemStack(Item.painting)));
        }
    }
}

