/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.animal;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.entity.animal.EntityAnimal;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemBucketEmpty;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;

public class EntityCow
extends EntityAnimal {
    public EntityCow(World world) {
        super(world);
        this.skinName = "cow";
        this.highestSkinVariant = 3;
        this.setSize(0.9f, 1.3f);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    @Override
    protected String getLivingSound() {
        return "mob.cow";
    }

    @Override
    protected String getHurtSound() {
        return "mob.cowhurt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.cowhurt";
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    protected int getDropItemId() {
        return Item.leather.id;
    }

    @Override
    protected void dropFewItems() {
        int i = this.getDropItemId();
        if (i > 0) {
            int j = this.random.nextInt(5) + 1;
            for (int k = 0; k < j; ++k) {
                this.spawnAtLocation(i, 1);
            }
        }
    }

    @Override
    public boolean interact(EntityPlayer entityplayer) {
        ItemStack itemstack = entityplayer.inventory.getCurrentItem();
        if (itemstack != null && itemstack.itemID == Item.bucket.id) {
            ItemBucketEmpty.UseBucket(entityplayer, new ItemStack(Item.bucketMilk));
            return true;
        }
        return super.interact(entityplayer);
    }
}

