/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.fx;

import net.minecraft.client.render.Tessellator;
import net.minecraft.core.entity.fx.EntityFX;
import net.minecraft.core.world.World;

public class EntityExplodeFX
extends EntityFX {
    public EntityExplodeFX(World world, double d, double d1, double d2, double d3, double d4, double d5) {
        super(world, d, d1, d2, d3, d4, d5);
        this.xd = d3 + (double)((float)(Math.random() * 2.0 - 1.0) * 0.05f);
        this.yd = d4 + (double)((float)(Math.random() * 2.0 - 1.0) * 0.05f);
        this.zd = d5 + (double)((float)(Math.random() * 2.0 - 1.0) * 0.05f);
        this.particleGreen = this.particleBlue = this.random.nextFloat() * 0.3f + 0.7f;
        this.particleRed = this.particleBlue;
        this.particleScale = this.random.nextFloat() * this.random.nextFloat() * 6.0f + 1.0f;
        this.particleMaxAge = (int)(16.0 / ((double)this.random.nextFloat() * 0.8 + 0.2)) + 2;
    }

    @Override
    public void renderParticle(Tessellator t, float renderPartialTicks, float rotationX, float rotationXZ, float rotationZ, float rotationYZ, float rotationXY) {
        super.renderParticle(t, renderPartialTicks, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.remove();
        }
        this.particleTextureIndex = 7 - this.particleAge * 8 / this.particleMaxAge;
        this.yd += 0.004;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)0.9f;
        this.yd *= (double)0.9f;
        this.zd *= (double)0.9f;
        if (this.onGround) {
            this.xd *= (double)0.7f;
            this.zd *= (double)0.7f;
        }
    }
}

