/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.fx;

import net.minecraft.client.render.Tessellator;
import net.minecraft.core.entity.fx.EntityFX;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class EntityFlameFX
extends EntityFX {
    private float field_672_a;

    public EntityFlameFX(World world, double d, double d1, double d2, double d3, double d4, double d5, Type type) {
        super(world, d, d1, d2, d3, d4, d5);
        this.xd = this.xd * (double)0.01f + d3;
        this.yd = this.yd * (double)0.01f + d4;
        this.zd = this.zd * (double)0.01f + d5;
        d += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
        d1 += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
        d2 += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
        this.field_672_a = this.particleScale;
        this.particleBlue = 1.0f;
        this.particleGreen = 1.0f;
        this.particleRed = 1.0f;
        this.particleMaxAge = (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 4;
        this.noPhysics = true;
        this.particleTextureIndex = type.index;
    }

    @Override
    public void renderParticle(Tessellator t, float renderPartialTicks, float rotationX, float rotationXZ, float rotationZ, float rotationYZ, float rotationXY) {
        float f6 = ((float)this.particleAge + renderPartialTicks) / (float)this.particleMaxAge;
        this.particleScale = this.field_672_a * (1.0f - f6 * f6 * 0.5f);
        super.renderParticle(t, renderPartialTicks, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
    }

    @Override
    public float getBrightness(float renderPartialTicks) {
        float decay = MathHelper.clamp(((float)this.particleAge + renderPartialTicks) / (float)this.particleMaxAge, 0.0f, 1.0f);
        return super.getBrightness(renderPartialTicks) * decay + (1.0f - decay);
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.remove();
        }
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)0.96f;
        this.yd *= (double)0.96f;
        this.zd *= (double)0.96f;
        if (this.onGround) {
            this.xd *= (double)0.7f;
            this.zd *= (double)0.7f;
        }
    }

    public static enum Type {
        ORANGE(48),
        SOUL(96),
        BLUE(98);

        private int index;

        private Type(int index) {
            this.index = index;
        }
    }
}

