/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.fx;

import net.minecraft.client.render.Tessellator;
import net.minecraft.core.entity.fx.EntityFX;
import net.minecraft.core.world.World;

public class EntityLavaFX
extends EntityFX {
    private float field_674_a;

    public EntityLavaFX(World world, double d, double d1, double d2) {
        super(world, d, d1, d2, 0.0, 0.0, 0.0);
        this.xd *= (double)0.8f;
        this.yd *= (double)0.8f;
        this.zd *= (double)0.8f;
        this.yd = this.random.nextFloat() * 0.4f + 0.05f;
        this.particleBlue = 1.0f;
        this.particleGreen = 1.0f;
        this.particleRed = 1.0f;
        this.particleScale *= this.random.nextFloat() * 2.0f + 0.2f;
        this.field_674_a = this.particleScale;
        this.particleMaxAge = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        this.noPhysics = false;
        this.particleTextureIndex = 49;
    }

    @Override
    public float getBrightness(float renderPartialTicks) {
        return 1.0f;
    }

    @Override
    public void renderParticle(Tessellator t, float renderPartialTicks, float rotationX, float rotationXZ, float rotationZ, float rotationYZ, float rotationXY) {
        float f6 = ((float)this.particleAge + renderPartialTicks) / (float)this.particleMaxAge;
        this.particleScale = this.field_674_a * (1.0f - f6 * f6);
        super.renderParticle(t, renderPartialTicks, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.remove();
        }
        float f = (float)this.particleAge / (float)this.particleMaxAge;
        if (this.random.nextFloat() > f) {
            this.world.spawnParticle("smoke", this.x, this.y, this.z, this.xd, this.yd, this.zd);
        }
        this.yd -= 0.03;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)0.999f;
        this.yd *= (double)0.999f;
        this.zd *= (double)0.999f;
        if (this.onGround) {
            this.xd *= (double)0.7f;
            this.zd *= (double)0.7f;
        }
    }
}

