/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.fx;

import net.minecraft.client.render.Tessellator;
import net.minecraft.core.entity.fx.EntityFX;
import net.minecraft.core.world.World;

public class EntityPortalFX
extends EntityFX {
    private float field_4083_a;
    private double field_4086_p;
    private double field_4085_q;
    private double field_4084_r;

    public EntityPortalFX(World world, double d, double d1, double d2, double d3, double d4, double d5) {
        super(world, d, d1, d2, d3, d4, d5);
        this.xd = d3;
        this.yd = d4;
        this.zd = d5;
        this.field_4086_p = this.x = d;
        this.field_4085_q = this.y = d1;
        this.field_4084_r = this.z = d2;
        float f = this.random.nextFloat() * 0.6f + 0.4f;
        this.field_4083_a = this.particleScale = this.random.nextFloat() * 0.2f + 0.5f;
        this.particleGreen = this.particleBlue = 1.0f * f;
        this.particleRed = this.particleBlue;
        this.particleGreen *= 0.3f;
        this.particleRed *= 0.9f;
        this.particleMaxAge = (int)(Math.random() * 10.0) + 40;
        this.noPhysics = true;
        this.particleTextureIndex = (int)(Math.random() * 8.0);
    }

    @Override
    public void renderParticle(Tessellator t, float renderPartialTicks, float rotationX, float rotationXZ, float rotationZ, float rotationYZ, float rotationXY) {
        float f6 = ((float)this.particleAge + renderPartialTicks) / (float)this.particleMaxAge;
        f6 = 1.0f - f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        this.particleScale = this.field_4083_a * f6;
        super.renderParticle(t, renderPartialTicks, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
    }

    @Override
    public float getBrightness(float renderPartialTicks) {
        float f1 = super.getBrightness(renderPartialTicks);
        float f2 = (float)this.particleAge / (float)this.particleMaxAge;
        f2 *= f2;
        f2 *= f2;
        return f1 * (1.0f - f2) + f2;
    }

    @Override
    public void tick() {
        float f;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        float f1 = f = (float)this.particleAge / (float)this.particleMaxAge;
        f = -f + f * f * 2.0f;
        f = 1.0f - f;
        this.x = this.field_4086_p + this.xd * (double)f;
        this.y = this.field_4085_q + this.yd * (double)f + (double)(1.0f - f1);
        this.z = this.field_4084_r + this.zd * (double)f;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.remove();
        }
    }
}

