/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.fx;

import net.minecraft.client.render.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.entity.fx.EntityFX;
import net.minecraft.core.item.Item;
import net.minecraft.core.world.World;

public class EntitySlimeChunkFX
extends EntityFX {
    public EntitySlimeChunkFX(World world, double d, double d1, double d2, Item item) {
        super(world, d, d1, d2, 0.0, 0.0, 0.0);
        this.particleTextureIndex = item.getIconFromDamage(0);
        this.particleGravity = 2.0f;
        this.particleBlue = 1.0f;
        this.particleGreen = 1.0f;
        this.particleRed = 1.0f;
        this.particleScale /= 2.0f;
        this.particleMaxAge = 50;
    }

    @Override
    public int getFXLayer() {
        return 2;
    }

    @Override
    public void renderParticle(Tessellator t, float renderPartialTicks, float rotationX, float rotationXZ, float rotationZ, float rotationYZ, float rotationXY) {
        float f6 = ((float)(this.particleTextureIndex % Global.TEXTURE_ATLAS_WIDTH_TILES) + this.particleTextureJitterX / 4.0f) / (float)Global.TEXTURE_ATLAS_WIDTH_TILES;
        float f7 = f6 + 0.25f / (float)Global.TEXTURE_ATLAS_WIDTH_TILES;
        float f8 = ((float)(this.particleTextureIndex / Global.TEXTURE_ATLAS_WIDTH_TILES) + this.particleTextureJitterY / 4.0f) / (float)Global.TEXTURE_ATLAS_WIDTH_TILES;
        float f9 = f8 + 0.25f / (float)Global.TEXTURE_ATLAS_WIDTH_TILES;
        float f10 = 0.1f * this.particleScale;
        float f11 = (float)(this.xo + (this.x - this.xo) * (double)renderPartialTicks - lerpPosX);
        float f12 = (float)(this.yo + (this.y - this.yo) * (double)renderPartialTicks - lerpPosY);
        float f13 = (float)(this.zo + (this.z - this.zo) * (double)renderPartialTicks - lerpPosZ);
        float f14 = this.getBrightness(renderPartialTicks);
        t.setColorOpaque_F(f14 * this.particleRed, f14 * this.particleGreen, f14 * this.particleBlue);
        t.addVertexWithUV(f11 - rotationX * f10 - rotationYZ * f10, f12 - rotationXZ * f10, f13 - rotationZ * f10 - rotationXY * f10, f6, f9);
        t.addVertexWithUV(f11 - rotationX * f10 + rotationYZ * f10, f12 + rotationXZ * f10, f13 - rotationZ * f10 + rotationXY * f10, f6, f8);
        t.addVertexWithUV(f11 + rotationX * f10 + rotationYZ * f10, f12 + rotationXZ * f10, f13 + rotationZ * f10 + rotationXY * f10, f7, f8);
        t.addVertexWithUV(f11 + rotationX * f10 - rotationYZ * f10, f12 - rotationXZ * f10, f13 + rotationZ * f10 - rotationXY * f10, f7, f9);
    }
}

