/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.vehicle;

import com.mojang.nbt.CompoundTag;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;

public class EntityBoat
extends Entity {
    public int boatCurrentDamage = 0;
    public int boatTimeSinceHit = 0;
    public int boatRockDirection = 1;
    private int field_9394_d;
    private double field_9393_e;
    private double field_9392_f;
    private double field_9391_g;
    private double field_9390_h;
    private double boatPitch;
    private double velocityX;
    private double velocityY;
    private double velocityZ;
    private ItemStack flag = null;
    public TileEntityFlag tileEntityFlag = null;

    public EntityBoat(World world) {
        super(world);
        this.blocksBuilding = true;
        this.setSize(1.5f, 0.6f);
        this.heightOffset = this.bbHeight / 2.0f;
    }

    private void createTileEntity() {
        if (this.flag == null) {
            return;
        }
        this.tileEntityFlag = new TileEntityFlag();
        CompoundTag flagData = this.flag.tag.getCompoundOrDefault("FlagData", null);
        if (flagData != null) {
            this.tileEntityFlag.readFlagNBT(flagData);
        }
    }

    @Override
    protected boolean makeStepSound() {
        return false;
    }

    @Override
    protected void init() {
    }

    @Override
    public AABB getBb() {
        return this.bb;
    }

    @Override
    public boolean isPushable() {
        return true;
    }

    public EntityBoat(World world, double d, double d1, double d2) {
        this(world);
        this.setPos(d, d1 + (double)this.heightOffset, d2);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.xo = d;
        this.yo = d1;
        this.zo = d2;
    }

    @Override
    public double getRideHeight() {
        return (double)this.bbHeight * 0.0 - (double)0.3f;
    }

    @Override
    public boolean hurt(Entity entity, int i, DamageType type) {
        int numParticles = this.random.nextInt(8) + 1;
        for (int q = 0; q < numParticles; ++q) {
            this.world.spawnParticle("boatbreak", this.x, this.y, this.z, this.xd, this.yd, this.zd);
        }
        if (this.world.isClientSide || this.removed) {
            return true;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).getGamemode() == Gamemode.creative) {
            this.remove();
            if (this.flag != null) {
                this.spawnAtLocation(this.flag.copy(), 0.0f);
            }
            return true;
        }
        this.boatRockDirection = -this.boatRockDirection;
        this.boatTimeSinceHit = 10;
        this.boatCurrentDamage += i * 10;
        this.markHurt();
        if (this.boatCurrentDamage > 40) {
            if (this.passenger != null) {
                this.passenger.startRiding(this);
            }
            if (entity instanceof EntityPlayer) {
                this.spawnAtLocation(Item.boat.id, 1, 0.0f);
            } else {
                for (int j = 0; j < 3; ++j) {
                    this.spawnAtLocation(Block.planksOak.id, 1, 0.0f);
                }
                for (int k = 0; k < 2; ++k) {
                    this.spawnAtLocation(Item.stick.id, 1, 0.0f);
                }
            }
            if (this.flag != null) {
                this.spawnAtLocation(this.flag.copy(), 0.0f);
            }
            this.remove();
        }
        return true;
    }

    @Override
    public void animateHurt() {
        this.boatRockDirection = -this.boatRockDirection;
        this.boatTimeSinceHit = 10;
        this.boatCurrentDamage += this.boatCurrentDamage * 10;
    }

    @Override
    public boolean isPickable() {
        return !this.removed;
    }

    @Override
    public void lerpTo(double x, double y, double z, float yRot, float xRot, int i) {
        this.field_9393_e = x;
        this.field_9392_f = y;
        this.field_9391_g = z;
        this.field_9390_h = yRot;
        this.boatPitch = xRot;
        this.field_9394_d = i + 4;
        this.xd = this.velocityX;
        this.yd = this.velocityY;
        this.zd = this.velocityZ;
    }

    @Override
    public void lerpMotion(double xd, double yd, double zd) {
        this.velocityX = this.xd = xd;
        this.velocityY = this.yd = yd;
        this.velocityZ = this.zd = zd;
    }

    @Override
    public void tick() {
        double d19;
        double maxSpeed;
        super.tick();
        if (this.boatTimeSinceHit > 0) {
            --this.boatTimeSinceHit;
        }
        if (this.boatCurrentDamage > 0) {
            --this.boatCurrentDamage;
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        int i = 5;
        double d = 0.0;
        for (int j = 0; j < i; ++j) {
            double d5 = this.bb.minY + (this.bb.maxY - this.bb.minY) * (double)j / (double)i - 0.125;
            double d9 = this.bb.minY + (this.bb.maxY - this.bb.minY) * (double)(j + 1) / (double)i - 0.125;
            AABB axisalignedbb = AABB.getBoundingBoxFromPool(this.bb.minX, d5, this.bb.minZ, this.bb.maxX, d9, this.bb.maxZ);
            if (!this.world.isAABBInMaterial(axisalignedbb, Material.water)) continue;
            d += 1.0 / (double)i;
        }
        if (this.world.isClientSide) {
            if (this.field_9394_d > 0) {
                double d14;
                double d1 = this.x + (this.field_9393_e - this.x) / (double)this.field_9394_d;
                double d6 = this.y + (this.field_9392_f - this.y) / (double)this.field_9394_d;
                double d10 = this.z + (this.field_9391_g - this.z) / (double)this.field_9394_d;
                for (d14 = this.field_9390_h - (double)this.yRot; d14 < -180.0; d14 += 360.0) {
                }
                while (d14 >= 180.0) {
                    d14 -= 360.0;
                }
                this.yRot = (float)((double)this.yRot + d14 / (double)this.field_9394_d);
                this.xRot = (float)((double)this.xRot + (this.boatPitch - (double)this.xRot) / (double)this.field_9394_d);
                --this.field_9394_d;
                this.setPos(d1, d6, d10);
                this.setRot(this.yRot, this.xRot);
            } else {
                double d2 = this.x + this.xd;
                double d7 = this.y + this.yd;
                double d11 = this.z + this.zd;
                this.setPos(d2, d7, d11);
                if (this.onGround) {
                    this.xd *= 0.5;
                    this.yd *= 0.5;
                    this.zd *= 0.5;
                }
                this.xd *= (double)0.99f;
                this.yd *= (double)0.95f;
                this.zd *= (double)0.99f;
            }
            return;
        }
        if (d < 1.0) {
            double d3 = d * 2.0 - 1.0;
            this.yd += (double)0.04f * d3;
        } else {
            if (this.yd < 0.0) {
                this.yd /= 2.0;
            }
            this.yd += (double)0.007f;
        }
        if (this.passenger != null) {
            this.xd += this.passenger.xd * 0.4;
            this.zd += this.passenger.zd * 0.4;
        }
        if (this.xd < -(maxSpeed = 0.8)) {
            this.xd = -maxSpeed;
        }
        if (this.xd > maxSpeed) {
            this.xd = maxSpeed;
        }
        if (this.zd < -maxSpeed) {
            this.zd = -maxSpeed;
        }
        if (this.zd > maxSpeed) {
            this.zd = maxSpeed;
        }
        if (this.onGround) {
            this.xd *= 0.5;
            this.yd *= 0.5;
            this.zd *= 0.5;
        }
        this.move(this.xd, this.yd, this.zd);
        double d8 = Math.sqrt(this.xd * this.xd + this.zd * this.zd);
        if (d8 > 0.15) {
            double d12 = Math.cos((double)this.yRot * Math.PI / 180.0);
            double d15 = Math.sin((double)this.yRot * Math.PI / 180.0);
            int i1 = 0;
            while ((double)i1 < 1.0 + d8 * 60.0) {
                double d18 = this.random.nextFloat() * 2.0f - 1.0f;
                double d20 = (double)(this.random.nextInt(2) * 2 - 1) * 0.7;
                if (this.random.nextBoolean()) {
                    double d21 = this.x - d12 * d18 * 0.8 + d15 * d20;
                    double d23 = this.z - d15 * d18 * 0.8 - d12 * d20;
                    this.world.spawnParticle("splash", d21, this.y - 0.125, d23, this.xd, this.yd, this.zd);
                } else {
                    double d22 = this.x + d12 + d15 * d18 * 0.7;
                    double d24 = this.z + d15 - d12 * d18 * 0.7;
                    this.world.spawnParticle("splash", d22, this.y - 0.125, d24, this.xd, this.yd, this.zd);
                }
                ++i1;
            }
        }
        this.xd *= (double)0.99f;
        this.yd *= (double)0.95f;
        this.zd *= (double)0.99f;
        this.xRot = 0.0f;
        double d13 = this.yRot;
        double d16 = this.xo - this.x;
        double d17 = this.zo - this.z;
        if (d16 * d16 + d17 * d17 > 0.001) {
            d13 = (float)(Math.atan2(d17, d16) * 180.0 / Math.PI);
        }
        for (d19 = d13 - (double)this.yRot; d19 >= 180.0; d19 -= 360.0) {
        }
        while (d19 < -180.0) {
            d19 += 360.0;
        }
        if (d19 > 20.0) {
            d19 = 20.0;
        }
        if (d19 < -20.0) {
            d19 = -20.0;
        }
        this.yRot = (float)((double)this.yRot + d19);
        this.setRot(this.yRot, this.xRot);
        List<Entity> list = this.world.getEntitiesWithinAABBExcludingEntity(this, this.bb.expand(0.2f, 0.0, 0.2f));
        if (list != null && list.size() > 0) {
            for (int j1 = 0; j1 < list.size(); ++j1) {
                Entity entity = list.get(j1);
                if (entity == this.passenger || !entity.isPushable() || !(entity instanceof EntityBoat)) continue;
                entity.push(this);
            }
        }
        for (int k1 = 0; k1 < 4; ++k1) {
            int j2;
            int i2;
            int l1 = MathHelper.floor_double(this.x + ((double)(k1 % 2) - 0.5) * 0.8);
            if (this.world.getBlockId(l1, i2 = MathHelper.floor_double(this.y), j2 = MathHelper.floor_double(this.z + ((double)(k1 / 2) - 0.5) * 0.8)) != Block.layerSnow.id) continue;
            this.world.setBlockWithNotify(l1, i2, j2, 0);
        }
        if (this.passenger != null && this.passenger.removed) {
            this.passenger = null;
        }
    }

    @Override
    public void positionRider() {
        if (this.passenger == null) {
            return;
        }
        double d = Math.cos((double)this.yRot * Math.PI / 180.0) * 0.4;
        double d1 = Math.sin((double)this.yRot * Math.PI / 180.0) * 0.4;
        this.passenger.setPos(this.x + d, this.y + this.getRideHeight() + this.passenger.getRidingHeight(), this.z + d1);
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        if (this.flag != null) {
            CompoundTag flagTag = new CompoundTag();
            this.flag.writeToNBT(flagTag);
            tag.put("Flag", flagTag);
        }
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.containsKey("Flag")) {
            CompoundTag flagTag = tag.getCompound("Flag");
            this.flag = ItemStack.readItemStackFromNbt(flagTag);
            this.createTileEntity();
        }
    }

    @Override
    public float getShadowHeightOffs() {
        return 0.0f;
    }

    @Override
    public boolean interact(EntityPlayer entityplayer) {
        if (this.passenger != null && this.passenger instanceof EntityPlayer && this.passenger != entityplayer) {
            return true;
        }
        if (!this.world.isClientSide) {
            if (entityplayer.getHeldItem() != null && entityplayer.getHeldItem().itemID == Item.flag.id && this.flag == null) {
                this.flag = entityplayer.getHeldItem().copy();
                entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, null);
                this.createTileEntity();
                return true;
            }
            entityplayer.startRiding(this);
        }
        return true;
    }

    @Override
    public Entity ejectRider() {
        Entity entity = super.ejectRider();
        if (entity == null) {
            return null;
        }
        entity.moveTo(this.x, this.bb.maxY + 0.1, this.z, entity.yRot, entity.xRot);
        return entity;
    }
}

