/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import com.mojang.nbt.CompoundTag;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.Global;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.data.tag.ITaggable;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.ItemArmor;
import net.minecraft.core.item.ItemBed;
import net.minecraft.core.item.ItemBoat;
import net.minecraft.core.item.ItemBow;
import net.minecraft.core.item.ItemBucket;
import net.minecraft.core.item.ItemBucketEmpty;
import net.minecraft.core.item.ItemBucketIceCream;
import net.minecraft.core.item.ItemCoal;
import net.minecraft.core.item.ItemDoor;
import net.minecraft.core.item.ItemDye;
import net.minecraft.core.item.ItemEgg;
import net.minecraft.core.item.ItemFirestriker;
import net.minecraft.core.item.ItemFishingRod;
import net.minecraft.core.item.ItemFlag;
import net.minecraft.core.item.ItemFood;
import net.minecraft.core.item.ItemFoodStackable;
import net.minecraft.core.item.ItemHandCannonLoaded;
import net.minecraft.core.item.ItemHandCannonUnloaded;
import net.minecraft.core.item.ItemJar;
import net.minecraft.core.item.ItemLabel;
import net.minecraft.core.item.ItemMap;
import net.minecraft.core.item.ItemMinecart;
import net.minecraft.core.item.ItemPainting;
import net.minecraft.core.item.ItemPebble;
import net.minecraft.core.item.ItemPlaceable;
import net.minecraft.core.item.ItemQuiver;
import net.minecraft.core.item.ItemQuiverEndless;
import net.minecraft.core.item.ItemRecord;
import net.minecraft.core.item.ItemSaddle;
import net.minecraft.core.item.ItemSeeds;
import net.minecraft.core.item.ItemSign;
import net.minecraft.core.item.ItemSnowball;
import net.minecraft.core.item.ItemSoup;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.ItemToolShears;
import net.minecraft.core.item.material.ArmorMaterial;
import net.minecraft.core.item.material.ToolMaterial;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.item.tool.ItemToolAxe;
import net.minecraft.core.item.tool.ItemToolHoe;
import net.minecraft.core.item.tool.ItemToolPickaxe;
import net.minecraft.core.item.tool.ItemToolShovel;
import net.minecraft.core.item.tool.ItemToolSword;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class Item
implements ITaggable<Item>,
IItemConvertible {
    protected static Random itemRand = new Random();
    public static final Map<String, Integer> nameToIdMap = new HashMap<String, Integer>();
    public static Item[] itemsList = new Item[32768];
    public static Item toolShovelIron = new ItemToolShovel("tool.shovel.iron", 16384, ToolMaterial.iron).setIconCoord(2, 5);
    public static Item toolPickaxeIron = new ItemToolPickaxe("tool.pickaxe.iron", 16385, ToolMaterial.iron).setIconCoord(2, 6);
    public static Item toolAxeIron = new ItemToolAxe("tool.axe.iron", 16386, ToolMaterial.iron).setIconCoord(2, 7);
    public static Item toolFirestriker = new ItemFirestriker("tool.firestriker", 16387).setIconCoord(5, 0);
    public static Item foodApple = new ItemFood("food.apple", 16388, 4, false).setIconCoord(10, 0);
    public static Item toolBow = new ItemBow("tool.bow", 16389).setIconCoord(5, 1);
    public static Item ammoArrow = new Item("ammo.arrow", 16390).setIconCoord(5, 2);
    public static Item coal = new ItemCoal("coal", 16391).setIconCoord(7, 0);
    public static Item diamond = new Item("diamond", 16392).setIconCoord(7, 3);
    public static Item ingotIron = new Item("ingot.iron", 16393).setIconCoord(7, 1);
    public static Item ingotGold = new Item("ingot.gold", 16394).setIconCoord(7, 2);
    public static Item toolSwordIron = new ItemToolSword("tool.sword.iron", 16395, ToolMaterial.iron).setIconCoord(2, 4).withTags(ItemTags.preventCreativeMining);
    public static Item toolSwordWood = new ItemToolSword("tool.sword.wood", 16396, ToolMaterial.wood).setIconCoord(0, 4).withTags(ItemTags.preventCreativeMining);
    public static Item toolShovelWood = new ItemToolShovel("tool.shovel.wood", 16397, ToolMaterial.wood).setIconCoord(0, 5);
    public static Item toolPickaxeWood = new ItemToolPickaxe("tool.pickaxe.wood", 16398, ToolMaterial.wood).setIconCoord(0, 6);
    public static Item toolAxeWood = new ItemToolAxe("tool.axe.wood", 16399, ToolMaterial.wood).setIconCoord(0, 7);
    public static Item toolSwordStone = new ItemToolSword("tool.sword.stone", 16400, ToolMaterial.stone).setIconCoord(1, 4).withTags(ItemTags.preventCreativeMining);
    public static Item toolShovelStone = new ItemToolShovel("tool.shovel.stone", 16401, ToolMaterial.stone).setIconCoord(1, 5);
    public static Item toolPickaxeStone = new ItemToolPickaxe("tool.pickaxe.stone", 16402, ToolMaterial.stone).setIconCoord(1, 6);
    public static Item toolAxeStone = new ItemToolAxe("tool.axe.stone", 16403, ToolMaterial.stone).setIconCoord(1, 7);
    public static Item toolSwordDiamond = new ItemToolSword("tool.sword.diamond", 16404, ToolMaterial.diamond).setIconCoord(3, 4).withTags(ItemTags.preventCreativeMining);
    public static Item toolShovelDiamond = new ItemToolShovel("tool.shovel.diamond", 16405, ToolMaterial.diamond).setIconCoord(3, 5);
    public static Item toolPickaxeDiamond = new ItemToolPickaxe("tool.pickaxe.diamond", 16406, ToolMaterial.diamond).setIconCoord(3, 6);
    public static Item toolAxeDiamond = new ItemToolAxe("tool.axe.diamond", 16407, ToolMaterial.diamond).setIconCoord(3, 7);
    public static Item stick = new Item("stick", 16408).setIconCoord(5, 3).setFull3D();
    public static Item bowl = new Item("bowl", 16409).setIconCoord(7, 4);
    public static Item foodStewMushroom = new ItemSoup("food.stew.mushroom", 16410, 10).setIconCoord(8, 4);
    public static Item toolSwordGold = new ItemToolSword("tool.sword.gold", 16411, ToolMaterial.gold).setIconCoord(4, 4).withTags(ItemTags.preventCreativeMining);
    public static Item toolShovelGold = new ItemToolShovel("tool.shovel.gold", 16412, ToolMaterial.gold).setIconCoord(4, 5);
    public static Item toolPickaxeGold = new ItemToolPickaxe("tool.pickaxe.gold", 16413, ToolMaterial.gold).setIconCoord(4, 6);
    public static Item toolAxeGold = new ItemToolAxe("tool.axe.gold", 16414, ToolMaterial.gold).setIconCoord(4, 7);
    public static Item string = new Item("string", 16415).setIconCoord(8, 0);
    public static Item featherChicken = new Item("feather.chicken", 16416).setIconCoord(8, 1);
    public static Item sulphur = new Item("sulphur", 16417).setIconCoord(8, 2);
    public static Item toolHoeWood = new ItemToolHoe("tool.hoe.wood", 16418, ToolMaterial.wood).setIconCoord(0, 8);
    public static Item toolHoeStone = new ItemToolHoe("tool.hoe.stone", 16419, ToolMaterial.stone).setIconCoord(1, 8);
    public static Item toolHoeIron = new ItemToolHoe("tool.hoe.iron", 16420, ToolMaterial.iron).setIconCoord(2, 8);
    public static Item toolHoeDiamond = new ItemToolHoe("tool.hoe.diamond", 16421, ToolMaterial.diamond).setIconCoord(3, 8);
    public static Item toolHoeGold = new ItemToolHoe("tool.hoe.gold", 16422, ToolMaterial.gold).setIconCoord(4, 8);
    public static Item seedsWheat = new ItemSeeds("seeds.wheat", 16423, Block.cropsWheat).setIconCoord(9, 0);
    public static Item wheat = new Item("wheat", 16424).setIconCoord(9, 1);
    public static Item foodBread = new ItemFood("food.bread", 16425, 5, false).setIconCoord(9, 2);
    public static Item armorHelmetLeather = new ItemArmor("armor.helmet.leather", 16426, ArmorMaterial.leather, 0).setIconCoord(0, 0);
    public static Item armorChestplateLeather = new ItemArmor("armor.chestplate.leather", 16427, ArmorMaterial.leather, 1).setIconCoord(0, 1);
    public static Item armorLeggingsLeather = new ItemArmor("armor.leggings.leather", 16428, ArmorMaterial.leather, 2).setIconCoord(0, 2);
    public static Item armorBootsLeather = new ItemArmor("armor.boots.leather", 16429, ArmorMaterial.leather, 3).setIconCoord(0, 3);
    public static Item armorHelmetChainmail = new ItemArmor("armor.helmet.chainmail", 16430, ArmorMaterial.chainmail, 0).setIconCoord(1, 0);
    public static Item armorChestplateChainmail = new ItemArmor("armor.chestplate.chainmail", 16431, ArmorMaterial.chainmail, 1).setIconCoord(1, 1);
    public static Item armorLeggingsChainmail = new ItemArmor("armor.leggings.chainmail", 16432, ArmorMaterial.chainmail, 2).setIconCoord(1, 2);
    public static Item armorBootsChainmail = new ItemArmor("armor.boots.chainmail", 16433, ArmorMaterial.chainmail, 3).setIconCoord(1, 3);
    public static Item armorHelmetIron = new ItemArmor("armor.helmet.iron", 16434, ArmorMaterial.iron, 0).setIconCoord(2, 0);
    public static Item armorChestplateIron = new ItemArmor("armor.chestplate.iron", 16435, ArmorMaterial.iron, 1).setIconCoord(2, 1);
    public static Item armorLeggingsIron = new ItemArmor("armor.leggings.iron", 16436, ArmorMaterial.iron, 2).setIconCoord(2, 2);
    public static Item armorBootsIron = new ItemArmor("armor.boots.iron", 16437, ArmorMaterial.iron, 3).setIconCoord(2, 3);
    public static Item armorHelmetDiamond = new ItemArmor("armor.helmet.diamond", 16438, ArmorMaterial.diamond, 0).setIconCoord(3, 0);
    public static Item armorChestplateDiamond = new ItemArmor("armor.chestplate.diamond", 16439, ArmorMaterial.diamond, 1).setIconCoord(3, 1);
    public static Item armorLeggingsDiamond = new ItemArmor("armor.leggings.diamond", 16440, ArmorMaterial.diamond, 2).setIconCoord(3, 2);
    public static Item armorBootsDiamond = new ItemArmor("armor.boots.diamond", 16441, ArmorMaterial.diamond, 3).setIconCoord(3, 3);
    public static Item armorHelmetGold = new ItemArmor("armor.helmet.gold", 16442, ArmorMaterial.gold, 0).setIconCoord(4, 0);
    public static Item armorChestplateGold = new ItemArmor("armor.chestplate.gold", 16443, ArmorMaterial.gold, 1).setIconCoord(4, 1);
    public static Item armorLeggingsGold = new ItemArmor("armor.leggings.gold", 16444, ArmorMaterial.gold, 2).setIconCoord(4, 2);
    public static Item armorBootsGold = new ItemArmor("armor.boots.gold", 16445, ArmorMaterial.gold, 3).setIconCoord(4, 3);
    public static Item flint = new Item("flint", 16446).setIconCoord(6, 0);
    public static Item foodPorkchopRaw = new ItemFood("food.porkchop.raw", 16447, 3, true).setIconCoord(7, 5);
    public static Item foodPorkchopCooked = new ItemFood("food.porkchop.cooked", 16448, 8, true).setIconCoord(8, 5);
    public static Item painting = new ItemPainting("painting", 16449).setIconCoord(10, 1);
    public static Item foodAppleGold = new ItemFood("food.apple.gold", 16450, 42, false).setIconCoord(11, 0);
    public static Item sign = new ItemSign("sign", 16451).setIconCoord(10, 2);
    public static Item doorOak = new ItemDoor("door.oak", 16452, Material.wood).setIconCoord(11, 2);
    public static Item bucket = new ItemBucketEmpty("bucket", 16453).setIconCoord(10, 4);
    public static Item bucketWater = new ItemBucket("bucket.water", 16454, Block.fluidWaterFlowing).setIconCoord(11, 4).setContainerItem(bucket);
    public static Item bucketLava = new ItemBucket("bucket.lava", 16455, Block.fluidLavaFlowing).setIconCoord(12, 4).setContainerItem(bucket).withTags(ItemTags.renderFullbright);
    public static Item minecart = new ItemMinecart("minecart", 16456, 0).setIconCoord(7, 8);
    public static Item saddle = new ItemSaddle("saddle", 16457).setIconCoord(8, 6);
    public static Item doorIron = new ItemDoor("door.iron", 16458, Material.metal).setIconCoord(12, 2);
    public static Item dustRedstone = new ItemPlaceable("dust.redstone", 16459, Block.wireRedstone).setIconCoord(8, 3);
    public static Item ammoSnowball = new ItemSnowball("ammo.snowball", 16460).setIconCoord(14, 0);
    public static Item boat = new ItemBoat("boat", 16461).setIconCoord(8, 8);
    public static Item leather = new Item("leather", 16462).setIconCoord(7, 6);
    public static Item bucketMilk = new ItemBucket("bucket.milk", 16463, null).setIconCoord(13, 4).setContainerItem(bucket);
    public static Item brickClay = new Item("brick.clay", 16464).setIconCoord(6, 1);
    public static Item clay = new Item("clay", 16465).setIconCoord(9, 3);
    public static Item sugarcane = new ItemPlaceable("sugarcane", 16466, Block.sugarcane).setIconCoord(11, 1);
    public static Item paper = new Item("paper", 16467).setIconCoord(10, 3);
    public static Item book = new Item("book", 16468).setIconCoord(11, 3);
    public static Item slimeball = new Item("slimeball", 16469).setIconCoord(14, 1);
    public static Item minecartChest = new ItemMinecart("minecart.chest", 16470, 1).setIconCoord(7, 9);
    public static Item minecartFurnace = new ItemMinecart("minecart.furnace", 16471, 2).setIconCoord(7, 10);
    public static Item eggChicken = new ItemEgg("egg.chicken", 16472).setIconCoord(12, 0);
    public static Item toolCompass = new Item("tool.compass", 16473).setIconCoord(6, 3);
    public static Item toolFishingrod = new ItemFishingRod("tool.fishingrod", 16474).setIconCoord(5, 4);
    public static Item toolClock = new Item("tool.clock", 16475).setIconCoord(6, 4);
    public static Item dustGlowstone = new Item("dust.glowstone", 16476).setIconCoord(9, 4).withTags(ItemTags.renderFullbright);
    public static Item foodFishRaw = new ItemFoodStackable("food.fish.raw", 16477, 2, false, 4).setIconCoord(9, 5);
    public static Item foodFishCooked = new ItemFoodStackable("food.fish.cooked", 16478, 5, false, 4).setIconCoord(10, 5);
    public static Item dye = new ItemDye("dye", 16479).setIconCoord(14, 4);
    public static Item bone = new Item("bone", 16480).setIconCoord(12, 1).setFull3D();
    public static Item dustSugar = new Item("dust.sugar", 16481).setIconCoord(13, 0);
    public static Item foodCake = new ItemPlaceable("food.cake", 16482, Block.cake).setMaxStackSize(1).setIconCoord(13, 1);
    public static Item bed = new ItemBed("bed", 16483).setMaxStackSize(1).setIconCoord(13, 2);
    public static Item repeater = new ItemPlaceable("repeater", 16484, Block.repeaterIdle).setIconCoord(6, 5);
    public static Item foodCookie = new ItemFoodStackable("food.cookie", 16485, 1, false, 8).setIconCoord(12, 5);
    public static ItemMap map = (ItemMap)new ItemMap("map", 16486).setIconCoord(12, 3);
    public static ItemToolShears toolShears = (ItemToolShears)new ItemToolShears("tool.shears", 16487).setIconCoord(13, 5);
    public static Item record13 = new ItemRecord("record.13", 18384, "13").setIconCoord(0, 15);
    public static Item recordCat = new ItemRecord("record.cat", 18385, "cat").setIconCoord(1, 15);
    public static Item recordBlocks = new ItemRecord("record.blocks", 18386, "blocks").setIconCoord(2, 15);
    public static Item recordChirp = new ItemRecord("record.chirp", 18387, "chirp").setIconCoord(3, 15);
    public static Item recordFar = new ItemRecord("record.far", 18388, "far").setIconCoord(4, 15);
    public static Item recordMall = new ItemRecord("record.mall", 18389, "mall").setIconCoord(5, 15);
    public static Item recordMellohi = new ItemRecord("record.mellohi", 18390, "mellohi").setIconCoord(6, 15);
    public static Item recordStal = new ItemRecord("record.stal", 18391, "stal").setIconCoord(7, 15);
    public static Item recordStrad = new ItemRecord("record.strad", 18392, "strad").setIconCoord(8, 15);
    public static Item recordWard = new ItemRecord("record.ward", 18393, "ward").setIconCoord(9, 15);
    public static Item recordWait = new ItemRecord("record.wait", 18394, "wait").setIconCoord(12, 15);
    public static Item recordDog = new ItemRecord("record.dog", 18395, "dog").setIconCoord(11, 15);
    public static Item nethercoal = new Item("nethercoal", 16488).setIconCoord(5, 6).withTags(ItemTags.renderFullbright);
    public static Item armorHelmetSteel = new ItemArmor("armor.helmet.steel", 16489, ArmorMaterial.steel, 0).setIconCoord(1, 9);
    public static Item armorChestplateSteel = new ItemArmor("armor.chestplate.steel", 16490, ArmorMaterial.steel, 1).setIconCoord(1, 10);
    public static Item armorLeggingsSteel = new ItemArmor("armor.leggings.steel", 16491, ArmorMaterial.steel, 2).setIconCoord(1, 11);
    public static Item armorBootsSteel = new ItemArmor("armor.boots.steel", 16492, ArmorMaterial.steel, 3).setIconCoord(1, 12);
    public static Item toolSwordSteel = new ItemToolSword("tool.sword.steel", 16493, ToolMaterial.steel).setIconCoord(0, 9).withTags(ItemTags.preventCreativeMining);
    public static Item toolShovelSteel = new ItemToolShovel("tool.shovel.steel", 16494, ToolMaterial.steel).setIconCoord(0, 10);
    public static Item toolPickaxeSteel = new ItemToolPickaxe("tool.pickaxe.steel", 16495, ToolMaterial.steel).setIconCoord(0, 11);
    public static Item toolAxeSteel = new ItemToolAxe("tool.axe.steel", 16496, ToolMaterial.steel).setIconCoord(0, 12);
    public static Item toolHoeSteel = new ItemToolHoe("tool.hoe.steel", 16497, ToolMaterial.steel).setIconCoord(0, 13);
    public static Item ingotSteel = new Item("ingot.steel", 16498).setIconCoord(7, 7);
    public static Item ingotSteelCrude = new Item("ingot.steel.crude", 16499).setIconCoord(8, 7);
    public static Item ammoFireball = new Item("ammo.fireball", 16500).setIconCoord(14, 2).setNotInCreativeMenu().withTags(ItemTags.renderFullbright);
    public static Item armorQuiverGold = new ItemQuiverEndless("armor.quiver.gold", 16501).setIconCoord(4, 9);
    public static Item handcannonUnloaded = new ItemHandCannonUnloaded("handcannon.unloaded", 16502).setIconCoord(5, 8);
    public static Item chainlink = new Item("chainlink", 16503).setIconCoord(9, 7);
    public static Item cloth = new Item("cloth", 16504).setIconCoord(9, 6);
    public static Item ammoChargeExplosive = new Item("ammo.charge.explosive", 16505).setIconCoord(6, 8).setMaxStackSize(16);
    public static Item handcannonLoaded = new ItemHandCannonLoaded("handcannon.loaded", 16506).setIconCoord(5, 9).setNotInCreativeMenu().withTags(ItemTags.renderFullbright);
    public static Item ammoArrowGold = new Item("ammo.arrow.gold", 16507).setIconCoord(5, 7);
    public static Item armorQuiver = new ItemQuiver("armor.quiver", 16508).setIconCoord(6, 2);
    public static Item toolCalendar = new Item("tool.calendar", 16509).setIconCoord(6, 7);
    public static Item oreRawGold = new Item("ore.raw.gold", 16510).setIconCoord(10, 8);
    public static Item oreRawIron = new Item("ore.raw.iron", 16511).setIconCoord(9, 8);
    public static Item quartz = new Item("quartz", 16512).setIconCoord(11, 5);
    public static Item olivine = new Item("olivine", 16513).setIconCoord(11, 6);
    public static Item ammoPebble = new ItemPebble("ammo.pebble", 16514).setIconCoord(10, 6);
    public static Item cherry = new ItemFoodStackable("food.cherry", 16515, 2, false, 2).setIconCoord(10, 7);
    public static Item bucketIcecream = new ItemBucketIceCream("bucket.icecream", 16516, 10).setIconCoord(12, 6).setContainerItem(bucket);
    public static Item ammoArrowPurple = new Item("ammo.arrow.purple", 16517).setIconCoord(4, 10).setNotInCreativeMenu();
    public static Item label = new ItemLabel("label", 16518).setIconCoord(8, 9);
    public static Item jar = new ItemJar("jar", 16519).setIconCoord(3, 9);
    public static Item lanternFireflyGreen = new ItemPlaceable("lantern.firefly.green", 16520, Block.lanternFireflyGreen).setIconCoord(3, 10).withTags(ItemTags.renderFullbright);
    public static Item lanternFireflyBlue = new ItemPlaceable("lantern.firefly.blue", 16521, Block.lanternFireflyBlue).setIconCoord(3, 11).withTags(ItemTags.renderFullbright);
    public static Item lanternFireflyOrange = new ItemPlaceable("lantern.firefly.orange", 16522, Block.lanternFireflyOrange).setIconCoord(3, 12).withTags(ItemTags.renderFullbright);
    public static Item lanternFireflyRed = new ItemPlaceable("lantern.firefly.red", 16523, Block.lanternFireflyRed).setIconCoord(3, 13).withTags(ItemTags.renderFullbright);
    public static Item basket = new ItemPlaceable("basket", 16525, Block.basket).setIconCoord(12, 7);
    public static Item flag = new ItemFlag("flag", 16526).setIconCoord(11, 8).setFull3D();
    public static Item armorBootsIceskates = new ItemArmor("armor.boots.iceskates", 16527, ArmorMaterial.leather, 3).setIconCoord(6, 6);
    public static ItemToolShears toolShearsSteel = (ItemToolShears)new ItemToolShears("tool.shears.steel", 16528).setMaxDamage(4608).setIconCoord(2, 9);
    public static Item toolFirestrikerSteel = new ItemFirestriker("tool.firestriker.steel", 16529).setMaxDamage(4608).setIconCoord(2, 10);
    public static int highestItemId = 0;
    public int id;
    protected int maxStackSize = 64;
    private int maxDamage = 0;
    protected int iconIndex;
    protected boolean bFull3D = false;
    protected boolean hasSubtypes = false;
    private Item containerItem = null;
    private String key;
    public boolean notInCreativeMenu;

    public Item(int id) {
        this.id = id;
        if (itemsList[this.id] != null) {
            System.out.println("CONFLICT @ " + this.id);
        }
        Item.itemsList[this.id] = this;
        if (this.id > highestItemId) {
            highestItemId = this.id;
        }
    }

    public Item(String name, int id) {
        this(id);
        this.setKey(name);
    }

    public Item withTags(Tag<Item> ... tags) {
        for (Tag<Item> tag : tags) {
            tag.tag(this);
        }
        return this;
    }

    public boolean hasTag(Tag<Item> tag) {
        return tag.appliesTo(this);
    }

    public Item setIconIndex(int i) {
        this.iconIndex = i;
        return this;
    }

    public Item setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
        return this;
    }

    public static int iconCoordToIndex(int x, int y) {
        return x + y * Global.TEXTURE_ATLAS_WIDTH_TILES;
    }

    public Item setIconCoord(int x, int y) {
        this.iconIndex = Item.iconCoordToIndex(x, y);
        return this;
    }

    public int getIconFromDamage(int id) {
        return this.iconIndex;
    }

    public int getIconIndex(ItemStack itemstack) {
        return this.getIconFromDamage(itemstack.getMetadata());
    }

    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        return false;
    }

    public float getStrVsBlock(ItemStack itemstack, Block block) {
        return 1.0f;
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        return itemstack;
    }

    public int getItemStackLimit() {
        return this.maxStackSize;
    }

    public int getPlacedBlockMetadata(int i) {
        return 0;
    }

    public boolean getHasSubtypes() {
        return this.hasSubtypes;
    }

    protected Item setHasSubtypes(boolean flag) {
        this.hasSubtypes = flag;
        return this;
    }

    public int getMaxDamage() {
        return this.maxDamage;
    }

    protected Item setMaxDamage(int i) {
        this.maxDamage = i;
        return this;
    }

    public boolean isDamagable() {
        return this.maxDamage > 0 && !this.hasSubtypes;
    }

    public boolean hitEntity(ItemStack itemstack, EntityLiving entityliving, EntityLiving entityliving1) {
        return false;
    }

    public boolean onBlockDestroyed(ItemStack itemstack, int id, int x, int y, int z, EntityLiving entityliving) {
        return false;
    }

    public int getDamageVsEntity(Entity entity) {
        return 1;
    }

    public boolean canHarvestBlock(Block block) {
        return false;
    }

    public boolean useItemOnEntity(ItemStack itemstack, EntityLiving entityliving, EntityPlayer entityPlayer) {
        return false;
    }

    public Item setFull3D() {
        this.bFull3D = true;
        return this;
    }

    public boolean isFull3D() {
        return this.bFull3D;
    }

    public boolean shouldRotateAroundWhenRendering() {
        return false;
    }

    public boolean shouldPointInFrontOfPlayer() {
        return false;
    }

    public Item setKey(String s) {
        this.key = "item." + s;
        nameToIdMap.put(this.key, this.id);
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public String getLanguageKey(ItemStack itemstack) {
        return this.key;
    }

    public CompoundTag getDefaultTag() {
        return new CompoundTag();
    }

    public Item setContainerItem(Item item) {
        if (this.maxStackSize > 1) {
            throw new IllegalArgumentException("Max stack size must be 1 for items with crafting results");
        }
        this.containerItem = item;
        return this;
    }

    public Item getContainerItem() {
        return this.containerItem;
    }

    public boolean hasContainerItem() {
        return this.containerItem != null;
    }

    public String getStatName() {
        return I18n.getInstance().translateNameKey(this.getKey());
    }

    public int getColorFromDamage(int i) {
        return 0xFFFFFF;
    }

    public Item setNotInCreativeMenu() {
        this.notInCreativeMenu = true;
        return this;
    }

    public void inventoryTick(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
    }

    public void onCraftedBy(ItemStack itemstack, World world, EntityPlayer entityplayer) {
    }

    public boolean func_28019_b() {
        return false;
    }

    public boolean isSilkTouch() {
        return false;
    }

    public int getBlockHitDelay() {
        return 5;
    }

    public boolean hasInventoryInteraction() {
        return false;
    }

    public ItemStack onInventoryInteract(EntityPlayer player, Slot slot, ItemStack stackInSlot, boolean isItemGrabbed) {
        return stackInSlot;
    }

    public boolean showFullDurability() {
        return false;
    }

    @Override
    public boolean isIn(Tag<Item> tag) {
        return tag.appliesTo(this);
    }

    @Override
    public Item asItem() {
        return this;
    }

    @Override
    public ItemStack getDefaultStack() {
        return new ItemStack(this);
    }

    static {
        StatList.onItemInit();
    }
}

