/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.block;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class ItemBlock
extends Item {
    protected int blockID;

    public ItemBlock(Block block) {
        super(block.id);
        this.blockID = block.id;
        this.setIconIndex(block.getBlockTextureFromSideAndMetadata(Side.NORTH, 0));
        this.setKey(block.getKey());
    }

    public Block getBlock() {
        return Block.blocksList[this.blockID];
    }

    @Override
    public int getColorFromDamage(int i) {
        Block block = Block.blocksList[this.blockID];
        return ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(block)).getFallbackColor(i);
    }

    @Override
    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (stack.stackSize <= 0) {
            return false;
        }
        if (!world.canPlaceInsideBlock(blockX, blockY, blockZ)) {
            blockX += side.getOffsetX();
            blockY += side.getOffsetY();
            blockZ += side.getOffsetZ();
        }
        if (blockY < 0 || blockY >= world.getHeightBlocks()) {
            return false;
        }
        if (world.canBlockBePlacedAt(this.blockID, blockX, blockY, blockZ, false, side) && stack.consumeItem(player)) {
            Block block = Block.blocksList[this.blockID];
            if (world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, this.blockID, this.getPlacedBlockMetadata(stack.getMetadata()))) {
                block.onBlockPlaced(world, blockX, blockY, blockZ, side, player, yPlaced);
                world.playBlockSoundEffect((float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, block, EnumBlockSoundEffectType.PLACE);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getLanguageKey(ItemStack itemstack) {
        return Block.blocksList[this.blockID].getLanguageKey(itemstack.getMetadata());
    }

    @Override
    public String getKey() {
        return Block.blocksList[this.blockID].getKey();
    }
}

