/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.tool;

import net.minecraft.core.block.Block;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ToolMaterial;

public class ItemTool
extends Item {
    private final Tag<Block> tagEffectiveAgainst;
    private final int damageVsEntity;
    protected ToolMaterial material;

    protected ItemTool(String name, int id, int damageDealt, ToolMaterial toolMaterial, Tag<Block> tagEffectiveAgainst) {
        super(name, id);
        this.material = toolMaterial;
        this.tagEffectiveAgainst = tagEffectiveAgainst;
        this.maxStackSize = 1;
        this.setMaxDamage(toolMaterial.getDurability());
        this.damageVsEntity = damageDealt + toolMaterial.getDamage();
    }

    @Override
    public float getStrVsBlock(ItemStack itemstack, Block block) {
        if (block.hasTag(this.tagEffectiveAgainst)) {
            return this.material.getEfficiency(false);
        }
        return 1.0f;
    }

    @Override
    public boolean hitEntity(ItemStack itemstack, EntityLiving entityliving, EntityLiving entityliving1) {
        itemstack.damageItem(2, entityliving1);
        return true;
    }

    @Override
    public boolean onBlockDestroyed(ItemStack itemstack, int i, int j, int k, int l, EntityLiving entityliving) {
        Block block = Block.blocksList[i];
        if (block != null && (block.getHardness() > 0.0f || this.isSilkTouch())) {
            itemstack.damageItem(1, entityliving);
        }
        return true;
    }

    @Override
    public int getDamageVsEntity(Entity entity) {
        return this.damageVsEntity;
    }

    @Override
    public boolean isFull3D() {
        return true;
    }

    @Override
    public boolean isSilkTouch() {
        return this.material.isSilkTouch();
    }

    @Override
    public int getBlockHitDelay() {
        return this.material.getBlockHitDelay();
    }
}

