/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.core.lang.I18n;

public class Language {
    protected List<String> reportedMissingTranslations = new ArrayList<String>();
    protected final Properties entries;
    private final String id;
    private final String name;
    private final String region;
    private final List<String> credits;

    Language(String id, String name, String region, List<String> credits, ZipFile zipFile) {
        this.id = id;
        this.name = name;
        this.region = region;
        this.credits = credits;
        this.entries = new Properties();
        if (zipFile != null) {
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry entry = zipEntries.nextElement();
                if (!entry.getName().endsWith(".lang")) continue;
                try {
                    InputStream in = zipFile.getInputStream(entry);
                    try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
                        this.entries.load(reader);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                zipFile.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String translateKey(String key) {
        if (key == null) {
            return null;
        }
        String ret = this.entries.getProperty(key);
        if (ret == null) {
            if (!this.reportedMissingTranslations.contains(key)) {
                System.err.println("Missing translation: " + key + "\n at " + Thread.currentThread().getStackTrace()[2]);
                this.reportedMissingTranslations.add(key);
            }
            return Default.INSTANCE.translateKey(key);
        }
        return ret;
    }

    public String translateKeyAndFormat(String formatKey, Object ... args) {
        String format = this.entries.getProperty(formatKey, formatKey);
        if (formatKey.equals(format)) {
            format = Default.INSTANCE.entries.getProperty(formatKey, formatKey);
        }
        return String.format(format, args);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getCredits() {
        return this.credits;
    }

    public String getRegion() {
        return this.region;
    }

    public int keySize() {
        return this.entries.size();
    }

    void onReload() {
    }

    public boolean isDefault() {
        return false;
    }

    public static final class Default
    extends Language {
        public static final Default INSTANCE = new Default();

        private Default() {
            super("en_US", "English", "US", Arrays.asList("Mojang", "jonkadelic", "skydeckagogo"), null);
            this.entries.clear();
            for (String path : I18n.getFilesInDirectory("/lang/en_US/")) {
                if (!path.endsWith(".lang")) continue;
                try (InputStream stream = I18n.getResourceAsStream(path);
                     InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                    this.entries.load(reader);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public String translateKey(String key) {
            if (key == null) {
                return null;
            }
            String ret = this.entries.getProperty(key);
            if (ret == null) {
                if (!this.reportedMissingTranslations.contains(key)) {
                    this.reportedMissingTranslations.add(key);
                    System.err.println("Missing translation in default language: " + key + "\n at " + Thread.currentThread().getStackTrace()[3]);
                }
                return key;
            }
            return ret;
        }

        @Override
        public boolean isDefault() {
            return true;
        }
    }
}

