/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.lang.text;

import java.util.Stack;
import net.minecraft.core.lang.text.Text;
import net.minecraft.core.net.command.TextFormatting;

public class TextFormatted
extends Text {
    private static final Stack<TextFormatting> stack = new Stack();
    private final TextFormatting formatting;
    private final Text text;

    public TextFormatted(Text text, TextFormatting formatting) {
        this.text = text;
        this.formatting = formatting;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        stack.push(this.formatting);
        sb.append(this.formatting.toString());
        sb.append(this.text.toString());
        stack.pop();
        sb.append(stack.peek().toString());
        return sb.toString();
    }

    @Override
    public String toDebugString() {
        return "F" + this.formatting.code + "{" + this.text.toDebugString() + "}";
    }

    @Override
    public Text copy() {
        return new TextFormatted(this.text.copy(), this.formatting);
    }
}

