/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command;

import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.packet.Packet3Chat;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.world.World;
import net.minecraft.server.MinecraftServer;

public class ServerCommandHandler
implements CommandHandler {
    public final MinecraftServer minecraftServer;

    public ServerCommandHandler(MinecraftServer minecraftServer) {
        this.minecraftServer = minecraftServer;
    }

    @Override
    public void sendMessageToAdmins(String msg) {
        this.minecraftServer.configManager.sendChatMessageToAllOps(msg);
    }

    @Override
    public EntityPlayer getPlayer(String name) {
        return this.minecraftServer.configManager.getPlayerEntity(name);
    }

    @Override
    public void sendMessageToAllPlayers(String msg) {
        this.minecraftServer.configManager.sendEncryptedChatToAllPlayers(msg);
    }

    @Override
    public void sendMessageToPlayer(EntityPlayer player, String messsage) {
        this.minecraftServer.configManager.sendPacketToPlayer(player.username, new Packet3Chat(messsage, AES.keyChain.get(player.username)));
    }

    @Override
    public boolean playerExists(String name) {
        return this.minecraftServer.configManager.getPlayerEntity(name) != null;
    }

    @Override
    public void sendCommandFeedback(CommandSender sender, String message) {
        sender.sendMessage(message);
        String message2 = "\u00a77" + sender.getName() + ": " + message;
        for (EntityPlayer entityPlayer : this.minecraftServer.configManager.playerEntities) {
            if (!this.minecraftServer.configManager.isOp(entityPlayer.username) || sender.getPlayer() != null && sender.getPlayer() == entityPlayer) continue;
            this.sendMessageToPlayer(entityPlayer, message2);
        }
        this.minecraftServer.log(message2);
    }

    @Override
    public World getWorld(int dimension) {
        return this.minecraftServer.getWorldManager(dimension);
    }
}

