/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.world.World;

public class Packet53BlockChange
extends Packet {
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public int type;
    public int metadata;

    public Packet53BlockChange() {
        this.isChunkDataPacket = true;
    }

    public Packet53BlockChange(int i, int j, int k, World world) {
        this.isChunkDataPacket = true;
        this.xPosition = i;
        this.yPosition = j;
        this.zPosition = k;
        this.type = world.getBlockId(i, j, k);
        this.metadata = world.getBlockMetadata(i, j, k);
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        this.xPosition = dis.readInt();
        this.yPosition = dis.read();
        this.zPosition = dis.readInt();
        this.type = dis.readShort();
        this.metadata = dis.read();
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        dos.writeInt(this.xPosition);
        dos.write(this.yPosition);
        dos.writeInt(this.zPosition);
        dos.writeShort(this.type);
        dos.write(this.metadata);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleBlockChange(this);
    }

    @Override
    public int getPacketSize() {
        return 11;
    }
}

