/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.gamemode;

import net.minecraft.core.player.gamemode.GamemodeCreative;
import net.minecraft.core.player.gamemode.GamemodeSurvival;
import net.minecraft.core.player.inventory.ContainerPlayer;
import net.minecraft.core.player.inventory.InventoryPlayer;

public abstract class Gamemode {
    public int id;
    public String languageKey = "";
    public boolean isPlayerInvulnerable = false;
    public boolean canPlayerFly = false;
    public boolean consumeBlocks = false;
    public boolean doBlockBreakingAnim = false;
    public boolean toolDurability = false;
    public boolean dropBlockOnBreak = false;
    public boolean areMobsHostile = false;
    public boolean isImmuneToFire = false;
    public boolean instantPortalTravel = false;
    public float blockReachDistance = 4.5f;
    public float entityReachDistance = 3.0f;
    public static final Gamemode[] gamemodesList = new Gamemode[2];
    public static final Gamemode survival = new GamemodeSurvival(0).setLanguageKey("gamemode.survival").setConsumeBlocks().setDoBlockBreakingAnim().setToolDurability().setDropBlockOnBreak().setAreMobsHostile();
    public static final Gamemode creative = new GamemodeCreative(1).setLanguageKey("gamemode.creative").setIsPlayerInvulnerable().setCanPlayerFly().setIsImmuneToFire().setInstantPortalTravel().setBlockReachDistance(6.0f).setEntityReachDistance(4.5f);

    public Gamemode(int id) {
        this.id = id;
        Gamemode.gamemodesList[id] = this;
    }

    public Gamemode setLanguageKey(String key) {
        this.languageKey = key;
        return this;
    }

    public Gamemode setIsPlayerInvulnerable() {
        this.isPlayerInvulnerable = true;
        return this;
    }

    public Gamemode setCanPlayerFly() {
        this.canPlayerFly = true;
        return this;
    }

    public Gamemode setConsumeBlocks() {
        this.consumeBlocks = true;
        return this;
    }

    public Gamemode setDoBlockBreakingAnim() {
        this.doBlockBreakingAnim = true;
        return this;
    }

    public Gamemode setToolDurability() {
        this.toolDurability = true;
        return this;
    }

    public Gamemode setDropBlockOnBreak() {
        this.dropBlockOnBreak = true;
        return this;
    }

    public Gamemode setAreMobsHostile() {
        this.areMobsHostile = true;
        return this;
    }

    public Gamemode setIsImmuneToFire() {
        this.isImmuneToFire = true;
        return this;
    }

    public Gamemode setInstantPortalTravel() {
        this.instantPortalTravel = true;
        return this;
    }

    public Gamemode setBlockReachDistance(float blockReachDistance) {
        this.blockReachDistance = blockReachDistance;
        return this;
    }

    public Gamemode setEntityReachDistance(float entityReachDistance) {
        this.entityReachDistance = entityReachDistance;
        return this;
    }

    public abstract ContainerPlayer getContainer(InventoryPlayer var1, boolean var2);
}

