/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.helper;

import com.b100.json.JsonParser;
import com.b100.json.element.JsonArray;
import com.b100.json.element.JsonObject;
import com.b100.utils.StringUtils;
import java.util.Base64;
import net.minecraft.core.entity.monster.EntityHuman;

public class GetMonsterSkinUrlThread
extends Thread {
    private static int counter = 0;
    private static final String urlUUID = "https://api.mojang.com/users/profiles/minecraft/";
    private static final String urlSkin = "https://sessionserver.mojang.com/session/minecraft/profile/";
    private static final JsonParser jsonParser = new JsonParser();
    private EntityHuman monster;
    private String uuid;

    public GetMonsterSkinUrlThread(EntityHuman monster) {
        this.monster = monster;
        this.setDaemon(true);
        this.setName("GetSkinUrlThread " + counter++);
        this.start();
    }

    @Override
    public void run() {
        String string;
        String name = this.monster.nickname;
        if (name == null || name.length() == 0) {
            return;
        }
        try {
            string = StringUtils.getWebsiteContentAsString(urlUUID + name);
        }
        catch (Exception e2) {
            System.err.println("Can't connect to Mojang API.");
            e2.printStackTrace();
            return;
        }
        if (string.length() == 0) {
            System.err.println("Player " + name + " doesn't exist!");
            return;
        }
        try {
            this.uuid = jsonParser.parse(string).getString("id");
        }
        catch (Exception e3) {
            e3.printStackTrace();
            return;
        }
        if (this.uuid == null) {
            return;
        }
        System.out.println("Loading Skin for Player " + name + "...");
        try {
            string = StringUtils.getWebsiteContentAsString(urlSkin + this.uuid);
        }
        catch (Exception e4) {
            System.err.println("Invalid UUID " + this.uuid + ", or can't connect to the Mojang API.");
            return;
        }
        JsonObject object = jsonParser.parse(string);
        JsonArray properties = object.getArray("properties");
        JsonObject textureProperty = properties.query(e -> e.getAsObject().getString("name").equalsIgnoreCase("textures")).getAsObject();
        JsonObject texturesObject = jsonParser.parse(GetMonsterSkinUrlThread.decodeBase64(textureProperty.getString("value"))).getObject("textures");
        if (texturesObject.has("SKIN")) {
            this.monster.skinUrl = texturesObject.getObject("SKIN").getString("url");
        }
        System.out.println("Skin URL: " + this.monster.skinUrl);
    }

    public static String decodeBase64(String string) {
        return new String(Base64.getDecoder().decode(string));
    }
}

