/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world;

import com.mojang.nbt.CompoundTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.world.chunk.provider.ChunkProviderStatic;
import net.minecraft.core.Global;
import net.minecraft.core.HitResult;
import net.minecraft.core.NextTickListEntry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockFluid;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.animal.EntityFireflyCluster;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.AuroraProvider;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.Explosion;
import net.minecraft.core.world.ExplosionCannonball;
import net.minecraft.core.world.IProgressUpdate;
import net.minecraft.core.world.LevelListener;
import net.minecraft.core.world.SpawnerMobs;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.ChunkCache;
import net.minecraft.core.world.chunk.ChunkCoordIntPair;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.chunk.LightUpdate;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.pathfinder.Path;
import net.minecraft.core.world.pathfinder.PathFinder;
import net.minecraft.core.world.save.DimensionData;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.save.LevelStorage;
import net.minecraft.core.world.saveddata.SavedData;
import net.minecraft.core.world.saveddata.SavedDataStorage;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.season.SeasonManager;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.weather.Weather;

public class World
implements WorldSource {
    public static boolean AUTOSAVE = true;
    private final int heightBlocks = 256;
    private int heightBits = -1;
    private final List<LightUpdate> lightingToUpdate = new LinkedList<LightUpdate>();
    public List<Entity> loadedEntityList = new ArrayList<Entity>();
    private final List<Entity> unloadedEntityList = new ArrayList<Entity>();
    private final TreeSet<NextTickListEntry> scheduledTickTreeSet = new TreeSet();
    private final Set<NextTickListEntry> scheduledTickSet = new HashSet<NextTickListEntry>();
    public List<TileEntity> loadedTileEntityList = new ArrayList<TileEntity>();
    private final List<TileEntity> field_30900_E = new ArrayList<TileEntity>();
    public List<EntityPlayer> players = new ArrayList<EntityPlayer>();
    public List<Entity> weatherEffects = new ArrayList<Entity>();
    public final ArrayList<AABB> collidingBoundingBoxes = new ArrayList();
    public List<LevelListener> listeners = new ArrayList<LevelListener>();
    private final Set<ChunkCoordIntPair> positionsToUpdate = new HashSet<ChunkCoordIntPair>();
    private final List<Entity> entityBuffer = new ArrayList<Entity>();
    public boolean scheduledUpdatesAreImmediate = false;
    private long dimensionColor = 0xFFFFFFL;
    public int skyDarken = 0;
    protected int updateLCG = new Random().nextInt();
    public int lightningFlicker = 0;
    public boolean editingBlocks = false;
    private long lockTimestamp = System.currentTimeMillis();
    public int difficultySetting;
    public Random rand = new Random();
    public boolean isNewWorld = false;
    public final Dimension dimension;
    public final WorldType worldType;
    protected IChunkProvider chunkProvider;
    protected final LevelStorage saveHandler;
    protected LevelData levelData;
    public DimensionData dimensionData;
    public boolean findingSpawnPoint;
    protected boolean enoughPlayersSleeping;
    public SavedDataStorage savedDataStorage;
    private boolean field_31055_L;
    private int lightingUpdatesCounter = 0;
    protected boolean spawnHostileMobs = true;
    private boolean spawnPeacefulMobs = true;
    public boolean mobGriefing = true;
    static int lightingUpdatesScheduled = 0;
    private int caveSoundCounter = this.rand.nextInt(12000);
    public boolean isClientSide = false;
    public int sleepPercent = 100;
    private long runtime = 0L;
    private final BiomeProvider biomeProvider;
    public Weather currentWeather = null;
    public Weather newWeather = null;
    public long weatherDuration = Global.DAY_LENGTH_TICKS;
    public float weatherIntensity = 1.0f;
    public float weatherPower = 1.0f;
    public AuroraProvider auroraProvider;
    public final SeasonManager seasonManager;

    public World(LevelStorage saveHandler, String name, long seed, Dimension dimension, WorldType worldType) {
        this.saveHandler = saveHandler;
        this.savedDataStorage = new SavedDataStorage(saveHandler);
        this.levelData = saveHandler.getLevelData();
        boolean bl = this.isNewWorld = this.levelData == null;
        this.dimension = dimension != null ? dimension : (this.levelData != null ? Dimension.getDimensionList().get(this.levelData.getDimension()) : Dimension.getDimensionList().get(0));
        this.dimensionData = saveHandler.getDimensionData(this.dimension.id);
        this.worldType = worldType != null ? worldType : (this.dimensionData != null ? this.dimensionData.getWorldType() : this.dimension.defaultWorldType);
        boolean isNewWorld = false;
        if (this.levelData == null) {
            this.levelData = new LevelData(seed, name);
            isNewWorld = true;
        } else {
            this.levelData.setWorldName(name);
        }
        if (this.dimensionData == null) {
            this.dimensionData = new DimensionData(this.worldType);
        } else {
            this.currentWeather = this.dimensionData.getCurrentWeather();
            this.newWeather = this.dimensionData.getNextWeather();
            this.weatherDuration = this.dimensionData.getWeatherDuration();
            this.weatherIntensity = this.dimensionData.getWeatherIntensity();
            this.weatherPower = this.dimensionData.getWeatherPower();
        }
        this.chunkProvider = this.createChunkProvider();
        this.auroraProvider = new AuroraProvider(this, seed);
        this.seasonManager = SeasonManager.fromConfig(this, this.worldType.getDefaultSeasonConfig());
        this.biomeProvider = this.worldType.createBiomeProvider(this);
        if (isNewWorld) {
            this.worldType.onWorldCreation(this);
            this.getInitialSpawnLocation();
        }
        this.updateSkyBrightness();
    }

    public World(World world, Dimension dimension) {
        this.lockTimestamp = world.lockTimestamp;
        this.saveHandler = world.saveHandler;
        this.levelData = new LevelData(world.levelData);
        this.dimensionData = world.saveHandler.getDimensionData(dimension.id);
        if (this.dimensionData == null) {
            this.dimensionData = new DimensionData(dimension.defaultWorldType);
        }
        this.currentWeather = this.dimensionData.getCurrentWeather();
        this.newWeather = this.dimensionData.getNextWeather();
        this.weatherDuration = this.dimensionData.getWeatherDuration();
        this.weatherIntensity = this.dimensionData.getWeatherIntensity();
        this.weatherPower = this.dimensionData.getWeatherPower();
        this.worldType = this.dimensionData.getWorldType();
        this.weatherIntensity = this.newWeather != null ? 0.0f : 1.0f;
        this.savedDataStorage = new SavedDataStorage(this.saveHandler);
        this.dimension = dimension;
        this.chunkProvider = this.createChunkProvider();
        this.seasonManager = SeasonManager.fromConfig(this, this.worldType.getDefaultSeasonConfig());
        this.biomeProvider = this.worldType.createBiomeProvider(this);
        this.updateSkyBrightness();
        this.auroraProvider = new AuroraProvider(this, this.getRandomSeed());
    }

    public World(LevelStorage saveHandler, String name, Dimension dimension, WorldType worldType, long seed) {
        this.saveHandler = saveHandler;
        this.levelData = new LevelData(seed, name);
        this.dimension = dimension;
        this.dimensionData = new DimensionData(worldType);
        this.worldType = worldType;
        this.savedDataStorage = new SavedDataStorage(saveHandler);
        this.chunkProvider = this.createChunkProvider();
        this.seasonManager = SeasonManager.fromConfig(this, this.worldType.getDefaultSeasonConfig());
        this.updateSkyBrightness();
        this.auroraProvider = new AuroraProvider(this, seed);
        this.biomeProvider = this.worldType.createBiomeProvider(this);
    }

    public int getHeightBlocks() {
        return 256;
    }

    public int getHeightBits() {
        if (this.heightBits <= 0) {
            this.heightBits = (int)Math.ceil(Math.log(256.0) / Math.log(2.0));
        }
        return this.heightBits;
    }

    @Override
    public BiomeProvider getBiomeProvider() {
        return this.biomeProvider;
    }

    protected IChunkProvider createChunkProvider() {
        IChunkLoader chunkLoader = this.saveHandler.getChunkLoader(this.dimension);
        return Global.accessor.createChunkProvider(this, chunkLoader);
    }

    protected void getInitialSpawnLocation() {
        this.findingSpawnPoint = true;
        this.getWorldType().getInitialSpawnLocation(this);
        this.findingSpawnPoint = false;
    }

    public void getRespawnLocation() {
        this.getWorldType().getRespawnLocation(this);
    }

    public int getTopBlock(int x, int z) {
        int y = this.levelData.getSpawnY() - 1;
        while (!this.isAirBlock(x, y + 1, z)) {
            ++y;
        }
        return this.getBlockId(x, y, z);
    }

    public void spawnPlayerWithLoadedChunks(EntityPlayer player) {
        try {
            CompoundTag nbttagcompound = this.levelData.getPlayerNBTTagCompound();
            if (nbttagcompound != null) {
                player.load(nbttagcompound);
                this.levelData.setPlayerNBTTagCompound(null);
            }
            if (this.chunkProvider instanceof ChunkProviderStatic) {
                ChunkProviderStatic chunkProvider = (ChunkProviderStatic)this.chunkProvider;
                int chunkX = MathHelper.floor_float((int)player.x) >> 4;
                int chunkZ = MathHelper.floor_float((int)player.z) >> 4;
                chunkProvider.setCurrentChunkOver(chunkX, chunkZ);
            }
            this.entityJoinedWorld(player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveWorld(boolean saveImmediately, IProgressUpdate progressUpdate) {
        if (!this.chunkProvider.canSave()) {
            return;
        }
        if (progressUpdate != null) {
            progressUpdate.func_594_b("Saving level data");
        }
        this.saveWorldData();
        if (progressUpdate != null) {
            progressUpdate.displayLoadingString("Saving chunks");
        }
        this.chunkProvider.saveChunks(saveImmediately, progressUpdate);
    }

    private void saveWorldData() {
        this.checkSessionLock();
        this.saveHandler.saveLevelDataAndPlayerData(this.levelData, this.players);
        this.saveHandler.saveDimensionData(this.dimension.id, this.dimensionData);
        this.savedDataStorage.save();
    }

    public boolean func_650_a(int i) {
        if (!this.chunkProvider.canSave()) {
            return true;
        }
        if (i == 0) {
            this.saveWorldData();
        }
        return this.chunkProvider.saveChunks(false, null);
    }

    public Weather getCurrentWeather() {
        return this.currentWeather;
    }

    @Override
    public int getBlockId(int x, int y, int z) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return 0;
        }
        if (y < 0) {
            return 0;
        }
        if (y >= this.getHeightBlocks()) {
            return 0;
        }
        return this.getChunkFromChunkCoords(x >> 4, z >> 4).getBlockID(x & 0xF, y, z & 0xF);
    }

    @Override
    public Block getBlock(int x, int y, int z) {
        return Block.getBlock(this.getBlockId(x, y, z));
    }

    public double getBlockTemperature(int x, int z) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return 0.0;
        }
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        double temperature = Double.NEGATIVE_INFINITY;
        Chunk chunk = null;
        if (this.isChunkLoaded(chunkX, chunkZ)) {
            chunk = this.getChunkFromChunkCoords(chunkX, chunkZ);
            temperature = chunk.getBlockTemperature(x & 0xF, z & 0xF);
        }
        if (temperature == Double.NEGATIVE_INFINITY) {
            temperature = this.getBiomeProvider().getTemperature(x, z);
            if (chunk != null) {
                chunk.setBlockTemperature(x & 0xF, z & 0xF, temperature);
            }
        }
        return temperature;
    }

    public double getBlockHumidity(int x, int z) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return 0.0;
        }
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        double humidity = Double.NEGATIVE_INFINITY;
        Chunk chunk = null;
        if (this.isChunkLoaded(chunkX, chunkZ)) {
            chunk = this.getChunkFromChunkCoords(chunkX, chunkZ);
            humidity = chunk.getBlockHumidity(x & 0xF, z & 0xF);
        }
        if (humidity == Double.NEGATIVE_INFINITY) {
            humidity = this.getBiomeProvider().getHumidity(x, z);
            if (chunk != null) {
                chunk.setBlockHumidity(x & 0xF, z & 0xF, humidity);
            }
        }
        return humidity;
    }

    public double getBlockVariety(int x, int z) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return 0.0;
        }
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        double variety = Double.NEGATIVE_INFINITY;
        Chunk chunk = null;
        if (this.isChunkLoaded(chunkX, chunkZ)) {
            chunk = this.getChunkFromChunkCoords(chunkX, chunkZ);
            variety = chunk.getBlockVariety(x & 0xF, z & 0xF);
        }
        if (variety == Double.NEGATIVE_INFINITY) {
            variety = this.getBiomeProvider().getVariety(x, z);
            if (chunk != null) {
                chunk.setBlockVariety(x & 0xF, z & 0xF, variety);
            }
        }
        return variety;
    }

    public Biome getBlockBiome(int x, int y, int z) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return Biomes.OVERWORLD_PLAINS;
        }
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        Biome biome = null;
        Chunk chunk = null;
        if (this.isChunkLoaded(chunkX, chunkZ)) {
            chunk = this.getChunkFromChunkCoords(chunkX, chunkZ);
            biome = chunk.getBlockBiome(x & 0xF, y, z & 0xF);
        }
        if (biome == null) {
            biome = this.getBiomeProvider().getBiome(x, y, z);
            if (chunk != null) {
                chunk.setBlockBiome(x & 0xF, y, z & 0xF, biome);
            }
        }
        return biome;
    }

    public boolean getBlockLitInteriorSurface(int x, int y, int z) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return true;
        }
        if (y < 0) {
            return true;
        }
        if (y >= this.getHeightBlocks()) {
            return true;
        }
        return Block.getIsLitInteriorSurface(this, x, y, z);
    }

    public boolean isAirBlock(int x, int y, int z) {
        return this.getBlockId(x, y, z) == 0;
    }

    public boolean isBlockLoaded(int x, int y, int z) {
        if (y < 0 || y >= this.getHeightBlocks()) {
            return false;
        }
        return this.isChunkLoaded(x >> 4, z >> 4);
    }

    public boolean areBlocksLoaded(int x, int y, int z, int range) {
        return this.areBlocksLoaded(x - range, y - range, z - range, x + range, y + range, z + range);
    }

    public boolean areBlocksLoaded(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (maxY < 0 || minY >= this.getHeightBlocks()) {
            return false;
        }
        minZ >>= 4;
        maxX >>= 4;
        maxZ >>= 4;
        for (int chunkX = minX >>= 4; chunkX <= maxX; ++chunkX) {
            for (int chunkZ = minZ; chunkZ <= maxZ; ++chunkZ) {
                if (this.isChunkLoaded(chunkX, chunkZ)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isChunkLoaded(int x, int z) {
        return this.chunkProvider.isChunkLoaded(x, z);
    }

    public Chunk getChunkFromBlockCoords(int x, int z) {
        return this.getChunkFromChunkCoords(x >> 4, z >> 4);
    }

    public Chunk getChunkFromChunkCoords(int x, int z) {
        return this.chunkProvider.provideChunk(x, z);
    }

    public boolean setBlockAndMetadata(int x, int y, int z, int id, int meta) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return false;
        }
        if (y < 0) {
            return false;
        }
        if (y >= this.getHeightBlocks()) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(x >> 4, z >> 4);
        return chunk.setBlockIDWithMetadata(x & 0xF, y, z & 0xF, id, meta);
    }

    public boolean setBlockRaw(int x, int y, int z, int id) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return false;
        }
        if (y < 0) {
            return false;
        }
        if (y >= this.getHeightBlocks()) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(x >> 4, z >> 4);
        return chunk.setBlockIDRaw(x & 0xF, y, z & 0xF, id);
    }

    public boolean setBlock(int x, int y, int z, int id) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return false;
        }
        if (y < 0) {
            return false;
        }
        if (y >= this.getHeightBlocks()) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(x >> 4, z >> 4);
        return chunk.setBlockID(x & 0xF, y, z & 0xF, id);
    }

    @Override
    public Material getBlockMaterial(int x, int y, int z) {
        int l = this.getBlockId(x, y, z);
        if (l == 0) {
            return Material.air;
        }
        return Block.blocksList[l].blockMaterial;
    }

    @Override
    public int getBlockMetadata(int x, int y, int z) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return 0;
        }
        if (y < 0) {
            return 0;
        }
        if (y >= this.getHeightBlocks()) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(x >> 4, z >> 4);
        return chunk.getBlockMetadata(x &= 0xF, y, z &= 0xF);
    }

    public void setBlockMetadataWithNotify(int x, int y, int z, int meta) {
        if (this.setBlockMetadata(x, y, z, meta)) {
            int i1 = this.getBlockId(x, y, z);
            if (Block.neighborNotifyOnMetadataChangeDisabled[i1 & 0x3FFF]) {
                this.notifyBlockChange(x, y, z, i1);
            } else {
                this.notifyBlocksOfNeighborChange(x, y, z, i1);
            }
        }
    }

    public boolean setBlockMetadata(int x, int y, int z, int meta) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return false;
        }
        if (y < 0) {
            return false;
        }
        if (y >= this.getHeightBlocks()) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(x >> 4, z >> 4);
        chunk.setBlockMetadata(x &= 0xF, y, z &= 0xF, meta);
        return true;
    }

    public boolean setBlockRawWithNotify(int x, int y, int z, int id) {
        if (this.setBlockRaw(x, y, z, id)) {
            this.notifyBlockChange(x, y, z, id);
            return true;
        }
        return false;
    }

    public boolean setBlockWithNotify(int x, int y, int z, int id) {
        if (this.setBlock(x, y, z, id)) {
            this.notifyBlockChange(x, y, z, id);
            return true;
        }
        return false;
    }

    public boolean setBlockAndMetadataWithNotify(int x, int y, int z, int id, int meta) {
        if (this.setBlockAndMetadata(x, y, z, id, meta)) {
            this.notifyBlockChange(x, y, z, id);
            return true;
        }
        return false;
    }

    public void markBlockNeedsUpdate(int x, int y, int z) {
        for (LevelListener listener : this.listeners) {
            listener.blockChanged(x, y, z);
        }
    }

    public void notifyBlockChange(int x, int y, int z, int id) {
        this.markBlockNeedsUpdate(x, y, z);
        this.notifyBlocksOfNeighborChange(x, y, z, id);
    }

    public void markBlocksDirtyVertical(int x, int z, int y0, int y1) {
        if (y0 > y1) {
            int t = y1;
            y1 = y0;
            y0 = t;
        }
        this.markBlocksDirty(x, y0, z, x, y1, z);
    }

    public void markBlockDirty(int x, int y, int z) {
        for (LevelListener listener : this.listeners) {
            listener.setBlocksDirty(x, y, z, x, y, z);
        }
    }

    public void markBlocksDirty(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (LevelListener listener : this.listeners) {
            listener.setBlocksDirty(minX, minY, minZ, maxX, maxY, maxZ);
        }
    }

    public void notifyBlocksOfNeighborChange(int x, int y, int z, int blockId) {
        this.notifyBlockOfNeighborChange(x - 1, y, z, blockId);
        this.notifyBlockOfNeighborChange(x + 1, y, z, blockId);
        this.notifyBlockOfNeighborChange(x, y - 1, z, blockId);
        this.notifyBlockOfNeighborChange(x, y + 1, z, blockId);
        this.notifyBlockOfNeighborChange(x, y, z - 1, blockId);
        this.notifyBlockOfNeighborChange(x, y, z + 1, blockId);
    }

    private void notifyBlockOfNeighborChange(int x, int y, int z, int blockId) {
        if (this.editingBlocks || this.isClientSide) {
            return;
        }
        Block block = Block.blocksList[this.getBlockId(x, y, z)];
        if (block != null) {
            block.onNeighborBlockChange(this, x, y, z, blockId);
        }
    }

    public boolean canBlockSeeTheSky(int x, int y, int z) {
        return this.getChunkFromChunkCoords(x >> 4, z >> 4).canBlockSeeTheSky(x & 0xF, y, z & 0xF);
    }

    public int getFullBlockLightValue(int x, int y, int z) {
        if (y < 0) {
            return 0;
        }
        if (y >= this.getHeightBlocks()) {
            y = this.getHeightBlocks() - 1;
        }
        return this.getChunkFromChunkCoords(x >> 4, z >> 4).getBlockLightValue(x & 0xF, y, z & 0xF, 0);
    }

    public int getBlockLightValue(int i, int j, int k) {
        return this.getBlockLightValue_do(i, j, k, true);
    }

    public int getBlockLightValue_do(int i, int j, int k, boolean flag) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return 15;
        }
        if (flag && this.getBlockLitInteriorSurface(i, j, k)) {
            int i1 = this.getBlockLightValue_do(i, j + 1, k, false);
            int j1 = this.getBlockLightValue_do(i + 1, j, k, false);
            int k1 = this.getBlockLightValue_do(i - 1, j, k, false);
            int l1 = this.getBlockLightValue_do(i, j, k + 1, false);
            int i2 = this.getBlockLightValue_do(i, j, k - 1, false);
            if (j1 > i1) {
                i1 = j1;
            }
            if (k1 > i1) {
                i1 = k1;
            }
            if (l1 > i1) {
                i1 = l1;
            }
            if (i2 > i1) {
                i1 = i2;
            }
            return i1;
        }
        if (j < 0) {
            return 0;
        }
        if (j >= this.getHeightBlocks()) {
            j = this.getHeightBlocks() - 1;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        return chunk.getBlockLightValue(i &= 0xF, j, k &= 0xF, this.skyDarken);
    }

    public boolean canExistingBlockSeeTheSky(int i, int j, int k) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return false;
        }
        if (j < 0) {
            return false;
        }
        if (j >= this.getHeightBlocks()) {
            return true;
        }
        if (!this.isChunkLoaded(i >> 4, k >> 4)) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        return chunk.canBlockSeeTheSky(i &= 0xF, j, k &= 0xF);
    }

    public int getHeightValue(int i, int j) {
        if (i < -32000000 || j < -32000000 || i >= 32000000 || j > 32000000) {
            return 0;
        }
        if (!this.isChunkLoaded(i >> 4, j >> 4)) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, j >> 4);
        return chunk.getHeightValue(i & 0xF, j & 0xF);
    }

    public void neighborLightPropagationChanged(LightLayer lightLayer, int x, int y, int z, int lightValue) {
        int i1;
        if (this.worldType.hasCeiling() && lightLayer == LightLayer.Sky) {
            return;
        }
        if (!this.isBlockLoaded(x, y, z)) {
            return;
        }
        if (lightLayer == LightLayer.Sky) {
            if (this.canExistingBlockSeeTheSky(x, y, z)) {
                lightValue = 15;
            }
        } else if (lightLayer == LightLayer.Block && Block.lightValue[i1 = this.getBlockId(x, y, z)] > lightValue) {
            lightValue = Block.lightValue[i1];
        }
        if (this.getSavedLightValue(lightLayer, x, y, z) != lightValue) {
            this.scheduleLightingUpdate(lightLayer, x, y, z, x, y, z);
        }
    }

    public int getSavedLightValue(LightLayer layer, int x, int y, int z) {
        if (y < 0) {
            y = 0;
        }
        if (y >= this.getHeightBlocks()) {
            y = this.getHeightBlocks() - 1;
        }
        if (y < 0 || y >= this.getHeightBlocks() || x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return layer.defaultLightLevel;
        }
        int l = x >> 4;
        int i1 = z >> 4;
        if (!this.isChunkLoaded(l, i1)) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(l, i1);
        return chunk.getSavedLightValue(layer, x & 0xF, y, z & 0xF);
    }

    public void setLightValue(LightLayer layer, int x, int y, int z, int value) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return;
        }
        if (y < 0) {
            return;
        }
        if (y >= this.getHeightBlocks()) {
            return;
        }
        if (!this.isChunkLoaded(x >> 4, z >> 4)) {
            return;
        }
        Chunk chunk = this.getChunkFromChunkCoords(x >> 4, z >> 4);
        chunk.setLightValue(layer, x & 0xF, y, z & 0xF, value);
        for (LevelListener listener : this.listeners) {
            listener.blockChanged(x, y, z);
        }
    }

    @Override
    public float getBrightness(int x, int y, int z, int blockLightValue) {
        int i1 = this.getBlockLightValue(x, y, z);
        if (i1 < blockLightValue) {
            i1 = blockLightValue;
        }
        return this.worldType.getBrightnessRamp()[i1];
    }

    @Override
    public float getLightBrightness(int x, int y, int z) {
        return this.worldType.getBrightnessRamp()[this.getBlockLightValue(x, y, z)];
    }

    public boolean isDaytime() {
        return this.skyDarken < 4;
    }

    public HitResult checkBlockCollisionBetweenPoints(Vec3d start, Vec3d end) {
        return this.checkBlockCollisionBetweenPoints(start, end, false, false);
    }

    public HitResult checkBlockCollisionBetweenPoints(Vec3d start, Vec3d end, boolean shouldCollideWithFluids) {
        return this.checkBlockCollisionBetweenPoints(start, end, shouldCollideWithFluids, false);
    }

    public HitResult checkBlockCollisionBetweenPoints(Vec3d start, Vec3d end, boolean shouldCollideWithFluids, boolean flag1) {
        HitResult movingobjectposition;
        if (Double.isNaN(start.xCoord) || Double.isNaN(start.yCoord) || Double.isNaN(start.zCoord)) {
            return null;
        }
        if (Double.isNaN(end.xCoord) || Double.isNaN(end.yCoord) || Double.isNaN(end.zCoord)) {
            return null;
        }
        int blockEndX = MathHelper.floor_double(end.xCoord);
        int blockEndY = MathHelper.floor_double(end.yCoord);
        int blockEndZ = MathHelper.floor_double(end.zCoord);
        int blockStartX = MathHelper.floor_double(start.xCoord);
        int blockStartY = MathHelper.floor_double(start.yCoord);
        int blockStartZ = MathHelper.floor_double(start.zCoord);
        int id = this.getBlockId(blockStartX, blockStartY, blockStartZ);
        int meta = this.getBlockMetadata(blockStartX, blockStartY, blockStartZ);
        Block block = Block.blocksList[id];
        if ((!flag1 || block == null || block.getCollisionBoundingBoxFromPool(this, blockStartX, blockStartY, blockStartZ) != null) && id > 0 && block.canCollideCheck(meta, shouldCollideWithFluids) && (movingobjectposition = block.collisionRayTrace(this, blockStartX, blockStartY, blockStartZ, start, end)) != null) {
            return movingobjectposition;
        }
        int l1 = 200;
        while (l1-- >= 0) {
            HitResult movingobjectposition1;
            if (Double.isNaN(start.xCoord) || Double.isNaN(start.yCoord) || Double.isNaN(start.zCoord)) {
                return null;
            }
            if (blockStartX == blockEndX && blockStartY == blockEndY && blockStartZ == blockEndZ) {
                return null;
            }
            boolean flag2 = true;
            boolean flag3 = true;
            boolean flag4 = true;
            double d = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (blockEndX > blockStartX) {
                d = (double)blockStartX + 1.0;
            } else if (blockEndX < blockStartX) {
                d = (double)blockStartX + 0.0;
            } else {
                flag2 = false;
            }
            if (blockEndY > blockStartY) {
                d1 = (double)blockStartY + 1.0;
            } else if (blockEndY < blockStartY) {
                d1 = (double)blockStartY + 0.0;
            } else {
                flag3 = false;
            }
            if (blockEndZ > blockStartZ) {
                d2 = (double)blockStartZ + 1.0;
            } else if (blockEndZ < blockStartZ) {
                d2 = (double)blockStartZ + 0.0;
            } else {
                flag4 = false;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = end.xCoord - start.xCoord;
            double d7 = end.yCoord - start.yCoord;
            double d8 = end.zCoord - start.zCoord;
            if (flag2) {
                d3 = (d - start.xCoord) / d6;
            }
            if (flag3) {
                d4 = (d1 - start.yCoord) / d7;
            }
            if (flag4) {
                d5 = (d2 - start.zCoord) / d8;
            }
            int byte0 = 0;
            if (d3 < d4 && d3 < d5) {
                byte0 = blockEndX > blockStartX ? 4 : 5;
                start.xCoord = d;
                start.yCoord += d7 * d3;
                start.zCoord += d8 * d3;
            } else if (d4 < d5) {
                byte0 = blockEndY > blockStartY ? 0 : 1;
                start.xCoord += d6 * d4;
                start.yCoord = d1;
                start.zCoord += d8 * d4;
            } else {
                byte0 = blockEndZ > blockStartZ ? 2 : 3;
                start.xCoord += d6 * d5;
                start.yCoord += d7 * d5;
                start.zCoord = d2;
            }
            Vec3d vec3d2 = Vec3d.createVector(start.xCoord, start.yCoord, start.zCoord);
            vec3d2.xCoord = MathHelper.floor_double(start.xCoord);
            blockStartX = (int)vec3d2.xCoord;
            if (byte0 == 5) {
                --blockStartX;
                vec3d2.xCoord += 1.0;
            }
            vec3d2.yCoord = MathHelper.floor_double(start.yCoord);
            blockStartY = (int)vec3d2.yCoord;
            if (byte0 == 1) {
                --blockStartY;
                vec3d2.yCoord += 1.0;
            }
            vec3d2.zCoord = MathHelper.floor_double(start.zCoord);
            blockStartZ = (int)vec3d2.zCoord;
            if (byte0 == 3) {
                --blockStartZ;
                vec3d2.zCoord += 1.0;
            }
            int j2 = this.getBlockId(blockStartX, blockStartY, blockStartZ);
            int k2 = this.getBlockMetadata(blockStartX, blockStartY, blockStartZ);
            Block block1 = Block.blocksList[j2];
            if (flag1 && block1 != null && block1.getCollisionBoundingBoxFromPool(this, blockStartX, blockStartY, blockStartZ) == null || j2 <= 0 || !block1.canCollideCheck(k2, shouldCollideWithFluids) || (movingobjectposition1 = block1.collisionRayTrace(this, blockStartX, blockStartY, blockStartZ, start, end)) == null) continue;
            return movingobjectposition1;
        }
        return null;
    }

    public void playSoundAtEntity(Entity entity, String soundPath, float volume, float pitch) {
        for (LevelListener listener : this.listeners) {
            listener.playSound(soundPath, SoundType.ENTITY_SOUNDS, entity.x, entity.y - (double)entity.heightOffset, entity.z, volume, pitch);
        }
    }

    public void playSoundEffect(SoundType soundType, double x, double y, double z, String soundPath, float volume, float pitch) {
        for (LevelListener listener : this.listeners) {
            listener.playSound(soundPath, soundType, x, y, z, volume, pitch);
        }
    }

    public void playBlockSoundEffect(double x, double y, double z, Block block, EnumBlockSoundEffectType soundType) {
        for (LevelListener listener : this.listeners) {
            listener.playBlockSoundEffect(block, soundType, x, y, z);
        }
    }

    public void playRecord(String s, int i, int j, int k) {
        for (int l = 0; l < this.listeners.size(); ++l) {
            this.listeners.get(l).playStreamingMusic(s, i, j, k);
        }
    }

    public void spawnParticle(String particleKey, double x, double y, double z, double motionX, double motionY, double motionZ, double maxDistance) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).addParticle(particleKey, x, y, z, motionX, motionY, motionZ, maxDistance);
        }
    }

    public void spawnParticle(String particleKey, double x, double y, double z, double motionX, double motionY, double motionZ) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).addParticle(particleKey, x, y, z, motionX, motionY, motionZ);
        }
    }

    public boolean addWeatherEffect(Entity entity) {
        this.weatherEffects.add(entity);
        return true;
    }

    public boolean entityJoinedWorld(Entity entity) {
        int i = MathHelper.floor_double(entity.x / 16.0);
        int j = MathHelper.floor_double(entity.z / 16.0);
        boolean flag = false;
        if (entity instanceof EntityPlayer) {
            flag = true;
        }
        if (flag || this.isChunkLoaded(i, j)) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                this.players.add(entityplayer);
                this.updateEnoughPlayersSleepingFlag(null);
            }
            this.getChunkFromChunkCoords(i, j).addEntity(entity);
            this.loadedEntityList.add(entity);
            this.obtainEntitySkin(entity);
            return true;
        }
        return false;
    }

    protected void obtainEntitySkin(Entity entity) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).entityAdded(entity);
        }
    }

    protected void releaseEntitySkin(Entity entity) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).entityRemoved(entity);
        }
    }

    public void setEntityDead(Entity entity) {
        if (entity.passenger != null) {
            entity.passenger.startRiding(null);
        }
        if (entity.vehicle != null) {
            entity.startRiding(null);
        }
        entity.remove();
        if (entity instanceof EntityPlayer) {
            this.players.remove((EntityPlayer)entity);
            this.updateEnoughPlayersSleepingFlag(null);
        }
    }

    public void removePlayer(Entity entity) {
        entity.remove();
        if (entity instanceof EntityPlayer) {
            this.players.remove((EntityPlayer)entity);
            this.updateEnoughPlayersSleepingFlag(null);
        }
        int i = entity.chunkCoordX;
        int j = entity.chunkCoordZ;
        if (entity.addedToChunk && this.isChunkLoaded(i, j)) {
            this.getChunkFromChunkCoords(i, j).removeEntity(entity);
        }
        this.loadedEntityList.remove(entity);
        this.releaseEntitySkin(entity);
    }

    public void addListener(LevelListener iworldaccess) {
        this.listeners.add(iworldaccess);
    }

    public void removeListener(LevelListener iworldaccess) {
        this.listeners.remove(iworldaccess);
    }

    public List<AABB> getCubes(Entity entity, AABB axisalignedbb) {
        this.collidingBoundingBoxes.clear();
        int minX = MathHelper.floor_double(axisalignedbb.minX);
        int maxX = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int minY = MathHelper.floor_double(axisalignedbb.minY);
        int maxY = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int minZ = MathHelper.floor_double(axisalignedbb.minZ);
        int maxZ = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        for (int dx = minX; dx < maxX; ++dx) {
            for (int dz = minZ; dz < maxZ; ++dz) {
                if (!this.isBlockLoaded(dx, 64, dz)) continue;
                for (int dy = minY - 1; dy < maxY; ++dy) {
                    Block block = Block.blocksList[this.getBlockId(dx, dy, dz)];
                    if (block == null || !block.collidesWithEntity(entity)) continue;
                    block.getCollidingBoundingBoxes(this, dx, dy, dz, axisalignedbb, this.collidingBoundingBoxes);
                }
            }
        }
        double radius = 0.25;
        List<Entity> list = this.getEntitiesWithinAABBExcludingEntity(entity, axisalignedbb.expand(radius, radius, radius));
        for (Entity value : list) {
            AABB axisalignedbb1 = value.getBb();
            if (axisalignedbb1 == null || !axisalignedbb1.intersectsWith(axisalignedbb)) continue;
            this.collidingBoundingBoxes.add(axisalignedbb1);
        }
        return this.collidingBoundingBoxes;
    }

    public List<AABB> getCollidingSolidBlockBoundingBoxes(Entity entity, AABB axisalignedbb) {
        this.collidingBoundingBoxes.clear();
        int i = MathHelper.floor_double(axisalignedbb.minX);
        int j = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = i1; l1 < j1; ++l1) {
                if (!this.isBlockLoaded(k1, 64, l1)) continue;
                for (int i2 = k - 1; i2 < l; ++i2) {
                    Block block = Block.blocksList[this.getBlockId(k1, i2, l1)];
                    if (block == null || !block.isOpaqueCube() || entity instanceof EntityItem && (block.id == Block.mesh.id || block.id == Block.spikes.id || block.id == Block.mobspawner.id)) continue;
                    block.getCollidingBoundingBoxes(this, k1, i2, l1, axisalignedbb, this.collidingBoundingBoxes);
                }
            }
        }
        double d = 0.25;
        List<Entity> list = this.getEntitiesWithinAABBExcludingEntity(entity, axisalignedbb.expand(d, d, d));
        for (int j2 = 0; j2 < list.size(); ++j2) {
            AABB axisalignedbb1 = list.get(j2).getBb();
            if (axisalignedbb1 == null || !axisalignedbb1.intersectsWith(axisalignedbb)) continue;
            this.collidingBoundingBoxes.add(axisalignedbb1);
        }
        return this.collidingBoundingBoxes;
    }

    public Vec3d getSkyColor(ICamera camera, float renderPartialTicks) {
        float f7;
        float f1 = this.getCelestialAngle(renderPartialTicks);
        float f2 = MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        int x = MathHelper.floor_double(camera.getX(renderPartialTicks));
        int y = MathHelper.floor_double(camera.getY(renderPartialTicks));
        int z = MathHelper.floor_double(camera.getZ(renderPartialTicks));
        float blockTemperature = (float)this.getBlockTemperature(x, z);
        if (this.seasonManager.getCurrentSeason() != null && (this.seasonManager.getCurrentSeason() == Seasons.OVERWORLD_WINTER || this.seasonManager.getCurrentSeason() == Seasons.OVERWORLD_FALL)) {
            blockTemperature -= 1.25f;
        }
        int k = this.getBiomeProvider().getBiome(x, y, z).getSkyColor(blockTemperature);
        float f4 = (float)(k >> 16 & 0xFF) / 255.0f;
        float f5 = (float)(k >> 8 & 0xFF) / 255.0f;
        float f6 = (float)(k & 0xFF) / 255.0f;
        f4 *= f2;
        f5 *= f2;
        f6 *= f2;
        float f = f7 = this.currentWeather != null && this.currentWeather.isPrecipitation ? this.weatherIntensity * this.weatherPower : 0.0f;
        if (f7 > 0.0f) {
            float f8 = (f4 * 0.3f + f5 * 0.59f + f6 * 0.11f) * 0.6f;
            float f10 = 1.0f - f7 * 0.75f;
            f4 = f4 * f10 + f8 * (1.0f - f10);
            f5 = f5 * f10 + f8 * (1.0f - f10);
            f6 = f6 * f10 + f8 * (1.0f - f10);
        }
        if (this.lightningFlicker > 0) {
            float f12 = (float)this.lightningFlicker - renderPartialTicks;
            if (f12 > 1.0f) {
                f12 = 1.0f;
            }
            f4 = f4 * (1.0f - (f12 *= 0.45f)) + 0.8f * f12;
            f5 = f5 * (1.0f - f12) + 0.8f * f12;
            f6 = f6 * (1.0f - f12) + 1.0f * f12;
        }
        return Vec3d.createVector(f4, f5, f6);
    }

    public float getCelestialAngle(float renderPartialTicks) {
        return this.worldType.getCelestialAngle(this, this.levelData.getWorldTime(), renderPartialTicks);
    }

    public Vec3d getDimensionColor(float renderPartialTicks) {
        float f6;
        float f1 = this.getCelestialAngle(renderPartialTicks);
        float f2 = MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        float f3 = (float)(this.dimensionColor >> 16 & 0xFFL) / 255.0f;
        float f4 = (float)(this.dimensionColor >> 8 & 0xFFL) / 255.0f;
        float f5 = (float)(this.dimensionColor & 0xFFL) / 255.0f;
        float f = f6 = this.currentWeather != null && this.currentWeather.isPrecipitation ? this.weatherIntensity * this.weatherPower : 0.0f;
        if (f6 > 0.0f) {
            float f7 = (f3 * 0.3f + f4 * 0.59f + f5 * 0.11f) * 0.6f;
            float f9 = 1.0f - f6 * 0.95f;
            f3 = f3 * f9 + f7 * (1.0f - f9);
            f4 = f4 * f9 + f7 * (1.0f - f9);
            f5 = f5 * f9 + f7 * (1.0f - f9);
        }
        return Vec3d.createVector(f3 *= f2 * 0.9f + 0.1f, f4 *= f2 * 0.9f + 0.1f, f5 *= f2 * 0.85f + 0.15f);
    }

    public Vec3d getFogColor(float renderPartialTicks) {
        float f1 = this.getCelestialAngle(renderPartialTicks);
        return this.worldType.getFogColor(f1, renderPartialTicks);
    }

    public int findTopSolidBlock(int i, int j) {
        Chunk chunk = this.getChunkFromBlockCoords(i, j);
        i &= 0xF;
        j &= 0xF;
        for (int k = this.getHeightBlocks() - 1; k > 0; --k) {
            Material material;
            int l = chunk.getBlockID(i, k, j);
            Material material2 = material = l != 0 ? Block.blocksList[l].blockMaterial : Material.air;
            if (!material.blocksMotion() && !material.isLiquid()) {
                continue;
            }
            return k + 1;
        }
        return -1;
    }

    public int findTopSolidNonLiquidBlock(int i, int j) {
        Chunk chunk = this.getChunkFromBlockCoords(i, j);
        i &= 0xF;
        j &= 0xF;
        for (int k = this.getHeightBlocks() - 1; k > 0; --k) {
            Material material;
            int l = chunk.getBlockID(i, k, j);
            Material material2 = material = l != 0 ? Block.blocksList[l].blockMaterial : Material.air;
            if (!material.blocksMotion()) {
                continue;
            }
            return k + 1;
        }
        return -1;
    }

    public float getStarBrightness(float renderPartialTicks) {
        float f1 = this.getCelestialAngle(renderPartialTicks);
        float f2 = 1.0f - (MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.75f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2 * f2 * 0.5f;
    }

    public void scheduleBlockUpdate(int x, int y, int z, int id, int delay) {
        NextTickListEntry entry = new NextTickListEntry(x, y, z, id);
        int radius = 8;
        if (this.scheduledUpdatesAreImmediate) {
            int id1;
            if (this.areBlocksLoaded(entry.x - radius, entry.y - radius, entry.z - radius, entry.x + radius, entry.y + radius, entry.z + radius) && (id1 = this.getBlockId(entry.x, entry.y, entry.z)) == entry.blockId && id1 > 0) {
                Block.blocksList[id1].updateTick(this, entry.x, entry.y, entry.z, this.rand);
            }
            return;
        }
        if (this.areBlocksLoaded(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius)) {
            if (id > 0) {
                entry.setDelay((long)delay + this.runtime);
            }
            if (!this.scheduledTickSet.contains(entry)) {
                this.scheduledTickSet.add(entry);
                this.scheduledTickTreeSet.add(entry);
            }
        }
    }

    public void updateEntities() {
        for (int i = 0; i < this.weatherEffects.size(); ++i) {
            Entity entity = this.weatherEffects.get(i);
            entity.tick();
            if (!entity.removed) continue;
            this.weatherEffects.remove(i--);
        }
        this.loadedEntityList.removeAll(this.unloadedEntityList);
        for (int j = 0; j < this.unloadedEntityList.size(); ++j) {
            Entity entity1 = this.unloadedEntityList.get(j);
            int i1 = entity1.chunkCoordX;
            int k1 = entity1.chunkCoordZ;
            if (!entity1.addedToChunk || !this.isChunkLoaded(i1, k1)) continue;
            this.getChunkFromChunkCoords(i1, k1).removeEntity(entity1);
        }
        for (int k = 0; k < this.unloadedEntityList.size(); ++k) {
            this.releaseEntitySkin(this.unloadedEntityList.get(k));
        }
        this.unloadedEntityList.clear();
        for (int l = 0; l < this.loadedEntityList.size(); ++l) {
            Entity entity2 = this.loadedEntityList.get(l);
            if (entity2.vehicle != null) {
                if (!entity2.vehicle.removed && entity2.vehicle.passenger == entity2) continue;
                entity2.vehicle.passenger = null;
                entity2.vehicle = null;
            }
            if (!entity2.removed) {
                this.updateEntity(entity2);
            }
            if (!entity2.removed) continue;
            int j1 = entity2.chunkCoordX;
            int l1 = entity2.chunkCoordZ;
            if (entity2.addedToChunk && this.isChunkLoaded(j1, l1)) {
                this.getChunkFromChunkCoords(j1, l1).removeEntity(entity2);
            }
            this.loadedEntityList.remove(l--);
            this.releaseEntitySkin(entity2);
        }
        this.field_31055_L = true;
        Iterator<TileEntity> iterator = this.loadedTileEntityList.iterator();
        while (iterator.hasNext()) {
            TileEntity tileentity = iterator.next();
            if (!tileentity.isInvalid()) {
                tileentity.updateEntity();
            }
            if (!tileentity.isInvalid()) continue;
            iterator.remove();
            Chunk chunk = this.getChunkFromChunkCoords(tileentity.xCoord >> 4, tileentity.zCoord >> 4);
            if (chunk == null) continue;
            chunk.removeChunkBlockTileEntity(tileentity.xCoord & 0xF, tileentity.yCoord, tileentity.zCoord & 0xF);
        }
        this.field_31055_L = false;
        if (!this.field_30900_E.isEmpty()) {
            for (TileEntity tileentity1 : this.field_30900_E) {
                Chunk chunk1;
                if (tileentity1.isInvalid()) continue;
                if (!this.loadedTileEntityList.contains(tileentity1)) {
                    this.loadedTileEntityList.add(tileentity1);
                }
                if ((chunk1 = this.getChunkFromChunkCoords(tileentity1.xCoord >> 4, tileentity1.zCoord >> 4)) != null) {
                    chunk1.setChunkBlockTileEntity(tileentity1.xCoord & 0xF, tileentity1.yCoord, tileentity1.zCoord & 0xF, tileentity1);
                }
                this.markBlockNeedsUpdate(tileentity1.xCoord, tileentity1.yCoord, tileentity1.zCoord);
            }
            this.field_30900_E.clear();
        }
    }

    public void func_31054_a(Collection collection) {
        if (this.field_31055_L) {
            this.field_30900_E.addAll(collection);
        } else {
            this.loadedTileEntityList.addAll(collection);
        }
    }

    public void updateEntity(Entity entity) {
        this.updateEntityWithOptionalForce(entity, true);
    }

    public void updateEntityWithOptionalForce(Entity entity, boolean flag) {
        int i = MathHelper.floor_double(entity.x);
        int j = MathHelper.floor_double(entity.z);
        int byte0 = 32;
        if (flag && !this.areBlocksLoaded(i - byte0, 0, j - byte0, i + byte0, this.getHeightBlocks(), j + byte0)) {
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).tryToDespawn();
            }
            return;
        }
        entity.xOld = entity.x;
        entity.yOld = entity.y;
        entity.zOld = entity.z;
        entity.yRotO = entity.yRot;
        entity.xRotO = entity.xRot;
        if (flag && entity.addedToChunk) {
            if (entity.vehicle != null) {
                entity.rideTick();
            } else {
                entity.tick();
            }
        }
        if (Double.isNaN(entity.x) || Double.isInfinite(entity.x)) {
            entity.x = entity.xOld;
        }
        if (Double.isNaN(entity.y) || Double.isInfinite(entity.y)) {
            entity.y = entity.yOld;
        }
        if (Double.isNaN(entity.z) || Double.isInfinite(entity.z)) {
            entity.z = entity.zOld;
        }
        if (Double.isNaN(entity.xRot) || Double.isInfinite(entity.xRot)) {
            entity.xRot = entity.xRotO;
        }
        if (Double.isNaN(entity.yRot) || Double.isInfinite(entity.yRot)) {
            entity.yRot = entity.yRotO;
        }
        int k = MathHelper.floor_double(entity.x / 16.0);
        int l = MathHelper.floor_double(entity.y / 16.0);
        int i1 = MathHelper.floor_double(entity.z / 16.0);
        if (!entity.addedToChunk || entity.chunkCoordX != k || entity.chunkCoordY != l || entity.chunkCoordZ != i1) {
            if (entity.addedToChunk && this.isChunkLoaded(entity.chunkCoordX, entity.chunkCoordZ)) {
                this.getChunkFromChunkCoords(entity.chunkCoordX, entity.chunkCoordZ).removeEntityAtIndex(entity, entity.chunkCoordY);
            }
            if (this.isChunkLoaded(k, i1)) {
                entity.addedToChunk = true;
                this.getChunkFromChunkCoords(k, i1).addEntity(entity);
            } else {
                entity.addedToChunk = false;
            }
        }
        if (flag && entity.addedToChunk && entity.passenger != null) {
            if (entity.passenger.removed || entity.passenger.vehicle != entity) {
                entity.passenger.vehicle = null;
                entity.passenger = null;
            } else {
                this.updateEntity(entity.passenger);
            }
        }
    }

    public boolean checkIfAABBIsClear(AABB axisalignedbb) {
        if (axisalignedbb == null) {
            return true;
        }
        List<Entity> list = this.getEntitiesWithinAABBExcludingEntity(null, axisalignedbb);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = list.get(i);
            if (entity instanceof EntityFireflyCluster || entity.removed || !entity.blocksBuilding) continue;
            return false;
        }
        return true;
    }

    public boolean getIsAnyBlock(AABB axisalignedbb) {
        int i = MathHelper.floor_double(axisalignedbb.minX);
        int j = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        if (axisalignedbb.minX < 0.0) {
            --i;
        }
        if (axisalignedbb.minY < 0.0) {
            --k;
        }
        if (axisalignedbb.minZ < 0.0) {
            --i1;
        }
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block block = Block.blocksList[this.getBlockId(k1, l1, i2)];
                    if (block == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean getIsAnyLiquid(AABB axisalignedbb) {
        int i = MathHelper.floor_double(axisalignedbb.minX);
        int j = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        if (axisalignedbb.minX < 0.0) {
            --i;
        }
        if (axisalignedbb.minY < 0.0) {
            --k;
        }
        if (axisalignedbb.minZ < 0.0) {
            --i1;
        }
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block block = Block.blocksList[this.getBlockId(k1, l1, i2)];
                    if (block == null || !block.blockMaterial.isLiquid()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isBoundingBoxBurning(AABB axisalignedbb) {
        int j1;
        int i = MathHelper.floor_double(axisalignedbb.minX);
        int j = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        if (this.areBlocksLoaded(i, k, i1, j, l, j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0))) {
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        int j2 = this.getBlockId(k1, l1, i2);
                        if (j2 != Block.fire.id && j2 != Block.fluidLavaFlowing.id && j2 != Block.fluidLavaStill.id && j2 != Block.netherrackIgneous.id) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean handleMaterialAcceleration(AABB axisalignedbb, Material material, Entity entity) {
        int j1;
        int i = MathHelper.floor_double(axisalignedbb.minX);
        int j = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        if (!this.areBlocksLoaded(i, k, i1, j, l, j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0))) {
            return false;
        }
        boolean flag = false;
        Vec3d vec3d = Vec3d.createVector(0.0, 0.0, 0.0);
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    double d1;
                    Block block = Block.blocksList[this.getBlockId(k1, l1, i2)];
                    if (block == null || block.blockMaterial != material || !((double)l >= (d1 = (double)((float)(l1 + 1) - BlockFluid.getPercentAir(this.getBlockMetadata(k1, l1, i2)))))) continue;
                    flag = true;
                    block.velocityToAddToEntity(this, k1, l1, i2, entity, vec3d);
                }
            }
        }
        if (vec3d.lengthVector() > 0.0) {
            vec3d = vec3d.normalize();
            double d = 0.014;
            entity.xd += vec3d.xCoord * d;
            entity.yd += vec3d.yCoord * d;
            entity.zd += vec3d.zCoord * d;
        }
        return flag;
    }

    public boolean isMaterialInBB(AABB axisalignedbb, Material material) {
        int i = MathHelper.floor_double(axisalignedbb.minX);
        int j = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block block = Block.blocksList[this.getBlockId(k1, l1, i2)];
                    if (block == null || block.blockMaterial != material) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isAABBInMaterial(AABB axisalignedbb, Material material) {
        int i = MathHelper.floor_double(axisalignedbb.minX);
        int j = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block block = Block.blocksList[this.getBlockId(k1, l1, i2)];
                    if (block == null || block.blockMaterial != material) continue;
                    int j2 = this.getBlockMetadata(k1, l1, i2);
                    double d = l1 + 1;
                    if (j2 < 8) {
                        d = (double)(l1 + 1) - (double)j2 / 8.0;
                    }
                    if (!(d >= axisalignedbb.minY)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Explosion createExplosion(Entity entity, double d, double d1, double d2, float f) {
        return this.newExplosion(entity, d, d1, d2, f, false, false);
    }

    public Explosion newExplosion(Entity entity, double d, double d1, double d2, float f, boolean flag, boolean isCannonBall) {
        Explosion explosion = !isCannonBall ? new Explosion(this, entity, d, d1, d2, f) : new ExplosionCannonball(this, entity, d, d1, d2, f);
        explosion.isFlaming = flag;
        explosion.doExplosionA();
        explosion.doExplosionB(true);
        return explosion;
    }

    public float func_675_a(Vec3d vec3d, AABB axisalignedbb) {
        double d = 1.0 / ((axisalignedbb.maxX - axisalignedbb.minX) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.maxY - axisalignedbb.minY) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.maxZ - axisalignedbb.minZ) * 2.0 + 1.0);
        int i = 0;
        int j = 0;
        float f = 0.0f;
        while (f <= 1.0f) {
            float f1 = 0.0f;
            while (f1 <= 1.0f) {
                float f2 = 0.0f;
                while (f2 <= 1.0f) {
                    double d3 = axisalignedbb.minX + (axisalignedbb.maxX - axisalignedbb.minX) * (double)f;
                    double d4 = axisalignedbb.minY + (axisalignedbb.maxY - axisalignedbb.minY) * (double)f1;
                    double d5 = axisalignedbb.minZ + (axisalignedbb.maxZ - axisalignedbb.minZ) * (double)f2;
                    if (this.checkBlockCollisionBetweenPoints(Vec3d.createVector(d3, d4, d5), vec3d) == null) {
                        ++i;
                    }
                    ++j;
                    f2 = (float)((double)f2 + d2);
                }
                f1 = (float)((double)f1 + d1);
            }
            f = (float)((double)f + d);
        }
        return (float)i / (float)j;
    }

    public void onBlockHit(EntityPlayer entityplayer, int x, int y, int z, Side side) {
        if (this.getBlockId(x += side.getOffsetX(), y += side.getOffsetY(), z += side.getOffsetZ()) == Block.fire.id) {
            this.playSoundEffectForPlayer(entityplayer, 1004, x, y, z, 0);
            this.setBlockWithNotify(x, y, z, 0);
        }
    }

    public Entity func_4085_a(Class class1) {
        return null;
    }

    public String getNumLoadedEntitiesString() {
        return "All: " + this.loadedEntityList.size();
    }

    public String getChunkProviderInfoString() {
        return this.chunkProvider.getInfoString();
    }

    @Override
    public TileEntity getBlockTileEntity(int x, int y, int z) {
        Chunk chunk = this.getChunkFromChunkCoords(x >> 4, z >> 4);
        if (chunk != null) {
            return chunk.getChunkBlockTileEntity(x & 0xF, y, z & 0xF);
        }
        return null;
    }

    public void setBlockTileEntity(int i, int j, int k, TileEntity tileentity) {
        if (!tileentity.isInvalid()) {
            if (this.field_31055_L) {
                tileentity.xCoord = i;
                tileentity.yCoord = j;
                tileentity.zCoord = k;
                this.field_30900_E.add(tileentity);
            } else {
                this.loadedTileEntityList.add(tileentity);
                Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
                if (chunk != null) {
                    chunk.setChunkBlockTileEntity(i & 0xF, j, k & 0xF, tileentity);
                }
            }
        }
    }

    public void removeBlockTileEntity(int i, int j, int k) {
        TileEntity tileentity = this.getBlockTileEntity(i, j, k);
        if (tileentity != null && this.field_31055_L) {
            tileentity.invalidate();
        } else {
            Chunk chunk;
            if (tileentity != null) {
                this.loadedTileEntityList.remove(tileentity);
            }
            if ((chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4)) != null) {
                chunk.removeChunkBlockTileEntity(i & 0xF, j, k & 0xF);
            }
        }
    }

    @Override
    public boolean isBlockOpaqueCube(int x, int y, int z) {
        Block block = Block.blocksList[this.getBlockId(x, y, z)];
        if (block == null) {
            return false;
        }
        return block.isOpaqueCube();
    }

    public boolean canPlaceOnSurfaceOfBlock(int x, int y, int z) {
        Block block = Block.blocksList[this.getBlockId(x, y, z)];
        if (block == null) {
            return false;
        }
        return block.canPlaceOnSurfaceOnCondition(this, x, y, z);
    }

    @Override
    public boolean isBlockNormalCube(int x, int y, int z) {
        Block block = Block.blocksList[this.getBlockId(x, y, z)];
        if (block == null) {
            return false;
        }
        return block.blockMaterial.isSolidBlocking() && block.renderAsNormalBlockOnCondition(this, x, y, z);
    }

    public boolean canPlaceInsideBlock(int x, int y, int z) {
        int id = this.getBlockId(x, y, z);
        return id == 0 || Block.getBlock(id).hasTag(BlockTags.PLACE_OVERWRITES);
    }

    public void saveWorldIndirectly(IProgressUpdate iprogressupdate) {
        this.saveWorld(true, iprogressupdate);
    }

    public boolean updatingLighting() {
        if (this.lightingUpdatesCounter >= 50) {
            return false;
        }
        ++this.lightingUpdatesCounter;
        try {
            for (int i = 499; this.lightingToUpdate.size() > 0 && i >= 0; --i) {
                this.lightingToUpdate.remove(this.lightingToUpdate.size() - 1).performLightUpdate(this);
                if (i != 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            --this.lightingUpdatesCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleLightingUpdate(LightLayer layer, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (this.worldType.hasCeiling() && layer == LightLayer.Sky) {
            return;
        }
        ++lightingUpdatesScheduled;
        try {
            if (lightingUpdatesScheduled == 50) {
                return;
            }
            int centerX = (maxX + minX) / 2;
            int centerZ = (maxZ + minZ) / 2;
            if (!this.isBlockLoaded(centerX, 64, centerZ)) {
                return;
            }
            if (this.getChunkFromBlockCoords(centerX, centerZ).isChunkEmpty()) {
                return;
            }
            int numLightingUpdates = this.lightingToUpdate.size();
            if (numLightingUpdates > 5) {
                numLightingUpdates = 5;
            }
            for (int i = 0; i < numLightingUpdates; ++i) {
                LightUpdate lightUpdate = this.lightingToUpdate.get(this.lightingToUpdate.size() - i - 1);
                if (lightUpdate.layer != layer || !lightUpdate.expandToContain(minX, minY, minZ, maxX, maxY, maxZ)) continue;
                return;
            }
            this.lightingToUpdate.add(new LightUpdate(layer, minX, minY, minZ, maxX, maxY, maxZ));
            int maxLightingUpdates = 1000000;
            if (this.lightingToUpdate.size() > maxLightingUpdates) {
                System.out.println("More than " + maxLightingUpdates + " updates, dropping first " + maxLightingUpdates / 2 + " lighting updates");
                this.lightingToUpdate.subList(0, maxLightingUpdates / 2).clear();
            }
        }
        finally {
            --lightingUpdatesScheduled;
        }
    }

    public void updateSkyBrightness() {
        int i = this.worldType.getSkyDarken(this, this.getWorldTime(), 1.0f);
        if (i != this.skyDarken) {
            this.skyDarken = i;
        }
    }

    public void setAllowedMobSpawns(boolean flag, boolean flag1) {
        this.spawnHostileMobs = flag;
        this.spawnPeacefulMobs = flag1;
    }

    public void doLightingUpdate() {
        int i = this.worldType.getSkyDarken(this, this.getWorldTime(), 1.0f);
        if (i != this.skyDarken) {
            this.skyDarken = i;
            for (int j = 0; j < this.listeners.size(); ++j) {
                this.listeners.get(j).allChanged();
            }
        }
    }

    public void doSeasonUpdate() {
        if (this.getWorldTime() % (long)Global.DAY_LENGTH_TICKS == 0L) {
            for (int j = 0; j < this.listeners.size(); ++j) {
                this.listeners.get(j).allChanged();
            }
        }
    }

    protected void updateSleepingPlayers() {
        if (this.areEnoughPlayersFullyAsleep()) {
            boolean flag = false;
            if (this.spawnHostileMobs && this.difficultySetting >= 1 && this.getPlayersRequiredToSkipNight() <= 1) {
                flag = SpawnerMobs.performSleepSpawning(this, this.players);
            }
            if (!flag) {
                long l = this.levelData.getWorldTime() + (long)Global.DAY_LENGTH_TICKS;
                this.levelData.setWorldTime(l - l % (long)Global.DAY_LENGTH_TICKS);
                this.wakeUpAllPlayers();
            }
        }
    }

    public void tick() {
        this.updateWeather();
        this.updateSleepingPlayers();
        SpawnerMobs.performSpawning(this, this.spawnHostileMobs, this.spawnPeacefulMobs);
        this.chunkProvider.unload100OldestChunks();
        this.doLightingUpdate();
        long l1 = this.levelData.getWorldTime() + 1L;
        int autosaveTimeInSeconds = Global.accessor.getAutosaveTimer();
        int autosaveTimeInTicks = autosaveTimeInSeconds * 20;
        boolean bl = AUTOSAVE = autosaveTimeInTicks != 0;
        if (AUTOSAVE && l1 % (long)autosaveTimeInTicks == 0L) {
            this.saveWorld(false, null);
        }
        this.levelData.setWorldTime(l1);
        ++this.runtime;
        this.tickUpdates(false);
        this.updateBlocksAndPlayCaveSounds();
        this.doSeasonUpdate();
    }

    protected boolean updateWeather() {
        if (this.worldType.hasCeiling()) {
            return false;
        }
        if (this.seasonManager.getCurrentSeason() == null) {
            return false;
        }
        if (this.currentWeather == null) {
            this.currentWeather = this.worldType.getDefaultWeather();
        }
        if (this.newWeather == null && this.weatherIntensity <= 1.0f) {
            this.weatherIntensity += 0.002f;
            if (this.weatherIntensity > 1.0f) {
                this.weatherIntensity = 1.0f;
            }
        } else if (this.newWeather != null && this.weatherIntensity >= 0.0f) {
            this.weatherIntensity -= 0.002f;
            if (this.weatherIntensity <= 0.0f) {
                this.weatherIntensity = 0.0f;
                this.currentWeather = this.newWeather;
                this.weatherPower = new Random().nextFloat() * 0.5f + 0.5f;
                this.newWeather = null;
            }
        }
        --this.weatherDuration;
        if (this.weatherDuration <= 0L) {
            if (this.currentWeather != this.worldType.getDefaultWeather()) {
                this.newWeather = this.worldType.getDefaultWeather();
            } else {
                Season season = this.seasonManager.getCurrentSeason();
                boolean foundWeather = false;
                float acc = 0.0f;
                float val = this.rand.nextFloat();
                for (int i = 0; i < season.allowedWeathers.size(); ++i) {
                    if (!(val < (acc += season.weatherProbability.get(season.allowedWeathers.get(i)).floatValue()))) continue;
                    this.newWeather = season.allowedWeathers.get(i);
                    foundWeather = true;
                    break;
                }
                if (!foundWeather) {
                    this.newWeather = this.worldType.getDefaultWeather();
                }
            }
            this.weatherDuration = this.getRandomWeatherDuration();
        }
        this.dimensionData.setCurrentWeather(this.currentWeather);
        if (this.newWeather != null) {
            this.dimensionData.setNextWeather(this.newWeather);
        } else {
            this.dimensionData.setNextWeather(null);
        }
        this.dimensionData.setWeatherDuration(this.weatherDuration);
        this.dimensionData.setWeatherIntensity(this.weatherIntensity);
        this.dimensionData.setWeatherPower(this.weatherPower);
        return true;
    }

    public long getRandomWeatherDuration() {
        return (long)(this.rand.nextFloat() * ((float)Global.DAY_LENGTH_TICKS * 1.5f) + (float)Global.DAY_LENGTH_TICKS * 0.25f);
    }

    protected void updateBlocksAndPlayCaveSounds() {
        this.positionsToUpdate.clear();
        for (int i = 0; i < this.players.size(); ++i) {
            EntityPlayer entityplayer = this.players.get(i);
            int j = MathHelper.floor_double(entityplayer.x / 16.0);
            int l = MathHelper.floor_double(entityplayer.z / 16.0);
            int byte0 = 9;
            for (int j1 = -byte0; j1 <= byte0; ++j1) {
                for (int k2 = -byte0; k2 <= byte0; ++k2) {
                    this.positionsToUpdate.add(new ChunkCoordIntPair(j1 + j, k2 + l));
                }
            }
        }
        if (this.caveSoundCounter > 0) {
            --this.caveSoundCounter;
        }
        for (ChunkCoordIntPair chunkcoordintpair : this.positionsToUpdate) {
            EntityPlayer entityplayer1;
            int l4;
            int l5;
            int k = chunkcoordintpair.xPos * 16;
            int i1 = chunkcoordintpair.zPos * 16;
            if (!this.isChunkLoaded(chunkcoordintpair.xPos, chunkcoordintpair.zPos)) continue;
            Chunk chunk = this.getChunkFromChunkCoords(chunkcoordintpair.xPos, chunkcoordintpair.zPos);
            this.updateLCG = this.updateLCG * 3 + 1013904223;
            int k1 = this.updateLCG >> 2;
            int l2 = k1 & 0xF;
            int l3 = k1 >> 8 & 0xF;
            if (this.caveSoundCounter == 0 && (l5 = chunk.getBlockID(l2, l4 = k1 >> 16 & 0x7F, l3)) == 0 && this.getFullBlockLightValue(l2 += k, l4, l3 += i1) <= this.rand.nextInt(8) && this.getSavedLightValue(LightLayer.Sky, l2, l4, l3) <= 0 && (entityplayer1 = this.getClosestPlayer((double)l2 + 0.5, (double)l4 + 0.5, (double)l3 + 0.5, 8.0)) != null && entityplayer1.distanceToSqr((double)l2 + 0.5, (double)l4 + 0.5, (double)l3 + 0.5) > 4.0) {
                this.playSoundEffect(SoundType.CAVE_SOUNDS, (double)l2 + 0.5, (double)l4 + 0.5, (double)l3 + 0.5, "ambient.cave.cave", 0.7f, 0.8f + this.rand.nextFloat() * 0.2f);
                this.caveSoundCounter = this.rand.nextInt(12000) + 6000;
            }
            if (this.currentWeather != null) {
                this.updateLCG = this.updateLCG * 3 + 1013904223;
                int randVal = this.updateLCG >> 2;
                int x = chunk.xPosition * 16 + (randVal & 0xF);
                int z = chunk.zPosition * 16 + (randVal >> 16 & 0x7F);
                this.currentWeather.doEnvironmentUpdate(this, this.rand, x, z);
            }
            for (int j2 = 0; j2 < 80; ++j2) {
                this.updateLCG = this.updateLCG * 3 + 1013904223;
                int k3 = this.updateLCG >> 2;
                int k4 = k3 & 0xF;
                int k5 = k3 >> 8 & 0xF;
                int j6 = k3 >> 16 & 0xFF;
                int l6 = chunk.blocks[k4 << this.heightBits + 4 | k5 << this.heightBits | j6] & 0x3FFF;
                if (!Block.tickOnLoad[l6]) continue;
                Block.blocksList[l6].updateTick(this, k4 + k, j6, k5 + i1, this.rand);
            }
        }
    }

    public boolean tickUpdates(boolean all) {
        int count = this.scheduledTickTreeSet.size();
        if (count != this.scheduledTickSet.size()) {
            throw new IllegalStateException("TickNextTick list out of sync");
        }
        if (count > 1000) {
            count = 1000;
        }
        for (int j = 0; j < count; ++j) {
            int k;
            NextTickListEntry entry = this.scheduledTickTreeSet.first();
            if (!all && entry.delay > this.runtime) break;
            this.scheduledTickTreeSet.remove(entry);
            this.scheduledTickSet.remove(entry);
            int byte0 = 8;
            if (!this.areBlocksLoaded(entry.x - byte0, entry.y - byte0, entry.z - byte0, entry.x + byte0, entry.y + byte0, entry.z + byte0) || (k = this.getBlockId(entry.x, entry.y, entry.z)) != entry.blockId || k <= 0) continue;
            Block.blocksList[k].updateTick(this, entry.x, entry.y, entry.z, this.rand);
        }
        return this.scheduledTickTreeSet.size() != 0;
    }

    public void randomDisplayUpdates(int i, int j, int k) {
        int byte0 = 16;
        Random random = new Random();
        for (int l = 0; l < 1000; ++l) {
            int k1;
            int j1;
            int i1 = i + this.rand.nextInt(byte0) - this.rand.nextInt(byte0);
            int l1 = this.getBlockId(i1, j1 = j + this.rand.nextInt(byte0) - this.rand.nextInt(byte0), k1 = k + this.rand.nextInt(byte0) - this.rand.nextInt(byte0));
            if (l1 <= 0) continue;
            Block.blocksList[l1].randomDisplayTick(this, i1, j1, k1, random);
        }
    }

    public List<Entity> getEntitiesWithinAABBExcludingEntity(Entity entity, AABB axisalignedbb) {
        this.entityBuffer.clear();
        int i = MathHelper.floor_double((axisalignedbb.minX - 2.0) / 16.0);
        int j = MathHelper.floor_double((axisalignedbb.maxX + 2.0) / 16.0);
        int k = MathHelper.floor_double((axisalignedbb.minZ - 2.0) / 16.0);
        int l = MathHelper.floor_double((axisalignedbb.maxZ + 2.0) / 16.0);
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                if (!this.isChunkLoaded(i1, j1)) continue;
                this.getChunkFromChunkCoords(i1, j1).getEntitiesWithinAABBForEntity(entity, axisalignedbb, this.entityBuffer);
            }
        }
        return this.entityBuffer;
    }

    public List<Entity> getEntitiesWithinAABB(Class class1, AABB axisalignedbb) {
        int i = MathHelper.floor_double((axisalignedbb.minX - 2.0) / 16.0);
        int j = MathHelper.floor_double((axisalignedbb.maxX + 2.0) / 16.0);
        int k = MathHelper.floor_double((axisalignedbb.minZ - 2.0) / 16.0);
        int l = MathHelper.floor_double((axisalignedbb.maxZ + 2.0) / 16.0);
        ArrayList<Entity> arraylist = new ArrayList<Entity>();
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                if (!this.isChunkLoaded(i1, j1)) continue;
                this.getChunkFromChunkCoords(i1, j1).getEntitiesOfTypeWithinAAAB(class1, axisalignedbb, arraylist);
            }
        }
        return arraylist;
    }

    public List<Entity> getLoadedEntityList() {
        return this.loadedEntityList;
    }

    public void updateTileEntityChunkAndSendToPlayer(int i, int j, int k, TileEntity tileentity) {
        if (this.isBlockLoaded(i, j, k)) {
            this.getChunkFromBlockCoords(i, k).setChunkModified();
        }
        for (int l = 0; l < this.listeners.size(); ++l) {
            this.listeners.get(l).tileEntityChanged(i, j, k, tileentity);
        }
    }

    public int countEntities(Class class1) {
        int i = 0;
        for (int j = 0; j < this.loadedEntityList.size(); ++j) {
            Entity entity = this.loadedEntityList.get(j);
            if (!class1.isAssignableFrom(entity.getClass())) continue;
            ++i;
        }
        return i;
    }

    public void addLoadedEntities(List list) {
        this.loadedEntityList.addAll(list);
        for (int i = 0; i < list.size(); ++i) {
            this.obtainEntitySkin((Entity)list.get(i));
        }
    }

    public void unloadEntities(List list) {
        this.unloadedEntityList.addAll(list);
    }

    public void dropOldChunks() {
        while (this.chunkProvider.unload100OldestChunks()) {
        }
    }

    public boolean canBlockBePlacedAt(int blockId, int x, int y, int z, boolean flag, Side side) {
        if (y < 0 || y >= this.getHeightBlocks()) {
            return false;
        }
        int j1 = this.getBlockId(x, y, z);
        Block block = Block.blocksList[j1];
        Block block1 = Block.blocksList[blockId];
        AABB axisalignedbb = block1.getCollisionBoundingBoxFromPool(this, x, y, z);
        if (flag) {
            axisalignedbb = null;
        }
        if (axisalignedbb != null && !this.checkIfAABBIsClear(axisalignedbb)) {
            return false;
        }
        if (block != null && block.hasTag(BlockTags.PLACE_OVERWRITES)) {
            block = null;
        }
        return blockId > 0 && block == null && block1.canPlaceBlockOnSide(this, x, y, z, side.getId());
    }

    public Path getPathToEntity(Entity entity, Entity entityToTravelTo, float distance) {
        int x1 = MathHelper.floor_double(entity.x);
        int y2 = MathHelper.floor_double(entity.y);
        int z1 = MathHelper.floor_double(entity.z);
        int radius = (int)(distance + 16.0f);
        int xMin = x1 - radius;
        int yMin = y2 - radius;
        int zMin = z1 - radius;
        int xMax = x1 + radius;
        int yMax = y2 + radius;
        int zMax = z1 + radius;
        ChunkCache chunkcache = new ChunkCache(this, xMin, yMin, zMin, xMax, yMax, zMax);
        return new PathFinder(chunkcache).findPath(entity, entityToTravelTo, distance);
    }

    public Path getEntityPathToXYZ(Entity entity, int i, int j, int k, float f) {
        int l = MathHelper.floor_double(entity.x);
        int i1 = MathHelper.floor_double(entity.y);
        int j1 = MathHelper.floor_double(entity.z);
        int k1 = (int)(f + 8.0f);
        int l1 = l - k1;
        int i2 = i1 - k1;
        int j2 = j1 - k1;
        int k2 = l + k1;
        int l2 = i1 + k1;
        int i3 = j1 + k1;
        ChunkCache chunkcache = new ChunkCache(this, l1, i2, j2, k2, l2, i3);
        return new PathFinder(chunkcache).findPath(entity, i, j, k, f);
    }

    public boolean isBlockProvidingPowerTo(int i, int j, int k, int l) {
        int i1 = this.getBlockId(i, j, k);
        if (i1 == 0) {
            return false;
        }
        return Block.blocksList[i1].isIndirectlyPoweringTo(this, i, j, k, l);
    }

    public boolean isBlockGettingPowered(int i, int j, int k) {
        if (this.isBlockProvidingPowerTo(i, j - 1, k, 0)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(i, j + 1, k, 1)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(i, j, k - 1, 2)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(i, j, k + 1, 3)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(i - 1, j, k, 4)) {
            return true;
        }
        return this.isBlockProvidingPowerTo(i + 1, j, k, 5);
    }

    public boolean isBlockIndirectlyProvidingPowerTo(int i, int j, int k, int l) {
        int i1 = this.getBlockId(i, j, k);
        if (this.isBlockNormalCube(i, j, k) && i1 != Block.blockRedstone.id) {
            return this.isBlockGettingPowered(i, j, k);
        }
        if (i1 == 0) {
            return false;
        }
        return Block.blocksList[i1].isPoweringTo(this, i, j, k, l);
    }

    public boolean isBlockIndirectlyGettingPowered(int i, int j, int k) {
        if (this.isBlockIndirectlyProvidingPowerTo(i, j - 1, k, 0)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i, j + 1, k, 1)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i, j, k - 1, 2)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i, j, k + 1, 3)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i - 1, j, k, 4)) {
            return true;
        }
        return this.isBlockIndirectlyProvidingPowerTo(i + 1, j, k, 5);
    }

    public EntityPlayer getClosestPlayerToEntity(Entity entity, double radius) {
        return this.getClosestPlayer(entity.x, entity.y, entity.z, radius);
    }

    public EntityPlayer getClosestPlayer(double x, double y, double z, double radius) {
        double closestDistance = -1.0;
        EntityPlayer entityplayer = null;
        for (int i = 0; i < this.players.size(); ++i) {
            EntityPlayer entityPlayer1 = this.players.get(i);
            double currentDistance = entityPlayer1.distanceToSqr(x, y, z);
            if (!(radius < 0.0) && !(currentDistance < radius * radius) || closestDistance != -1.0 && !(currentDistance < closestDistance)) continue;
            closestDistance = currentDistance;
            entityplayer = entityPlayer1;
        }
        return entityplayer;
    }

    public EntityPlayer getPlayerEntityByName(String s) {
        for (int i = 0; i < this.players.size(); ++i) {
            if (!s.equals(this.players.get((int)i).username)) continue;
            return this.players.get(i);
        }
        return null;
    }

    public void setChunkData(int x, int y, int z, int width, int height, int length, byte[] abyte0) {
        int minChunkX = x >> 4;
        int minChunkZ = z >> 4;
        int maxChunkX = x + width - 1 >> 4;
        int maxChunkZ = z + length - 1 >> 4;
        int startIndex = 0;
        int minY = y;
        int maxY = y + height;
        if (minY < 0) {
            minY = 0;
        }
        if (maxY > this.getHeightBlocks()) {
            maxY = this.getHeightBlocks();
        }
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            int minX = x - chunkX * 16;
            int maxX = x + width - chunkX * 16;
            if (minX < 0) {
                minX = 0;
            }
            if (maxX > 16) {
                maxX = 16;
            }
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                int minZ = z - chunkZ * 16;
                int maxZ = z + length - chunkZ * 16;
                if (minZ < 0) {
                    minZ = 0;
                }
                if (maxZ > 16) {
                    maxZ = 16;
                }
                startIndex = this.getChunkFromChunkCoords(chunkX, chunkZ).setChunkData(abyte0, minX, minY, minZ, maxX, maxY, maxZ, startIndex);
                this.markBlocksDirty(chunkX * 16 + minX, minY, chunkZ * 16 + minZ, chunkX * 16 + maxX, maxY, chunkZ * 16 + maxZ);
            }
        }
    }

    public byte[] getChunkData(int x, int y, int z, int width, int height, int length) {
        byte[] abyte0 = new byte[width * height * length * 8 / 2];
        int minChunkX = x >> 4;
        int minChunkZ = z >> 4;
        int maxChunkX = x + width - 1 >> 4;
        int maxChunkZ = z + length - 1 >> 4;
        int startIndex = 0;
        int minY = y;
        int maxY = y + height;
        if (minY < 0) {
            minY = 0;
        }
        if (maxY > this.getHeightBlocks()) {
            maxY = this.getHeightBlocks();
        }
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            int minX = x - chunkX * 16;
            int maxX = x + width - chunkX * 16;
            if (minX < 0) {
                minX = 0;
            }
            if (maxX > 16) {
                maxX = 16;
            }
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                int minZ = z - chunkZ * 16;
                int maxZ = z + length - chunkZ * 16;
                if (minZ < 0) {
                    minZ = 0;
                }
                if (maxZ > 16) {
                    maxZ = 16;
                }
                startIndex = this.getChunkFromChunkCoords(chunkX, chunkZ).getChunkData(abyte0, minX, minY, minZ, maxX, maxY, maxZ, startIndex);
            }
        }
        return abyte0;
    }

    public void sendQuittingDisconnectingPacket() {
    }

    public void checkSessionLock() {
        this.saveHandler.checkSessionLock();
    }

    public void setWorldTime(long l) {
        this.levelData.setWorldTime(l);
    }

    public void setWorldTimeUpdateTicks(long l) {
        long l1 = l - this.levelData.getWorldTime();
        for (NextTickListEntry nextticklistentry : this.scheduledTickSet) {
            nextticklistentry.delay += l1;
        }
        this.setWorldTime(l);
    }

    public long getRandomSeed() {
        return this.levelData.getRandomSeed();
    }

    public long getWorldTime() {
        return this.levelData.getWorldTime();
    }

    public ChunkCoordinates getSpawnPoint() {
        return new ChunkCoordinates(this.levelData.getSpawnX(), this.levelData.getSpawnY(), this.levelData.getSpawnZ());
    }

    public void setSpawnPoint(ChunkCoordinates chunkcoordinates) {
        this.levelData.setSpawn(chunkcoordinates.x, chunkcoordinates.y, chunkcoordinates.z);
    }

    public void joinEntityInSurroundings(Entity entity) {
        int i = MathHelper.floor_double(entity.x / 16.0);
        int j = MathHelper.floor_double(entity.z / 16.0);
        int byte0 = 2;
        for (int k = i - byte0; k <= i + byte0; ++k) {
            for (int l = j - byte0; l <= j + byte0; ++l) {
                this.getChunkFromChunkCoords(k, l);
            }
        }
        if (!this.loadedEntityList.contains(entity)) {
            this.loadedEntityList.add(entity);
        }
    }

    public boolean canMineBlock(EntityPlayer entityplayer, int i, int j, int k) {
        return true;
    }

    public void sendTrackedEntityStatusUpdatePacket(Entity entityId, byte entityStatus) {
    }

    public void sendTrackedEntityStatusUpdatePacket(Entity entityId, byte entityStatus, float attackedAtYaw) {
    }

    public void updateEntityList() {
        this.loadedEntityList.removeAll(this.unloadedEntityList);
        for (int i = 0; i < this.unloadedEntityList.size(); ++i) {
            Entity entity = this.unloadedEntityList.get(i);
            int l = entity.chunkCoordX;
            int j1 = entity.chunkCoordZ;
            if (!entity.addedToChunk || !this.isChunkLoaded(l, j1)) continue;
            this.getChunkFromChunkCoords(l, j1).removeEntity(entity);
        }
        for (int j = 0; j < this.unloadedEntityList.size(); ++j) {
            this.releaseEntitySkin(this.unloadedEntityList.get(j));
        }
        this.unloadedEntityList.clear();
        for (int k = 0; k < this.loadedEntityList.size(); ++k) {
            Entity entity1 = this.loadedEntityList.get(k);
            if (entity1.vehicle != null) {
                if (!entity1.vehicle.removed && entity1.vehicle.passenger == entity1) continue;
                entity1.vehicle.passenger = null;
                entity1.vehicle = null;
            }
            if (!entity1.removed) continue;
            int i1 = entity1.chunkCoordX;
            int k1 = entity1.chunkCoordZ;
            if (entity1.addedToChunk && this.isChunkLoaded(i1, k1)) {
                this.getChunkFromChunkCoords(i1, k1).removeEntity(entity1);
            }
            this.loadedEntityList.remove(k--);
            this.releaseEntitySkin(entity1);
        }
    }

    public IChunkProvider getChunkProvider() {
        return this.chunkProvider;
    }

    public void playNoteAt(int x, int y, int z, int instrument, int pitch) {
        int j1 = this.getBlockId(x, y, z);
        if (j1 > 0) {
            Block.blocksList[j1].playBlock(this, x, y, z, instrument, pitch);
        }
    }

    public LevelStorage getSaveHandler() {
        return this.saveHandler;
    }

    public LevelData getLevelData() {
        return this.levelData;
    }

    public void updateEnoughPlayersSleepingFlag(EntityPlayer player) {
        this.enoughPlayersSleeping = false;
        if (this.players.size() > 0) {
            int playersSleeping = 0;
            int req = this.getPlayersRequiredToSkipNight();
            for (EntityPlayer p : this.players) {
                if (!p.isPlayerSleeping()) continue;
                ++playersSleeping;
            }
            if (playersSleeping >= req) {
                this.enoughPlayersSleeping = true;
            }
        }
    }

    public int getPlayersRequiredToSkipNight() {
        return (int)((double)this.players.size() * ((double)this.sleepPercent / 100.0));
    }

    protected void wakeUpAllPlayers() {
        this.enoughPlayersSleeping = false;
        for (EntityPlayer entityplayer : this.players) {
            if (!entityplayer.isPlayerSleeping()) continue;
            entityplayer.wakeUpPlayer(false, false);
        }
        if (this.currentWeather != null && this.currentWeather.spawnRainParticles) {
            this.newWeather = Weather.overworldClear;
        }
    }

    public boolean areEnoughPlayersFullyAsleep() {
        if (this.enoughPlayersSleeping && !this.isClientSide) {
            int fullyAsleep = 0;
            for (EntityPlayer player : this.players) {
                if (!player.isPlayerFullyAsleep()) continue;
                ++fullyAsleep;
            }
            return fullyAsleep >= this.getPlayersRequiredToSkipNight() && fullyAsleep > 0;
        }
        return false;
    }

    public boolean canBlockBeRainedOn(int i, int j, int k) {
        if (this.currentWeather == null) {
            return false;
        }
        if (!this.currentWeather.isPrecipitation) {
            return false;
        }
        if (!this.canBlockSeeTheSky(i, j, k)) {
            return false;
        }
        if (this.getHeightValue(i, k) > j) {
            return false;
        }
        Biome biomegenbase = this.getBlockBiome(i, j, k);
        for (int q = 0; q < biomegenbase.blockedWeathers.length; ++q) {
            if (biomegenbase.blockedWeathers[q] != this.currentWeather) continue;
            return false;
        }
        return true;
    }

    public void setSavedData(String s, SavedData mapdatabase) {
        this.savedDataStorage.set(s, mapdatabase);
    }

    public SavedData getSavedData(Class class1, String s) {
        return this.savedDataStorage.load(class1, s);
    }

    public int getUniqueDataId(String s) {
        return this.savedDataStorage.getFreeMetadataFor(s);
    }

    public void playSoundEffect(int id, int x, int y, int z, int data) {
        this.playSoundEffectForPlayer(null, id, x, y, z, data);
    }

    public void playSoundEffectForPlayer(EntityPlayer entityplayer, int i, int j, int k, int l, int i1) {
        for (LevelListener listener : this.listeners) {
            listener.levelEvent(entityplayer, i, j, k, l, i1);
        }
    }

    public WorldType getWorldType() {
        return this.worldType;
    }

    public EntityItem dropItem(int x, int y, int z, ItemStack itemStack) {
        float f = 0.7f;
        double x1 = (double)(this.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double y1 = (double)(this.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double z1 = (double)(this.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityitem = new EntityItem(this, (double)x + x1, (double)y + y1, (double)z + z1, itemStack);
        entityitem.delayBeforeCanPickup = 10;
        this.entityJoinedWorld(entityitem);
        return entityitem;
    }
}

