/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.biome;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.SpawnListEntry;
import net.minecraft.core.entity.animal.EntityChicken;
import net.minecraft.core.entity.animal.EntityCow;
import net.minecraft.core.entity.animal.EntityFireflyCluster;
import net.minecraft.core.entity.animal.EntityPig;
import net.minecraft.core.entity.animal.EntitySheep;
import net.minecraft.core.entity.animal.EntitySquid;
import net.minecraft.core.entity.monster.EntityArmoredZombie;
import net.minecraft.core.entity.monster.EntityCreeper;
import net.minecraft.core.entity.monster.EntitySkeleton;
import net.minecraft.core.entity.monster.EntitySlime;
import net.minecraft.core.entity.monster.EntitySnowman;
import net.minecraft.core.entity.monster.EntitySpider;
import net.minecraft.core.entity.monster.EntityZombie;
import net.minecraft.core.enums.EnumCreatureType;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTree;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreeFancy;
import net.minecraft.core.world.weather.Weather;

public class Biome {
    public int color;
    public short topBlock;
    public short fillerBlock;
    public Weather[] blockedWeathers = new Weather[0];
    protected List<SpawnListEntry> spawnableMonsterList;
    protected List<SpawnListEntry> spawnableCreatureList;
    protected List<SpawnListEntry> spawnableWaterCreatureList;
    protected List<SpawnListEntry> spawnableAmbientCreatureList;
    private boolean hasSurfaceSnow = false;

    public Biome() {
        this.topBlock = (short)Block.grass.id;
        this.fillerBlock = (short)Block.dirt.id;
        this.spawnableMonsterList = new ArrayList<SpawnListEntry>();
        this.spawnableCreatureList = new ArrayList<SpawnListEntry>();
        this.spawnableWaterCreatureList = new ArrayList<SpawnListEntry>();
        this.spawnableAmbientCreatureList = new ArrayList<SpawnListEntry>();
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySpider.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityZombie.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityArmoredZombie.class, 2));
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySkeleton.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityCreeper.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySlime.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySnowman.class, 2));
        this.spawnableCreatureList.add(new SpawnListEntry(EntitySheep.class, 102));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityPig.class, 102));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityChicken.class, 102));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityCow.class, 102));
        this.spawnableWaterCreatureList.add(new SpawnListEntry(EntitySquid.class, 10));
        if (this != Biomes.NETHER_NETHER) {
            this.spawnableAmbientCreatureList.add(new SpawnListEntry(EntityFireflyCluster.class, 10));
        }
    }

    public WorldFeature getRandomWorldGenForTrees(Random random) {
        if (random.nextInt(10) == 0) {
            return new WorldFeatureTreeFancy(Block.leavesOak.id, Block.logOak.id);
        }
        return new WorldFeatureTree(Block.leavesOak.id, Block.logOak.id, 4);
    }

    public Biome setColor(int color) {
        this.color = color;
        return this;
    }

    public int getSkyColor(float temperature) {
        if ((temperature /= 3.0f) < -1.0f) {
            temperature = -1.0f;
        }
        if (temperature > 1.0f) {
            temperature = 1.0f;
        }
        return Color.getHSBColor(0.6222222f - temperature * 0.125f, 0.5f + temperature * 0.1f, 1.0f).getRGB();
    }

    public List<SpawnListEntry> getSpawnableList(EnumCreatureType creatureType) {
        if (creatureType == EnumCreatureType.monster) {
            return this.spawnableMonsterList;
        }
        if (creatureType == EnumCreatureType.creature) {
            return this.spawnableCreatureList;
        }
        if (creatureType == EnumCreatureType.waterCreature) {
            return this.spawnableWaterCreatureList;
        }
        if (creatureType == EnumCreatureType.ambientCreature) {
            return this.spawnableAmbientCreatureList;
        }
        return null;
    }

    public boolean hasSurfaceSnow() {
        return this.hasSurfaceSnow;
    }

    public Biome setSurfaceSnow() {
        this.hasSurfaceSnow = true;
        return this;
    }

    public Biome setBlockedWeathers(Weather ... blocked) {
        this.blockedWeathers = blocked;
        return this;
    }

    public Biome setTopBlock(int id) {
        this.topBlock = (short)id;
        return this;
    }

    public Biome setFillerBlock(int id) {
        this.fillerBlock = (short)id;
        return this;
    }
}

