/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.biome;

import net.minecraft.core.block.Block;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.BiomeBirchForest;
import net.minecraft.core.world.biome.BiomeBorealForest;
import net.minecraft.core.world.biome.BiomeForest;
import net.minecraft.core.world.biome.BiomeNether;
import net.minecraft.core.world.biome.BiomeOutback;
import net.minecraft.core.world.biome.BiomeParadise;
import net.minecraft.core.world.biome.BiomeRainforest;
import net.minecraft.core.world.biome.BiomeRetro;
import net.minecraft.core.world.biome.BiomeSeasonalForest;
import net.minecraft.core.world.biome.BiomeShrubland;
import net.minecraft.core.world.biome.BiomeSwamp;
import net.minecraft.core.world.biome.BiomeTaiga;
import net.minecraft.core.world.weather.Weather;

public class Biomes {
    public static final Biome OVERWORLD_RAINFOREST = Biomes.register("minecraft:overworld.rainforest", new BiomeRainforest().setColor(588342).setBlockedWeathers(Weather.overworldSnow));
    public static final Biome OVERWORLD_SWAMPLAND = Biomes.register("minecraft:overworld.swampland", new BiomeSwamp().setColor(65459));
    public static final Biome OVERWORLD_SEASONAL_FOREST = Biomes.register("minecraft:overworld.seasonal_forest", new BiomeSeasonalForest().setColor(10215459));
    public static final Biome OVERWORLD_FOREST = Biomes.register("minecraft:overworld.forest", new BiomeForest().setColor(353825));
    public static final Biome OVERWORLD_GRASSLANDS = Biomes.register("minecraft:overworld.grasslands", new Biome().setColor(14278691).setBlockedWeathers(Weather.overworldSnow));
    public static final Biome OVERWORLD_OUTBACK = Biomes.register("minecraft:overworld.outback", new Biome().setColor(14246435).setBlockedWeathers(Weather.overworldSnow).setTopBlock(Block.dirtScorched.id).setFillerBlock(Block.dirtScorched.id));
    public static final Biome OVERWORLD_SHRUBLAND = Biomes.register("minecraft:overworld.shrubland", new BiomeShrubland().setColor(10595616));
    public static final Biome OVERWORLD_TAIGA = Biomes.register("minecraft:overworld.taiga", new BiomeTaiga().setColor(0xEDFFFE).setSurfaceSnow());
    public static final Biome OVERWORLD_BOREAL_FOREST = Biomes.register("minecraft:overworld.boreal_forest", new BiomeBorealForest().setColor(5097842));
    public static final Biome OVERWORLD_DESERT = Biomes.register("minecraft:overworld.desert", new Biome().setColor(0xFFFB00).setBlockedWeathers(Weather.overworldRain, Weather.overworldSnow, Weather.overworldStorm).setTopBlock(Block.sand.id).setFillerBlock(Block.sand.id));
    public static final Biome OVERWORLD_PLAINS = Biomes.register("minecraft:overworld.plains", new Biome().setColor(16776066));
    public static final Biome OVERWORLD_GLACIER = Biomes.register("minecraft:overworld.glacier", new Biome().setColor(16772499).setSurfaceSnow().setTopBlock(Block.blockSnow.id).setFillerBlock(Block.blockSnow.id));
    public static final Biome OVERWORLD_TUNDRA = Biomes.register("minecraft:overworld.tundra", new Biome().setColor(5762041).setSurfaceSnow());
    public static final Biome OVERWORLD_MEADOW = Biomes.register("minecraft:overworld.meadow", new BiomeBorealForest().setColor(6986131));
    public static final Biome NETHER_NETHER = Biomes.register("minecraft:nether.nether", new BiomeNether().setColor(0xFF0000).setBlockedWeathers(Weather.overworldRain, Weather.overworldSnow, Weather.overworldStorm, Weather.overworldFog));
    public static final Biome PARADISE_PARADISE = Biomes.register("minecraft:paradise.paradise", new BiomeParadise().setColor(0x8080FF).setBlockedWeathers(Weather.overworldRain, Weather.overworldSnow, Weather.overworldStorm, Weather.overworldFog));
    public static final Biome OVERWORLD_BIRCH_FOREST = Biomes.register("minecraft:overworld.birch_forest", new BiomeBirchForest().setColor(6764799));
    public static final Biome OVERWORLD_RETRO = Biomes.register("minecraft:overworld.retro", new BiomeRetro().setColor(7778634).setTopBlock(Block.grassRetro.id));
    public static final Biome OVERWORLD_HELL = Biomes.register("minecraft:overworld.hell", new Biome().setColor(14246435).setTopBlock(Block.dirtScorched.id).setTopBlock(Block.dirtScorched.id));
    public static final Biome OVERWORLD_SWAMPLAND_MUDDY = Biomes.register("minecraft:overworld.swampland.muddy", new BiomeSwamp().setColor(5383936));
    public static final Biome OVERWORLD_OUTBACK_GRASSY = Biomes.register("minecraft:overworld.outback.grassy", new BiomeOutback().setColor(14246435).setBlockedWeathers(Weather.overworldSnow).setTopBlock(Block.grassScorched.id).setFillerBlock(Block.dirtScorched.id));

    public static Biome register(String key, Biome biome) {
        Registries.BIOMES.register(key, biome);
        return biome;
    }
}

