/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.biome.data;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import net.minecraft.core.Global;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.data.BiomeRange;
import net.minecraft.core.world.biome.data.BiomeRangeLookup;

public final class BiomeRangeMap {
    private final Map<Biome, Set<BiomeRange>> ranges = new LinkedHashMap<Biome, Set<BiomeRange>>();
    private BiomeRangeLookup lookup = null;

    public void addRange(Biome biome, BiomeRange ... ranges) {
        if (ranges == null || ranges.length == 0 || this.lookup != null) {
            return;
        }
        Set set = this.ranges.getOrDefault(biome, new HashSet());
        set.addAll(Arrays.asList(ranges));
        this.ranges.put(biome, set);
    }

    public void lock() {
        this.lookup = new BiomeRangeLookup(this, 50);
    }

    public Set<BiomeRange> getRanges(Biome biome) {
        Set<BiomeRange> ranges = this.ranges.get(biome);
        if (ranges == null) {
            return null;
        }
        return Collections.unmodifiableSet(ranges);
    }

    public boolean hasGaps() {
        for (double temperature = 0.0; temperature < 1.0; temperature += 0.01) {
            for (double humidity = 0.0; humidity < 1.0; humidity += 0.01) {
                for (double altitude = 0.0; altitude < 1.0; altitude += 0.01) {
                    for (double variety = 0.0; variety < 1.0; variety += 0.01) {
                        Biome biome = this.lookupBiome(temperature, humidity, altitude, variety);
                        if (biome != null) continue;
                        System.out.println("Gap found in biome map at:\nTemperature: " + temperature + "\nHumidity: " + humidity + "\nAltitude: " + altitude);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public Biome lookupBiome(double temperature, double humidity, double altitude, double variety) {
        temperature = MathHelper.clamp(temperature, 0.0, 1.0);
        humidity = MathHelper.clamp(humidity, 0.0, 1.0);
        altitude = MathHelper.clamp(altitude, 0.0, 1.0);
        variety = MathHelper.clamp(variety, 0.0, 1.0);
        return this.lookup.getBiome(temperature, humidity, altitude, variety);
    }

    Biome findBiome(double temperature, double humidity, double altitude, double variety) {
        temperature = MathHelper.clamp(temperature, 0.0, 1.0);
        humidity = MathHelper.clamp(humidity, 0.0, 1.0);
        altitude = MathHelper.clamp(altitude, 0.0, 1.0);
        variety = MathHelper.clamp(variety, 0.0, 1.0);
        Biome last = null;
        for (Map.Entry<Biome, Set<BiomeRange>> entry : this.ranges.entrySet()) {
            for (BiomeRange range : entry.getValue()) {
                if (!range.contains(temperature, humidity, altitude, variety)) continue;
                last = entry.getKey();
            }
        }
        if (last == null) {
            System.out.println("Warning: found NULL biome for T: " + temperature + " H: " + humidity + " A: " + altitude + " V: " + variety);
        }
        return last;
    }

    public void generateDebugImage(boolean skewed) {
        BufferedImage image = new BufferedImage(4800, 4800, 1);
        Graphics2D g = image.createGraphics();
        g.setColor(Color.black);
        g.fillRect(0, 0, 4800, 4800);
        for (int ti = 0; ti < 100; ++ti) {
            for (int hi = 0; hi < 100; ++hi) {
                double temperature = (double)ti / 99.0;
                double humidity = (double)hi / 99.0;
                temperature = (double)Math.round(temperature * 100.0) / 100.0;
                humidity = (double)Math.round(humidity * 100.0) / 100.0;
                Biome biome = this.lookupBiome(temperature, humidity, 0.5, 0.5);
                if (skewed) {
                    biome = this.lookupBiome(temperature, humidity * temperature, 0.5, 0.5);
                }
                Color color = biome == null ? Color.magenta : BiomeRangeMap.hex2Rgb(biome.color);
                g.setColor(color);
                g.fillRect(hi * 48, ti * 48, 48, 48);
                g.setColor(Color.black);
                g.drawRect(hi * 48, ti * 48, 48, 48);
                g.drawString("T: " + temperature, hi * 48, ti * 48 + 12);
                g.drawString("H: " + humidity, hi * 48, ti * 48 + 24);
                if (biome == null) continue;
                g.drawString(String.format("%6s", Registries.BIOMES.getKey(biome).substring("minecraft:overworld.".length())), hi * 48, ti * 48 + 36);
            }
        }
        g.dispose();
        File file = new File(Global.accessor.getMinecraftDir(), skewed ? "BiomeLookupSkewed.png" : "BiomeLookup.png");
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Color hex2Rgb(int colourHex) {
        int r = (colourHex & 0xFF0000) >> 16;
        int g = (colourHex & 0xFF00) >> 8;
        int b = colourHex & 0xFF;
        return new Color(r, g, b);
    }
}

