/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk.reader;

import com.mojang.nbt.CompoundTag;
import java.util.Map;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.Registry;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.reader.ChunkReader;
import net.minecraft.core.world.data.ChunkNibbleArray;
import net.minecraft.core.world.data.ChunkUnsignedByteArray;

public class ChunkReaderVersion1
extends ChunkReader {
    public ChunkReaderVersion1(World world, CompoundTag tag) {
        super(world, tag);
    }

    @Override
    public int getX() {
        return this.tag.getInteger("xPos");
    }

    @Override
    public int getZ() {
        return this.tag.getInteger("zPos");
    }

    @Override
    public short[] getBlocks() {
        return this.tag.getShortArray("Blocks");
    }

    @Override
    public ChunkUnsignedByteArray getData() {
        return new ChunkUnsignedByteArray(16, this.world.getHeightBlocks(), 16, this.tag.getByteArray("Data"));
    }

    @Override
    public ChunkNibbleArray getSkyLight() {
        return new ChunkNibbleArray(16, this.world.getHeightBlocks(), 16, this.tag.getByteArray("SkyLight"));
    }

    @Override
    public ChunkNibbleArray getBlockLight() {
        return new ChunkNibbleArray(16, this.world.getHeightBlocks(), 16, this.tag.getByteArray("BlockLight"));
    }

    @Override
    public short[] getHeightMap() {
        return this.tag.getShortArrayOrDefault("HeightMap", null);
    }

    @Override
    public int getAverageBlockHeight() {
        return this.tag.getInteger("AverageBlockHeight");
    }

    @Override
    public boolean getIsTerrainPopulated() {
        return this.tag.getBoolean("TerrainPopulated");
    }

    @Override
    public double[] getTemperatureMap() {
        return this.tag.getDoubleArray("TemperatureMap");
    }

    @Override
    public double[] getHumidityMap() {
        return this.tag.getDoubleArray("HumidityMap");
    }

    @Override
    public byte[] getBiomeMap() {
        CompoundTag registriesTag = this.tag.getCompoundOrDefault("Registries", null);
        CompoundTag biomesTag = null;
        if (registriesTag != null) {
            biomesTag = registriesTag.getCompoundOrDefault("Biomes", null);
        }
        byte[] oldBiomes = this.tag.getByteArray("BiomeMap");
        byte[] newBiomes = new byte[oldBiomes.length];
        if (registriesTag == null || biomesTag == null) {
            return oldBiomes;
        }
        Map<Integer, String> idMap = Registry.readIdMapFromTag(biomesTag);
        for (int i = 0; i < oldBiomes.length; ++i) {
            byte newBiomeId;
            byte oldBiomeId = oldBiomes[i];
            newBiomes[i] = oldBiomeId < 0 ? oldBiomeId : (newBiomeId = (byte)Registries.BIOMES.getNumericIdOfItem(Registries.BIOMES.getItem(idMap.get(oldBiomeId))));
        }
        return newBiomes;
    }
}

