/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk.writer;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.Registry;
import net.minecraft.core.world.World;
import net.minecraft.core.world.data.ChunkNibbleArray;
import net.minecraft.core.world.data.ChunkUnsignedByteArray;

public class ChunkWriter {
    private final World world;
    private final CompoundTag tag;

    public ChunkWriter(World world, CompoundTag tag) {
        this.world = world;
        this.tag = tag;
    }

    public void putXPos(int xPos) {
        this.tag.putInt("xPos", xPos);
    }

    public void putZPos(int zPos) {
        this.tag.putInt("zPos", zPos);
    }

    public void putLastUpdate(long lastUpdate) {
        this.tag.putLong("LastUpdate", lastUpdate);
    }

    public void putBlocks(short[] blocks) {
        this.tag.putShortArray("Blocks", blocks);
    }

    public void putData(ChunkUnsignedByteArray data) {
        this.tag.putByteArray("Data", data.data);
    }

    public void putSkyLight(ChunkNibbleArray skyLight) {
        this.tag.putByteArray("SkyLight", skyLight.data);
    }

    public void putBlockLight(ChunkNibbleArray blockLight) {
        this.tag.putByteArray("BlockLight", blockLight.data);
    }

    public void putHeightMap(short[] heightMap) {
        this.tag.putShortArray("HeightMap", heightMap);
    }

    public void putAverageBlockHeight(int averageBlockHeight) {
        this.tag.putInt("AverageBlockHeight", averageBlockHeight);
    }

    public void putTerrainPopulated(boolean terrainPopulated) {
        this.tag.putBoolean("TerrainPopulated", terrainPopulated);
    }

    public void putTemperatureMap(double[] temperatureMap) {
        this.tag.putDoubleArray("TemperatureMap", temperatureMap);
    }

    public void putHumidityMap(double[] humidityMap) {
        this.tag.putDoubleArray("HumidityMap", humidityMap);
    }

    public void putBiomeMap(byte[] biomeMap) {
        this.tag.putByteArray("BiomeMap", biomeMap);
        CompoundTag registriesTag = this.tag.getCompoundOrDefault("Registries", new CompoundTag());
        CompoundTag biomesTag = new CompoundTag();
        Registry.writeIdMapToTag(Registries.BIOMES, biomesTag);
        registriesTag.putCompound("Biomes", biomesTag);
        this.tag.putCompound("Registries", registriesTag);
    }
}

