/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.data;

import net.minecraft.core.world.data.ChunkArray;

public class ChunkNibbleArray
implements ChunkArray<Integer> {
    public final byte[] data;
    private final int heightBits;

    public ChunkNibbleArray(int xSize, int ySize, int zSize) {
        this.data = new byte[xSize * ySize * zSize >> 1];
        this.heightBits = (int)Math.ceil(Math.log(ySize) / Math.log(2.0));
    }

    public ChunkNibbleArray(int xSize, int ySize, int zSize, byte[] data) {
        this.heightBits = (int)Math.ceil(Math.log(ySize) / Math.log(2.0));
        this.data = (byte[])(data.length == xSize * ySize * zSize >> 1 ? data : null);
    }

    @Override
    public Integer get(int x, int y, int z) {
        int index = x << this.heightBits + 4 | z << this.heightBits | y;
        int nibbleIndex = index >> 1;
        int nibblePart = index & 1;
        if (nibblePart == 0) {
            return this.data[nibbleIndex] & 0xF;
        }
        return this.data[nibbleIndex] >> 4 & 0xF;
    }

    @Override
    public void set(int x, int y, int z, Integer value) {
        int index = x << this.heightBits + 4 | z << this.heightBits | y;
        int nibbleIndex = index >> 1;
        int nibblePart = index & 1;
        this.data[nibbleIndex] = nibblePart == 0 ? (byte)(this.data[nibbleIndex] & 0xF0 | value & 0xF) : (byte)(this.data[nibbleIndex] & 0xF | (value & 0xF) << 4);
    }

    @Override
    public boolean isValid() {
        return this.data != null;
    }
}

