/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.data;

import net.minecraft.core.world.data.ChunkArray;

public class ChunkUnsignedByteArray
implements ChunkArray<Integer> {
    public final byte[] data;
    private final int heightBits;

    public ChunkUnsignedByteArray(int xSize, int ySize, int zSize) {
        this.data = new byte[xSize * ySize * zSize];
        this.heightBits = (int)Math.ceil(Math.log(ySize) / Math.log(2.0));
    }

    public ChunkUnsignedByteArray(int xSize, int ySize, int zSize, byte[] data) {
        this.heightBits = (int)Math.ceil(Math.log(ySize) / Math.log(2.0));
        this.data = (byte[])(data.length == xSize * ySize * zSize ? data : null);
    }

    @Override
    public Integer get(int x, int y, int z) {
        int index = x << this.heightBits + 4 | z << this.heightBits | y;
        return Byte.toUnsignedInt(this.data[index]);
    }

    @Override
    public void set(int x, int y, int z, Integer value) {
        int index = x << this.heightBits + 4 | z << this.heightBits | y;
        this.data[index] = value.byteValue();
    }

    @Override
    public boolean isValid() {
        return this.data != null;
    }
}

