/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk;

import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.data.ChunkNibbleArray;
import net.minecraft.core.world.data.ChunkUnsignedByteArray;
import net.minecraft.core.world.generate.chunk.ChunkDecorator;

public abstract class ChunkGenerator {
    protected final World world;
    private final ChunkDecorator decorator;

    public ChunkGenerator(World world, ChunkDecorator decorator) {
        this.world = world;
        this.decorator = decorator;
    }

    public final Chunk generate(int chunkX, int chunkZ) {
        Chunk chunk = new Chunk(this.world, chunkX, chunkZ);
        chunk.temperature = this.world.getBiomeProvider().getTemperatures(null, chunkX * 16, chunkZ * 16, 16, 16);
        chunk.humidity = this.world.getBiomeProvider().getHumidities(null, chunkX * 16, chunkZ * 16, 16, 16);
        chunk.variety = this.world.getBiomeProvider().getVarieties(null, chunkX * 16, chunkZ * 16, 16, 16);
        Biome[] biomes = this.world.getBiomeProvider().getBiomes(null, chunk.temperature, chunk.humidity, chunk.variety, chunkX * 16, 0, chunkZ * 16, 16, this.world.getHeightBlocks() >> 3, 16);
        for (int i = 0; i < biomes.length; ++i) {
            chunk.biome[i] = (byte)Registries.BIOMES.getNumericIdOfItem(biomes[i]);
        }
        chunk.blocks = this.doBlockGeneration(chunk);
        chunk.data = new ChunkUnsignedByteArray(16, this.world.getHeightBlocks(), 16);
        chunk.skylightMap = new ChunkNibbleArray(16, this.world.getHeightBlocks(), 16);
        chunk.blocklightMap = new ChunkNibbleArray(16, this.world.getHeightBlocks(), 16);
        chunk.generateMaps();
        return chunk;
    }

    public final void decorate(Chunk chunk) {
        this.decorator.decorate(chunk);
    }

    protected abstract short[] doBlockGeneration(Chunk var1);
}

