/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.flat;

import net.minecraft.core.block.Block;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.generate.chunk.flat.ChunkDecoratorFlat;

public class ChunkGeneratorFlat
extends ChunkGenerator {
    public ChunkGeneratorFlat(World world) {
        super(world, new ChunkDecoratorFlat());
    }

    @Override
    protected short[] doBlockGeneration(Chunk chunk) {
        short[] blocks = new short[256 * this.world.getHeightBlocks()];
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                int y;
                int xzIndex = x << this.world.getHeightBits() + 4 | z << this.world.getHeightBits();
                blocks[xzIndex + 0] = (short)Block.bedrock.id;
                for (y = 1; y < 4; ++y) {
                    blocks[xzIndex + y] = (short)Block.stone.id;
                }
                for (y = 4; y < 6; ++y) {
                    blocks[xzIndex + y] = (short)Block.dirt.id;
                }
                blocks[xzIndex + 6] = (short)Block.grass.id;
            }
        }
        return blocks;
    }
}

