/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.perlin.overworld;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockSand;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.BiomeOutback;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.ChunkDecorator;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.generate.feature.WorldFeatureCactus;
import net.minecraft.core.world.generate.feature.WorldFeatureClay;
import net.minecraft.core.world.generate.feature.WorldFeatureDeadBush;
import net.minecraft.core.world.generate.feature.WorldFeatureDungeon;
import net.minecraft.core.world.generate.feature.WorldFeatureFlowers;
import net.minecraft.core.world.generate.feature.WorldFeatureLabyrinth;
import net.minecraft.core.world.generate.feature.WorldFeatureLake;
import net.minecraft.core.world.generate.feature.WorldFeatureLiquid;
import net.minecraft.core.world.generate.feature.WorldFeatureOre;
import net.minecraft.core.world.generate.feature.WorldFeaturePumpkin;
import net.minecraft.core.world.generate.feature.WorldFeatureRichScorchedDirt;
import net.minecraft.core.world.generate.feature.WorldFeatureSpinifexPatch;
import net.minecraft.core.world.generate.feature.WorldFeatureSponge;
import net.minecraft.core.world.generate.feature.WorldFeatureSugarCane;
import net.minecraft.core.world.generate.feature.WorldFeatureSugarCaneTall;
import net.minecraft.core.world.generate.feature.WorldFeatureTallGrass;
import net.minecraft.core.world.noise.PerlinNoise;
import net.minecraft.core.world.type.WorldTypes;

public class ChunkDecoratorOverworld
implements ChunkDecorator {
    private final World world;
    private final PerlinNoise treeDensityNoise;
    private final int treeDensityOverride;

    protected ChunkDecoratorOverworld(World world, int treeDensityOverride) {
        this.world = world;
        this.treeDensityOverride = treeDensityOverride;
        this.treeDensityNoise = new PerlinNoise(world.getRandomSeed(), 8, 74);
    }

    public ChunkDecoratorOverworld(World world) {
        this(world, -1);
    }

    @Override
    public void decorate(Chunk chunk) {
        int i22;
        int j21;
        int j16;
        int l22;
        int i20;
        int i17;
        int i15;
        int j13;
        int k10;
        int j7;
        int i9;
        int j5;
        int chunkX = chunk.xPosition;
        int chunkZ = chunk.zPosition;
        int minY = this.world.getWorldType().getMinY();
        int maxY = this.world.getWorldType().getMaxY();
        int rangeY = maxY + 1 - minY;
        float oreHeightModifier = (float)rangeY / 128.0f;
        BlockSand.fallInstantly = true;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        int y = this.world.getHeightValue(x + 16, z + 16);
        Biome biome = this.world.getBlockBiome(x + 16, y, z + 16);
        Random rand = new Random(this.world.getRandomSeed());
        long l1 = rand.nextLong() / 2L * 2L + 1L;
        long l2 = rand.nextLong() / 2L * 2L + 1L;
        rand.setSeed((long)chunkX * l1 + (long)chunkZ * l2 ^ this.world.getRandomSeed());
        Random swampRand = new Random((long)chunkX * l1 + (long)chunkZ * l2 ^ this.world.getRandomSeed());
        double d = 0.25;
        if (biome == Biomes.OVERWORLD_SWAMPLAND) {
            for (int dx = 0; dx < 16; ++dx) {
                for (int dz = 0; dz < 16; ++dz) {
                    boolean shouldPlaceWater;
                    int topBlock = this.world.getHeightValue(x + dx, z + dz);
                    int id = this.world.getBlockId(x + dx, topBlock - 1, z + dz);
                    if (id != Block.grass.id) continue;
                    boolean bl = shouldPlaceWater = swampRand.nextFloat() < 0.5f;
                    if (!shouldPlaceWater) continue;
                    int posXId = this.world.getBlockId(x + dx + 1, topBlock - 1, z + dz);
                    int negXId = this.world.getBlockId(x + dx - 1, topBlock - 1, z + dz);
                    int posZId = this.world.getBlockId(x + dx, topBlock - 1, z + dz + 1);
                    int negZId = this.world.getBlockId(x + dx, topBlock - 1, z + dz - 1);
                    int negYId = this.world.getBlockId(x + dx, topBlock - 2, z + dz);
                    if (posXId == 0 || !Block.blocksList[posXId].blockMaterial.isSolid() && Block.blocksList[posXId].blockMaterial != Material.water || negXId == 0 || !Block.blocksList[negXId].blockMaterial.isSolid() && Block.blocksList[negXId].blockMaterial != Material.water || posZId == 0 || !Block.blocksList[posZId].blockMaterial.isSolid() && Block.blocksList[posZId].blockMaterial != Material.water || negZId == 0 || !Block.blocksList[negZId].blockMaterial.isSolid() && Block.blocksList[negZId].blockMaterial != Material.water || negYId == 0 || !Block.blocksList[negYId].blockMaterial.isSolid()) continue;
                    this.world.setBlock(x + dx, topBlock - 1, z + dz, Block.fluidWaterStill.id);
                    this.world.setBlock(x + dx, topBlock, z + dz, 0);
                }
            }
        }
        int lakeChance = 4;
        if (biome == Biomes.OVERWORLD_SWAMPLAND) {
            lakeChance = 2;
        }
        if (biome == Biomes.OVERWORLD_DESERT) {
            lakeChance = 0;
        }
        if (lakeChance != 0 && rand.nextInt(lakeChance) == 0) {
            int fluid = Block.fluidWaterStill.id;
            if (biome.hasSurfaceSnow()) {
                fluid = Block.ice.id;
            }
            int i1 = x + rand.nextInt(16) + 8;
            int l4 = minY + rand.nextInt(rangeY);
            int i8 = z + rand.nextInt(16) + 8;
            new WorldFeatureLake(fluid).generate(this.world, rand, i1, l4, i8);
        }
        if (rand.nextInt(8) == 0) {
            int xf = x + rand.nextInt(16) + 8;
            int yf = minY + rand.nextInt(rand.nextInt(rangeY - rangeY / 16) + rangeY / 16);
            int zf = z + rand.nextInt(16) + 8;
            if (yf < minY + rangeY / 2 || rand.nextInt(10) == 0) {
                new WorldFeatureLake(Block.fluidLavaStill.id).generate(this.world, rand, xf, yf, zf);
            }
        }
        int k1 = 0;
        while ((float)k1 < 8.0f * oreHeightModifier) {
            j5 = x + rand.nextInt(16) + 8;
            int k8 = minY + rand.nextInt(rangeY);
            int j11 = z + rand.nextInt(16) + 8;
            if (rand.nextInt(2) == 0) {
                new WorldFeatureDungeon(Block.brickClay.id, Block.brickClay.id, null).generate(this.world, rand, j5, k8, j11);
            } else {
                new WorldFeatureDungeon(Block.cobbleStone.id, Block.cobbleStoneMossy.id, null).generate(this.world, rand, j5, k8, j11);
            }
            ++k1;
        }
        for (k1 = 0; k1 < 1; ++k1) {
            j5 = x + rand.nextInt(16) + 8;
            int j11 = z + rand.nextInt(16) + 8;
            int k8 = this.world.getHeightValue(j5, j11) - (rand.nextInt(2) + 2);
            if (rand.nextInt(5) == 0) {
                k8 -= rand.nextInt(10) + 30;
            }
            if (rand.nextInt(700) != 0) continue;
            Random lRand = chunk.getChunkRandom(75644760L);
            new WorldFeatureLabyrinth().generate(this.world, lRand, j5, k8, j11);
        }
        int i2 = 0;
        while ((float)i2 < 20.0f * oreHeightModifier) {
            int k5 = x + rand.nextInt(16);
            int l8 = minY + rand.nextInt(rangeY);
            int k11 = z + rand.nextInt(16);
            new WorldFeatureClay(32).generate(this.world, rand, k5, l8, k11);
            ++i2;
        }
        if (biome instanceof BiomeOutback) {
            int l5 = x + rand.nextInt(16);
            int l11 = z + rand.nextInt(16);
            i9 = this.world.getHeightValue(l5, l11);
            new WorldFeatureRichScorchedDirt(20).generate(this.world, rand, l5, i9, l11);
        }
        int j2 = 0;
        while ((float)j2 < 20.0f * oreHeightModifier) {
            int l5 = x + rand.nextInt(16);
            i9 = minY + rand.nextInt(rangeY);
            int l11 = z + rand.nextInt(16);
            new WorldFeatureOre(Block.dirt.id, 32, false).generate(this.world, rand, l5, i9, l11);
            ++j2;
        }
        int k2 = 0;
        while ((float)k2 < 10.0f * oreHeightModifier) {
            int i6 = x + rand.nextInt(16);
            int j9 = minY + rand.nextInt(rangeY);
            int i12 = z + rand.nextInt(16);
            new WorldFeatureOre(Block.gravel.id, 32, false).generate(this.world, rand, i6, j9, i12);
            ++k2;
        }
        int i3 = 0;
        while ((float)i3 < 20.0f * oreHeightModifier) {
            int j6 = x + rand.nextInt(16);
            int k9 = minY + rand.nextInt(rangeY);
            int j12 = z + rand.nextInt(16);
            new WorldFeatureOre(Block.oreCoalStone.id, 16, true).generate(this.world, rand, j6, k9, j12);
            ++i3;
        }
        int j3 = 0;
        while ((float)j3 < 20.0f * oreHeightModifier) {
            int k6 = x + rand.nextInt(16);
            int l9 = minY + rand.nextInt(rangeY / 2);
            int k12 = z + rand.nextInt(16);
            new WorldFeatureOre(Block.oreIronStone.id, 8, true).generate(this.world, rand, k6, l9, k12);
            ++j3;
        }
        int k3 = 0;
        while ((float)k3 < 2.0f * oreHeightModifier) {
            int l6 = x + rand.nextInt(16);
            int i10 = minY + rand.nextInt(rangeY / 4);
            int l12 = z + rand.nextInt(16);
            new WorldFeatureOre(Block.oreGoldStone.id, 8, true).generate(this.world, rand, l6, i10, l12);
            ++k3;
        }
        int l3 = 0;
        while ((float)l3 < 8.0f * oreHeightModifier) {
            int i7 = x + rand.nextInt(16);
            int j10 = minY + rand.nextInt(rangeY / 8);
            int i13 = z + rand.nextInt(16);
            new WorldFeatureOre(Block.oreRedstoneStone.id, 7, true).generate(this.world, rand, i7, j10, i13);
            ++l3;
        }
        int i4 = 0;
        while ((float)i4 < oreHeightModifier) {
            j7 = x + rand.nextInt(16);
            k10 = minY + rand.nextInt(rangeY / 8);
            j13 = z + rand.nextInt(16);
            new WorldFeatureOre(Block.oreDiamondStone.id, 7, true).generate(this.world, rand, j7, k10, j13);
            ++i4;
        }
        i4 = 0;
        while ((float)i4 < oreHeightModifier) {
            j7 = x + rand.nextInt(16);
            k10 = minY + rand.nextInt(rangeY / 2);
            j13 = z + rand.nextInt(16);
            new WorldFeatureOre(Block.mossStone.id, 32, true).generate(this.world, rand, j7, k10, j13);
            ++i4;
        }
        int j4 = 0;
        while ((float)j4 < oreHeightModifier) {
            int k7 = x + rand.nextInt(16);
            int l10 = minY + rand.nextInt(rangeY / 8) + rand.nextInt(rangeY / 8);
            int k13 = z + rand.nextInt(16);
            new WorldFeatureOre(Block.oreLapisStone.id, 6, true).generate(this.world, rand, k7, l10, k13);
            ++j4;
        }
        d = 0.5;
        int k4 = (int)((this.treeDensityNoise.get((double)x * d, (double)z * d) / 8.0 + rand.nextDouble() * 4.0 + 4.0) / 3.0);
        int treeDensity = 0;
        if (rand.nextInt(10) == 0) {
            ++treeDensity;
        }
        if (biome == Biomes.OVERWORLD_FOREST) {
            treeDensity += k4 + 5;
        }
        if (biome == Biomes.OVERWORLD_BIRCH_FOREST) {
            treeDensity += k4 + 4;
        }
        if (biome == Biomes.OVERWORLD_RAINFOREST) {
            treeDensity += k4 + 10;
        }
        if (biome == Biomes.OVERWORLD_SEASONAL_FOREST) {
            treeDensity += k4 + 2;
        }
        if (biome == Biomes.OVERWORLD_TAIGA) {
            treeDensity += k4 + 5;
        }
        if (biome == Biomes.OVERWORLD_BOREAL_FOREST) {
            treeDensity += k4 + 3;
        }
        if (biome == Biomes.OVERWORLD_DESERT) {
            treeDensity = 0;
        }
        if (biome == Biomes.OVERWORLD_TUNDRA) {
            treeDensity -= 20;
        }
        if (biome == Biomes.OVERWORLD_PLAINS) {
            treeDensity -= 20;
        }
        if (biome == Biomes.OVERWORLD_SWAMPLAND) {
            treeDensity += k4 + 4;
        }
        if (biome == Biomes.OVERWORLD_OUTBACK_GRASSY) {
            treeDensity += k4;
        }
        if (this.treeDensityOverride != -1) {
            treeDensity = this.treeDensityOverride;
        }
        for (int i11 = 0; i11 < treeDensity; ++i11) {
            int l13 = x + rand.nextInt(16) + 8;
            int j14 = z + rand.nextInt(16) + 8;
            WorldFeature feature = biome.getRandomWorldGenForTrees(rand);
            feature.func_517_a(1.0, 1.0, 1.0);
            feature.generate(this.world, rand, l13, this.world.getHeightValue(l13, j14), j14);
        }
        int byteReeds = 0;
        if (biome == Biomes.OVERWORLD_RAINFOREST) {
            byteReeds = 1;
        }
        for (int i11 = 0; i11 < byteReeds; ++i11) {
            int i18 = x + rand.nextInt(16) + 8;
            int i23 = z + rand.nextInt(16) + 8;
            int i21 = this.world.getHeightValue(i18, i23);
            new WorldFeatureSugarCaneTall().generate(this.world, rand, i18, i21, i23);
        }
        int byteMeadow = 0;
        if (biome == Biomes.OVERWORLD_SEASONAL_FOREST) {
            byteMeadow = 1;
        }
        if (biome == Biomes.OVERWORLD_MEADOW) {
            byteMeadow = 2;
        }
        if (biome == Biomes.OVERWORLD_BOREAL_FOREST) {
            byteMeadow = 2;
        }
        if (biome == Biomes.OVERWORLD_SHRUBLAND) {
            byteMeadow = 1;
        }
        for (int l14 = 0; l14 < byteMeadow; ++l14) {
            int blockId = Block.flowerYellow.id;
            if (rand.nextInt(3) != 0) {
                blockId = Block.flowerRed.id;
            }
            int l19 = x + rand.nextInt(16) + 8;
            int k22 = rand.nextInt(this.world.getHeightBlocks());
            int j24 = z + rand.nextInt(16) + 8;
            new WorldFeatureTallGrass(blockId).generate(this.world, rand, l19, k22, j24);
        }
        int byte0 = 0;
        if (biome == Biomes.OVERWORLD_FOREST) {
            byte0 = 2;
        }
        if (biome == Biomes.OVERWORLD_SWAMPLAND) {
            byte0 = 2;
        }
        if (biome == Biomes.OVERWORLD_TAIGA) {
            byte0 = 2;
        }
        if (biome == Biomes.OVERWORLD_PLAINS) {
            byte0 = 3;
        }
        if (biome == Biomes.OVERWORLD_OUTBACK_GRASSY || biome == Biomes.OVERWORLD_OUTBACK) {
            byte0 = 2;
        }
        for (int i14 = 0; i14 < byte0; ++i14) {
            int k14 = x + rand.nextInt(16) + 8;
            int l16 = minY + rand.nextInt(rangeY);
            int k19 = z + rand.nextInt(16) + 8;
            new WorldFeatureFlowers(Block.flowerYellow.id).generate(this.world, rand, k14, l16, k19);
        }
        int byte1 = 0;
        if (biome == Biomes.OVERWORLD_FOREST) {
            byte1 = 2;
        }
        if (biome == Biomes.OVERWORLD_MEADOW) {
            byte1 = 2;
        }
        if (biome == Biomes.OVERWORLD_RAINFOREST) {
            byte1 = 10;
        }
        if (biome == Biomes.OVERWORLD_DESERT) {
            byte1 = 5;
        }
        if (biome == Biomes.OVERWORLD_SEASONAL_FOREST) {
            byte1 = 2;
        }
        if (biome == Biomes.OVERWORLD_TAIGA) {
            byte1 = 1;
        }
        if (biome == Biomes.OVERWORLD_BOREAL_FOREST) {
            byte1 = 5;
        }
        if (biome == Biomes.OVERWORLD_PLAINS) {
            byte1 = 10;
        }
        if (biome == Biomes.OVERWORLD_SWAMPLAND) {
            byte1 = 4;
        }
        if (biome == Biomes.OVERWORLD_SHRUBLAND) {
            byte1 = 2;
        }
        if (biome == Biomes.OVERWORLD_OUTBACK_GRASSY) {
            byte1 = 25;
        }
        if (biome == Biomes.OVERWORLD_BIRCH_FOREST) {
            byte1 = 10;
        }
        for (int l14 = 0; l14 < byte1; ++l14) {
            int type = Block.tallgrass.id;
            if ((biome == Biomes.OVERWORLD_RAINFOREST || biome == Biomes.OVERWORLD_SWAMPLAND || biome == Biomes.OVERWORLD_BOREAL_FOREST || biome == Biomes.OVERWORLD_TAIGA) && rand.nextInt(3) != 0) {
                type = Block.tallgrassFern.id;
            }
            int l19 = x + rand.nextInt(16) + 8;
            int k22 = minY + rand.nextInt(rangeY);
            int j24 = z + rand.nextInt(16) + 8;
            new WorldFeatureTallGrass(type).generate(this.world, rand, l19, k22, j24);
        }
        byte1 = 0;
        if (biome == Biomes.OVERWORLD_OUTBACK) {
            byte1 = 4;
        }
        for (i15 = 0; i15 < byte1; ++i15) {
            i17 = x + rand.nextInt(16) + 8;
            i20 = minY + rand.nextInt(rangeY);
            l22 = z + rand.nextInt(16) + 8;
            new WorldFeatureSpinifexPatch().generate(this.world, rand, i17, i20, l22);
        }
        byte1 = 0;
        if (biome == Biomes.OVERWORLD_DESERT) {
            byte1 = 2;
        }
        for (i15 = 0; i15 < byte1; ++i15) {
            i17 = x + rand.nextInt(16) + 8;
            i20 = minY + rand.nextInt(rangeY);
            l22 = z + rand.nextInt(16) + 8;
            new WorldFeatureDeadBush(Block.deadbush.id).generate(this.world, rand, i17, i20, l22);
        }
        if (rand.nextInt(2) == 0) {
            int j15 = x + rand.nextInt(16) + 8;
            int j17 = minY + rand.nextInt(rangeY);
            int j20 = z + rand.nextInt(16) + 8;
            new WorldFeatureFlowers(Block.flowerRed.id).generate(this.world, rand, j15, j17, j20);
        }
        if (rand.nextInt(4) == 0) {
            int k15 = x + rand.nextInt(16) + 8;
            int k17 = minY + rand.nextInt(rangeY);
            int k20 = z + rand.nextInt(16) + 8;
            new WorldFeatureFlowers(Block.mushroomBrown.id).generate(this.world, rand, k15, k17, k20);
        }
        if (rand.nextInt(8) == 0) {
            int l15 = x + rand.nextInt(16) + 8;
            int l17 = minY + rand.nextInt(rangeY);
            int l20 = z + rand.nextInt(16) + 8;
            new WorldFeatureFlowers(Block.mushroomRed.id).generate(this.world, rand, l15, l17, l20);
        }
        if (rand.nextInt(5) == 0) {
            int i18 = x + rand.nextInt(16) + 8;
            int i23 = z + rand.nextInt(16) + 8;
            int i21 = this.world.getHeightValue(i18, i23);
            new WorldFeatureSugarCane().generate(this.world, rand, i18, i21, i23);
        }
        if (rand.nextInt(128) == 0) {
            j16 = x + rand.nextInt(16) + 8;
            j21 = z + rand.nextInt(16) + 8;
            i22 = this.world.getHeightValue(j16, j21);
            new WorldFeaturePumpkin().generate(this.world, rand, j16, i22, j21);
        }
        if (rand.nextInt(64) == 0) {
            j16 = x + rand.nextInt(16) + 8;
            j21 = z + rand.nextInt(16) + 8;
            i22 = this.world.getHeightValue(j16, j21);
            new WorldFeatureSponge().generate(this.world, rand, j16, i22, j21);
        }
        int k16 = 0;
        if (biome == Biomes.OVERWORLD_DESERT) {
            k16 += 10;
        }
        for (int k18 = 0; k18 < k16; ++k18) {
            int k21 = x + rand.nextInt(16) + 8;
            int j23 = minY + rand.nextInt(rangeY);
            int k24 = z + rand.nextInt(16) + 8;
            new WorldFeatureCactus().generate(this.world, rand, k21, j23, k24);
        }
        for (int l18 = 0; l18 < 50; ++l18) {
            int l21 = x + rand.nextInt(16) + 8;
            int k23 = minY + rand.nextInt(rand.nextInt(rangeY - rangeY / 16) + rangeY / 16);
            int l24 = z + rand.nextInt(16) + 8;
            new WorldFeatureLiquid(Block.fluidWaterFlowing.id).generate(this.world, rand, l21, k23, l24);
        }
        for (int i19 = 0; i19 < 20; ++i19) {
            i22 = x + rand.nextInt(16) + 8;
            int l23 = minY + rand.nextInt(rand.nextInt(rand.nextInt(rangeY - rangeY / 8) + rangeY / 16) + rangeY / 16);
            int i25 = z + rand.nextInt(16) + 8;
            new WorldFeatureLiquid(Block.fluidLavaFlowing.id).generate(this.world, rand, i22, l23, i25);
        }
        int oceanY = this.world.getWorldType().getOceanY();
        for (int dx = x + 8; dx < x + 8 + 16; ++dx) {
            for (int dz = z + 8; dz < z + 8 + 16; ++dz) {
                int dy = this.world.getHeightValue(dx, dz);
                Biome localBiome = this.world.getBlockBiome(dx, dy, dz);
                if ((localBiome.hasSurfaceSnow() || this.world.worldType == WorldTypes.OVERWORLD_WINTER) && dy > 0 && dy < this.world.getHeightBlocks() && this.world.isAirBlock(dx, dy, dz) && this.world.getBlockMaterial(dx, dy - 1, dz).blocksMotion()) {
                    this.world.setBlockWithNotify(dx, dy, dz, Block.layerSnow.id);
                }
                if (!localBiome.hasSurfaceSnow() && this.world.worldType != WorldTypes.OVERWORLD_WINTER || this.world.getBlockId(dx, oceanY - 1, dz) != Block.fluidWaterStill.id && this.world.getBlockId(dx, oceanY - 1, dz) != Block.fluidWaterFlowing.id) continue;
                this.world.setBlockWithNotify(dx, oceanY - 1, dz, Block.ice.id);
            }
        }
        BlockSand.fallInstantly = false;
    }
}

