/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.type;

import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.biome.provider.BiomeProviderSingleBiome;
import net.minecraft.core.world.config.season.SeasonConfig;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.generate.chunk.perlin.nether.ChunkGeneratorNether;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.wind.WindManager;

public abstract class WorldTypeNether
extends WorldType {
    public WorldTypeNether(String languageKey, Weather defaultWeather, WindManager windManager, SeasonConfig defaultSeasonConfig) {
        super(languageKey, defaultWeather, windManager, true, WorldTypeNether.getLightRamp(), defaultSeasonConfig);
    }

    private static float[] getLightRamp() {
        float[] brightnessRamp = new float[32];
        float f = 0.1f;
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            brightnessRamp[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
        return brightnessRamp;
    }

    @Override
    public void onWorldCreation(World world) {
        super.onWorldCreation(world);
        world.setWorldTime(72000L);
    }

    @Override
    public int getOceanBlock() {
        return Block.fluidLavaStill.id;
    }

    @Override
    public int getFillerBlock() {
        return Block.netherrack.id;
    }

    @Override
    public BiomeProvider createBiomeProvider(World world) {
        return new BiomeProviderSingleBiome(Biomes.NETHER_NETHER, 1.0, 1.0, 1.0);
    }

    @Override
    public ChunkGenerator createChunkGenerator(World world) {
        return new ChunkGeneratorNether(world);
    }

    @Override
    public boolean isValidSpawn(World world, int x, int y, int z) {
        return true;
    }

    @Override
    public int getDayNightCycleLengthTicks() {
        return Global.DAY_LENGTH_TICKS;
    }

    @Override
    public float getCelestialAngle(World world, long tick, float partialTick) {
        return 0.5f;
    }

    @Override
    public float[] getSunriseColor(float timeOfDay, float partialTick) {
        return new float[4];
    }

    @Override
    public int getSkyDarken(World world, long tick, float partialTick) {
        return 0;
    }

    @Override
    public Vec3d getFogColor(float timeOfDay, float partialTick) {
        return Vec3d.createVector(0.0, 0.0, 0.0);
    }

    @Override
    public boolean mayRespawn() {
        return false;
    }

    @Override
    public float getCloudHeight() {
        return 0.0f;
    }

    @Override
    public boolean hasGround() {
        return true;
    }
}

