/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.weather;

import java.util.Random;
import net.minecraft.core.entity.EntityLightningBolt;
import net.minecraft.core.world.World;
import net.minecraft.core.world.weather.WeatherRain;

public class WeatherStorm
extends WeatherRain {
    public WeatherStorm(int id) {
        super(id);
    }

    @Override
    public float[] modifyFogColor(float r, float g, float b, float intensity) {
        float[] out = super.modifyFogColor(r, g, b, intensity);
        float f9 = 1.0f - intensity * 0.5f;
        out[0] = out[0] * f9;
        out[1] = out[1] * f9;
        out[2] = out[2] * f9;
        return out;
    }

    @Override
    public void doEnvironmentUpdate(World world, Random rand, int x, int z) {
        int y;
        super.doEnvironmentUpdate(world, rand, x, z);
        if (rand.nextInt((int)(100000.0f * (1.0f / world.weatherPower))) == 0 && world.canBlockBeRainedOn(x, y = world.getHeightValue(x, z), z)) {
            world.addWeatherEffect(new EntityLightningBolt(world, x, y, z));
        }
    }
}

