/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.entity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityBobber;
import net.minecraft.core.entity.EntityFallingSand;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.EntityPainting;
import net.minecraft.core.entity.EntityTNT;
import net.minecraft.core.entity.EntityTrackerEntry;
import net.minecraft.core.entity.animal.EntityFireflyCluster;
import net.minecraft.core.entity.animal.EntitySquid;
import net.minecraft.core.entity.animal.IAnimal;
import net.minecraft.core.entity.projectile.EntityArrow;
import net.minecraft.core.entity.projectile.EntityCannonball;
import net.minecraft.core.entity.projectile.EntityEgg;
import net.minecraft.core.entity.projectile.EntityFireball;
import net.minecraft.core.entity.projectile.EntityPebble;
import net.minecraft.core.entity.projectile.EntitySnowball;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.entity.vehicle.EntityMinecart;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.world.pathfinder.IdHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.EntityPlayerMP;

public class EntityTracker {
    private Set trackedEntitySet = new HashSet();
    private IdHashMap trackedEntityHashTable = new IdHashMap();
    private MinecraftServer mcServer;
    private int maxTrackingDistanceThreshold;
    private int field_28113_e;

    public EntityTracker(MinecraftServer minecraftserver, int i) {
        this.mcServer = minecraftserver;
        this.field_28113_e = i;
        this.maxTrackingDistanceThreshold = minecraftserver.configManager.getMaxTrackingDistance();
    }

    public void trackEntity(Entity entity) {
        if (entity instanceof EntityPlayerMP) {
            this.trackEntity(entity, 512, 2, false);
            EntityPlayerMP entityplayermp = (EntityPlayerMP)entity;
            for (EntityTrackerEntry entitytrackerentry : this.trackedEntitySet) {
                if (entitytrackerentry.trackedEntity == entityplayermp) continue;
                entitytrackerentry.updatePlayerEntity(entityplayermp);
            }
        } else if (entity instanceof EntityFireflyCluster) {
            this.trackEntity(entity, 160, 40, false);
        } else if (entity instanceof EntityBobber) {
            this.trackEntity(entity, 64, 5, true);
        } else if (entity instanceof EntityArrow) {
            this.trackEntity(entity, 64, 20, false);
        } else if (entity instanceof EntityCannonball) {
            this.trackEntity(entity, 64, 10, false);
        } else if (entity instanceof EntityFireball) {
            this.trackEntity(entity, 64, 10, false);
        } else if (entity instanceof EntitySnowball) {
            this.trackEntity(entity, 64, 10, true);
        } else if (entity instanceof EntityEgg) {
            this.trackEntity(entity, 64, 10, true);
        } else if (entity instanceof EntityPebble) {
            this.trackEntity(entity, 64, 10, true);
        } else if (entity instanceof EntityItem) {
            this.trackEntity(entity, 64, 20, true);
        } else if (entity instanceof EntityMinecart) {
            this.trackEntity(entity, 160, 5, true);
        } else if (entity instanceof EntityBoat) {
            this.trackEntity(entity, 160, 5, true);
        } else if (entity instanceof EntitySquid) {
            this.trackEntity(entity, 160, 3, true);
        } else if (entity instanceof IAnimal) {
            this.trackEntity(entity, 160, 3, false);
        } else if (entity instanceof EntityTNT) {
            this.trackEntity(entity, 160, 10, true);
        } else if (entity instanceof EntityFallingSand) {
            this.trackEntity(entity, 160, 20, true);
        } else if (entity instanceof EntityPainting) {
            this.trackEntity(entity, 160, Integer.MAX_VALUE, false);
        }
    }

    public void trackEntity(Entity entity, int trackingDistance, int packetDelay, boolean shouldSendMotionUpdates) {
        if (trackingDistance > this.maxTrackingDistanceThreshold) {
            trackingDistance = this.maxTrackingDistanceThreshold;
        }
        if (this.trackedEntityHashTable.containsItem(entity.id)) {
            throw new IllegalStateException("Entity is already tracked!");
        }
        EntityTrackerEntry entitytrackerentry = new EntityTrackerEntry(entity, trackingDistance, packetDelay, shouldSendMotionUpdates);
        this.trackedEntitySet.add(entitytrackerentry);
        this.trackedEntityHashTable.add(entity.id, entitytrackerentry);
        entitytrackerentry.updatePlayerEntities(this.mcServer.getWorldManager((int)this.field_28113_e).players);
    }

    public void untrackEntity(Entity entity) {
        EntityTrackerEntry entitytrackerentry;
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)entity;
            for (EntityTrackerEntry entitytrackerentry1 : this.trackedEntitySet) {
                entitytrackerentry1.removeFromTrackedPlayers(entityplayermp);
            }
        }
        if ((entitytrackerentry = (EntityTrackerEntry)this.trackedEntityHashTable.remove(entity.id)) != null) {
            this.trackedEntitySet.remove(entitytrackerentry);
            entitytrackerentry.sendDestroyEntityPacketToTrackedPlayers();
        }
    }

    public void updateTrackedEntities() {
        ArrayList<EntityPlayerMP> arraylist = new ArrayList<EntityPlayerMP>();
        for (EntityTrackerEntry entitytrackerentry : this.trackedEntitySet) {
            entitytrackerentry.updatePlayerList(this.mcServer.getWorldManager((int)this.field_28113_e).players);
            if (!entitytrackerentry.playerEntitiesUpdated || !(entitytrackerentry.trackedEntity instanceof EntityPlayerMP)) continue;
            arraylist.add((EntityPlayerMP)entitytrackerentry.trackedEntity);
        }
        for (int i = 0; i < arraylist.size(); ++i) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)arraylist.get(i);
            for (EntityTrackerEntry entitytrackerentry1 : this.trackedEntitySet) {
                if (entitytrackerentry1.trackedEntity == entityplayermp) continue;
                entitytrackerentry1.updatePlayerEntity(entityplayermp);
            }
        }
    }

    public void sendPacketToTrackedPlayers(Entity entity, Packet packet) {
        EntityTrackerEntry entitytrackerentry = (EntityTrackerEntry)this.trackedEntityHashTable.get(entity.id);
        if (entitytrackerentry != null) {
            entitytrackerentry.sendPacketToTrackedPlayers(packet);
        }
    }

    public void sendPacketToTrackedPlayersAndTrackedEntity(Entity entity, Packet packet) {
        EntityTrackerEntry entitytrackerentry = (EntityTrackerEntry)this.trackedEntityHashTable.get(entity.id);
        if (entitytrackerentry != null) {
            entitytrackerentry.sendPacketToTrackedPlayersAndTrackedEntity(packet);
        }
    }

    public void removeTrackedPlayerSymmetric(EntityPlayerMP entityplayermp) {
        for (EntityTrackerEntry entitytrackerentry : this.trackedEntitySet) {
            entitytrackerentry.removeTrackedPlayerSymmetric(entityplayermp);
        }
    }
}

