/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.world;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.net.packet.Packet61PlaySoundEffect;
import net.minecraft.core.sound.SoundType;
import net.minecraft.core.world.LevelListener;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.world.WorldServer;

public class WorldManager
implements LevelListener {
    private MinecraftServer mcServer;
    private WorldServer worldServer;

    public WorldManager(MinecraftServer minecraftserver, WorldServer worldserver) {
        this.mcServer = minecraftserver;
        this.worldServer = worldserver;
    }

    @Override
    public void addParticle(String particleKey, double x, double y, double z, double motionX, double motionY, double motionZ, double maxDistance) {
    }

    @Override
    public void addParticle(String particleKey, double x, double y, double z, double motionX, double motionY, double motionZ) {
    }

    @Override
    public void entityAdded(Entity entity) {
        if (entity instanceof EntityItem) {
            EntityItem entityItem = (EntityItem)entity;
            if (entityItem.item == null || entityItem.item.getItem() == null) {
                return;
            }
        }
        this.mcServer.getEntityTracker(this.worldServer.dimension.id).trackEntity(entity);
    }

    @Override
    public void entityRemoved(Entity entity) {
        this.mcServer.getEntityTracker(this.worldServer.dimension.id).untrackEntity(entity);
    }

    @Override
    public void playSound(String soundPath, SoundType soundType, double x, double y, double z, float volume, float pitch) {
    }

    @Override
    public void playBlockSoundEffect(Block block, EnumBlockSoundEffectType soundType, double x, double y, double z) {
    }

    @Override
    public void setBlocksDirty(int x0, int y0, int z0, int x1, int y1, int z1) {
    }

    @Override
    public void allChanged() {
    }

    @Override
    public void blockChanged(int x, int y, int z) {
        this.mcServer.configManager.markBlockNeedsUpdate(x, y, z, this.worldServer.dimension.id);
    }

    @Override
    public void playStreamingMusic(String soundPath, int x, int y, int z) {
    }

    @Override
    public void tileEntityChanged(int x, int y, int z, TileEntity tileEntity) {
        this.mcServer.configManager.sentTileEntityToPlayer(x, y, z, tileEntity);
    }

    @Override
    public void levelEvent(EntityPlayer player, int id, int x, int y, int z, int data) {
        this.mcServer.configManager.func_28171_a(player, x, y, z, 64.0, this.worldServer.dimension.id, new Packet61PlaySoundEffect(id, x, y, z, data));
    }
}

