/*
 * Decompiled with CFR 0.152.
 */
package net.betterthanadventure.utils;

import com.b100.utils.ImageUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Global;
import net.minecraft.core.MinecraftAccessor;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.biome.provider.BiomeProviderOverworld;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.save.LevelStorage;
import net.minecraft.core.world.save.SaveHandlerClientMP;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.type.WorldTypes;

public class BiomeFinder
implements MinecraftAccessor {
    public static long seed = 5217880148803501449L;
    public static int renderRes = 1024;
    public static int renderScale = 16;
    public static int posX = 0;
    public static int posY = 128;
    public static int posZ = 0;
    public Map<Biome, Integer> biomeColors = new HashMap<Biome, Integer>();
    private Color bg;
    private Set<Biome> allBiomes;
    private long lastProgress;
    private final Map<Biome, Integer> biomeCounts;

    public BiomeFinder() {
        this.biomeColors.put(Biomes.OVERWORLD_GLACIER, 13367039);
        this.biomeColors.put(Biomes.OVERWORLD_TUNDRA, 5759231);
        this.biomeColors.put(Biomes.OVERWORLD_TAIGA, 9092351);
        this.biomeColors.put(Biomes.OVERWORLD_BOREAL_FOREST, 1344868);
        this.biomeColors.put(Biomes.OVERWORLD_FOREST, 2532885);
        this.biomeColors.put(Biomes.OVERWORLD_SEASONAL_FOREST, 7320354);
        this.biomeColors.put(Biomes.OVERWORLD_BIRCH_FOREST, 4959582);
        this.biomeColors.put(Biomes.OVERWORLD_RAINFOREST, 1896704);
        this.biomeColors.put(Biomes.OVERWORLD_OUTBACK, 14245408);
        this.biomeColors.put(Biomes.OVERWORLD_OUTBACK_GRASSY, 15765559);
        this.biomeColors.put(Biomes.OVERWORLD_GRASSLANDS, 15790152);
        this.biomeColors.put(Biomes.OVERWORLD_SHRUBLAND, 12237368);
        this.biomeColors.put(Biomes.OVERWORLD_MEADOW, 0x8C8C22);
        this.biomeColors.put(Biomes.OVERWORLD_DESERT, 15589999);
        this.biomeColors.put(Biomes.OVERWORLD_SWAMPLAND, 46399);
        this.biomeColors.put(Biomes.OVERWORLD_PLAINS, 10733129);
        this.lastProgress = 0L;
        this.biomeCounts = new HashMap<Biome, Integer>();
        Global.accessor = this;
        WorldType worldType = WorldTypes.OVERWORLD_EXTENDED;
        Dimension dimension = Dimension.overworld;
        BiomeProvider biomeProvider = worldType.createBiomeProvider(new World((LevelStorage)new SaveHandlerClientMP(), "", dimension, worldType, seed));
        this.allBiomes = new HashSet<Biome>();
        BufferedImage biomeImage = new BufferedImage(renderRes, renderRes, 1);
        BufferedImage thvImage = new BufferedImage(renderRes, renderRes, 1);
        int areaSize = renderRes * renderScale;
        System.out.println("Render Area: " + areaSize + " x " + areaSize);
        int offsetX = -areaSize / 2 + posX;
        int offsetZ = -areaSize / 2 + posZ;
        System.out.println("Offset: " + offsetX + ", " + offsetZ);
        for (int i = 0; i < biomeImage.getWidth(); ++i) {
            for (int j = 0; j < biomeImage.getHeight(); ++j) {
                int x = offsetX + i * renderScale;
                int z = offsetZ + j * renderScale;
                Biome biome = biomeProvider.getBiome(x, posY, z);
                this.biomeCounts.put(biome, this.biomeCounts.getOrDefault(biome, 0) + 1);
                biomeImage.setRGB(i, j, this.getBiomeColor(biome));
                this.allBiomes.add(biome);
                double t = biomeProvider.getTemperature(x, z);
                double h = biomeProvider.getHumidity(x, z);
                double v = biomeProvider.getVariety(x, z);
                int rgb = (int)(t * 255.0) << 16 | (int)(h * 255.0) << 8 | (int)(v * 255.0);
                thvImage.setRGB(i, j, rgb);
            }
            if (System.currentTimeMillis() <= this.lastProgress + 1000L) continue;
            this.lastProgress = System.currentTimeMillis();
            float percent = (float)i / (float)biomeImage.getHeight();
            System.out.println((int)(percent * 100.0f) + "%");
        }
        int guiScale = Math.max(1, renderRes / 1024);
        System.out.println("GUI Scale: " + guiScale);
        this.bg = new Color(0, 0, 0, 240);
        Graphics g = biomeImage.getGraphics();
        g.setFont(new Font("Monospaced", 1, 13 * guiScale));
        this.drawBiomeList(biomeImage, g, guiScale);
        g.setColor(this.bg);
        g.fillRect(biomeImage.getWidth() / 4, 0, biomeImage.getWidth() / 2, 16 * guiScale);
        g.setColor(Color.white);
        g.drawString(areaSize / 2 + " Blocks", biomeImage.getWidth() / 4, 14 * guiScale);
        this.drawCenterMarker(biomeImage, g, guiScale * 2);
        g.dispose();
        ImageUtils.saveExternalImage(biomeImage, "biomes.png");
        ImageUtils.saveExternalImage(thvImage, "thv.png");
    }

    private void drawCenterMarker(BufferedImage image, Graphics g, int w) {
        g.setColor(Color.black);
        g.fillRect(image.getWidth() / 2 - w * 2, image.getHeight() / 2 - w * 2, w * 4, w * 4);
        g.setColor(Color.red);
        g.fillRect(image.getWidth() / 2 - w * 1, image.getHeight() / 2 - w * 1, w * 2, w * 2);
    }

    private void drawBiomeList(BufferedImage image, Graphics g, int guiScale) {
        ArrayList<Biome> biomeList = new ArrayList<Biome>(this.allBiomes);
        biomeList.sort((o1, o2) -> Registries.BIOMES.getNumericIdOfItem((Biome)o1) - Registries.BIOMES.getNumericIdOfItem((Biome)o2));
        int lineHeight = 16 * guiScale;
        int w = 192 * guiScale;
        int h = biomeList.size() * lineHeight;
        int x = 0;
        int y = image.getHeight() - h;
        g.setColor(this.bg);
        g.fillRect(x, y, w, h);
        for (int i = 0; i < biomeList.size(); ++i) {
            int y1 = y + i * lineHeight;
            Biome biome = (Biome)biomeList.get(i);
            g.setColor(new Color(this.getBiomeColor(biome)));
            g.fillRect(x + 2 * guiScale, y1 + 2 * guiScale, 12 * guiScale, 12 * guiScale);
            String biomeName = Registries.BIOMES.getKey(biome);
            if (biomeName.startsWith("minecraft:")) {
                biomeName = biomeName.substring(10);
            }
            if (biomeName.startsWith("overworld.")) {
                biomeName = biomeName.substring(10);
            }
            float pctg = (float)this.biomeCounts.get(biome).intValue() / (float)(image.getWidth() * image.getHeight());
            biomeName = biomeName + " (" + (int)(pctg * 100.0f) + "%)";
            g.drawString(biomeName, x + 16 * guiScale, y1 + 12 * guiScale);
        }
    }

    public int getBiomeColor(Biome biome) {
        Integer customColor = this.biomeColors.get(biome);
        return customColor != null ? customColor : 0xFF00FF;
    }

    @Override
    public File getMinecraftDir() {
        return null;
    }

    @Override
    public IChunkProvider createChunkProvider(World paramWorld, IChunkLoader paramIChunkLoader) {
        return null;
    }

    @Override
    public int getAutosaveTimer() {
        return 0;
    }

    public static void main(String[] args) {
        BiomeProviderOverworld.init();
        new BiomeFinder();
    }
}

