/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.discord;

import de.jcm.discordgamesdk.Core;
import de.jcm.discordgamesdk.CreateParams;
import de.jcm.discordgamesdk.Result;
import de.jcm.discordgamesdk.activity.Activity;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.discord.DownloadNativeLibrary;
import net.minecraft.client.entity.player.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.weather.Weather;

public class RichPresenceHandlerThread
extends Thread {
    private static final long clientId = 896803609696677898L;
    private Core core;
    private Minecraft minecraft;
    private Instant startTime;
    private static Map<Dimension, String> dimensionNamesMap = new HashMap<Dimension, String>();
    private static Map<Biome, String> biomeNamesMap;
    private static Map<Weather, String> weatherNamesMap;

    public RichPresenceHandlerThread(Minecraft mc) {
        this.minecraft = mc;
    }

    @Override
    public void run() {
        File discordLibrary = null;
        try {
            discordLibrary = DownloadNativeLibrary.downloadDiscordLibrary();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (discordLibrary == null) {
            System.err.println("Error downloading Discord SDK.");
            return;
        }
        Core.init((File)discordLibrary);
        this.startTime = Instant.now();
        this.updateActivity();
        Result r = this.core.activityManager().registerCommand("e");
        int counter = 0;
        while (true) {
            if (this.core != null) {
                this.core.runCallbacks();
            }
            try {
                Thread.sleep(16L);
                if (++counter < 256) continue;
                counter = 0;
                this.updateActivity();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void updateActivity() {
        if (!((Boolean)this.minecraft.gameSettings.discordRichPresence.value).booleanValue()) {
            if (this.core != null) {
                this.destroyCore();
            }
            return;
        }
        if (this.core == null) {
            this.createCore();
        }
        Activity activity = new Activity();
        activity.assets().setLargeImage("bta-logo");
        activity.timestamps().setStart(this.startTime);
        if (this.minecraft.theWorld == null) {
            activity.setState("In the main menu");
        } else if (this.minecraft.theWorld != null && this.minecraft.thePlayer != null) {
            if (this.minecraft.thePlayer instanceof EntityClientPlayerMP) {
                activity.setDetails("Multiplayer");
                int playerCount = ((EntityClientPlayerMP)this.minecraft.thePlayer).sendQueue.players.size();
                activity.party().size().setCurrentSize(playerCount);
                activity.party().size().setMaxSize(100);
            } else if (this.minecraft.currentScreen instanceof GuiIngameMenu) {
                activity.setDetails("Singleplayer (paused)");
            } else {
                activity.setDetails("Singleplayer");
            }
            Dimension activeDimension = Dimension.getDimensionList().get(this.minecraft.thePlayer.dimension);
            Biome biome = this.minecraft.theWorld.getBlockBiome((int)this.minecraft.thePlayer.x, (int)this.minecraft.thePlayer.y, (int)this.minecraft.thePlayer.z);
            Weather weather = this.minecraft.theWorld.getCurrentWeather();
            boolean displayDimension = activeDimension != null && dimensionNamesMap.containsKey(activeDimension);
            boolean displayBiome = biome != null && biomeNamesMap.containsKey(biome);
            boolean displayWeather = weather != null && weatherNamesMap.containsKey(weather);
            StringBuilder stateString = new StringBuilder();
            if (displayDimension) {
                stateString.append("In ").append(dimensionNamesMap.get(activeDimension));
            } else {
                stateString.append("Somewhere else");
            }
            if (displayBiome || displayWeather) {
                stateString.append(", ");
            }
            if (displayBiome) {
                stateString.append("exploring ").append(biomeNamesMap.get(biome));
            }
            if (displayWeather) {
                stateString.append(" ").append(weatherNamesMap.get(weather));
            }
            activity.setState(stateString.toString());
        }
        this.core.activityManager().updateActivity(activity);
    }

    private void createCore() {
        CreateParams params = new CreateParams();
        params.setClientID(896803609696677898L);
        params.setFlags(CreateParams.getDefaultFlags());
        this.core = new Core(params);
    }

    private void destroyCore() {
        this.core.close();
        this.core = null;
    }

    static {
        dimensionNamesMap.put(Dimension.overworld, "the Overworld");
        dimensionNamesMap.put(Dimension.nether, "the Nether");
        dimensionNamesMap.put(Dimension.paradise, "Paradise");
        biomeNamesMap = new HashMap<Biome, String>();
        biomeNamesMap.put(Biomes.OVERWORLD_RAINFOREST, "a rainforest");
        biomeNamesMap.put(Biomes.OVERWORLD_SWAMPLAND, "the swamplands");
        biomeNamesMap.put(Biomes.OVERWORLD_SEASONAL_FOREST, "a seasonal forest");
        biomeNamesMap.put(Biomes.OVERWORLD_FOREST, "a forest");
        biomeNamesMap.put(Biomes.OVERWORLD_GRASSLANDS, "the grasslands");
        biomeNamesMap.put(Biomes.OVERWORLD_OUTBACK, "the outback");
        biomeNamesMap.put(Biomes.OVERWORLD_SHRUBLAND, "a shrubland");
        biomeNamesMap.put(Biomes.OVERWORLD_TAIGA, "a taiga");
        biomeNamesMap.put(Biomes.OVERWORLD_BOREAL_FOREST, "a boreal forest");
        biomeNamesMap.put(Biomes.OVERWORLD_DESERT, "a desert");
        biomeNamesMap.put(Biomes.OVERWORLD_PLAINS, "the plains");
        biomeNamesMap.put(Biomes.OVERWORLD_GLACIER, "a glacier");
        biomeNamesMap.put(Biomes.OVERWORLD_TUNDRA, "a tundra");
        biomeNamesMap.put(Biomes.OVERWORLD_MEADOW, "a meadow");
        biomeNamesMap.put(Biomes.NETHER_NETHER, "Hell itself");
        biomeNamesMap.put(Biomes.PARADISE_PARADISE, "the skies");
        biomeNamesMap.put(Biomes.OVERWORLD_BIRCH_FOREST, "a birch forest");
        biomeNamesMap.put(Biomes.OVERWORLD_RETRO, "a world long forgotten");
        biomeNamesMap.put(Biomes.OVERWORLD_HELL, "a ruined world");
        biomeNamesMap.put(Biomes.OVERWORLD_SWAMPLAND_MUDDY, "the swamplands");
        biomeNamesMap.put(Biomes.OVERWORLD_OUTBACK_GRASSY, "the outback");
        weatherNamesMap = new HashMap<Weather, String>();
        weatherNamesMap.put(Weather.overworldRain, "in the rain");
        weatherNamesMap.put(Weather.overworldSnow, "in the snow");
        weatherNamesMap.put(Weather.overworldStorm, "in a storm");
        weatherNamesMap.put(Weather.overworldFog, "in thick fog");
        weatherNamesMap.put(Weather.overworldWinterSnow, "in an endless snowstorm");
    }
}

