/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiRenderItem;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTooltip;
import net.minecraft.client.util.helper.GuiItemDragHandler;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.block.entity.TileEntityBlastFurnace;
import net.minecraft.core.crafting.LookupFuelFurnace;
import net.minecraft.core.crafting.LookupFuelFurnaceBlast;
import net.minecraft.core.crafting.recipe.RecipesBlastFurnace;
import net.minecraft.core.crafting.recipe.RecipesFurnace;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemArmor;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.Container;
import net.minecraft.core.player.inventory.ContainerFurnace;
import net.minecraft.core.player.inventory.ContainerPlayer;
import net.minecraft.core.player.inventory.ContainerPlayerCreative;
import net.minecraft.core.player.inventory.ContainerTrommel;
import net.minecraft.core.player.inventory.ContainerWorkbench;
import net.minecraft.core.player.inventory.InventoryPlayer;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.player.inventory.slot.SlotCrafting;
import net.minecraft.core.player.inventory.slot.SlotCreative;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public abstract class GuiContainer
extends GuiScreen {
    public int xSize;
    public int ySize;
    public Container inventorySlots;
    GuiTooltip guiTooltip;
    GuiRenderItem guiRenderItem;
    public GuiItemDragHandler itemDragHandler;

    public GuiContainer(Container container) {
        Minecraft mc = Minecraft.getMinecraft(this);
        this.xSize = 176;
        this.ySize = 166;
        this.inventorySlots = container;
        this.guiTooltip = new GuiTooltip(mc);
        this.guiRenderItem = new GuiRenderItem(mc);
        this.itemDragHandler = new GuiItemDragHandler(mc, this, this.guiRenderItem);
    }

    @Override
    public boolean doesGuiPauseGame() {
        return false;
    }

    protected abstract void drawGuiContainerBackgroundLayer(float var1);

    protected void drawGuiContainerForegroundLayer() {
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        this.drawDefaultBackground();
        int centerX = (this.width - this.xSize) / 2;
        int centerY = (this.height - this.ySize) / 2;
        this.drawGuiContainerBackgroundLayer(renderPartialTicks);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)centerX, (float)centerY, (float)0.0f);
        Slot slot = null;
        for (int i = 0; i < this.inventorySlots.inventorySlots.size(); ++i) {
            Slot slot1 = this.inventorySlots.inventorySlots.get(i);
            boolean mouseOver = this.getIsMouseOverSlot(slot1, x, y);
            if (!this.itemDragHandler.isSlotDragged(slot1)) {
                this.guiRenderItem.render(slot1.getStack(), slot1.xDisplayPosition, slot1.yDisplayPosition, mouseOver, slot1);
            }
            if (!mouseOver) continue;
            slot = slot1;
        }
        InventoryPlayer inventoryplayer = this.mc.thePlayer.inventory;
        ItemStack grabbedItem = inventoryplayer.getHeldItemStack();
        if (((Boolean)this.mc.gameSettings.enableItemDragging.value).booleanValue()) {
            this.itemDragHandler.drawScreen(x, y, renderPartialTicks);
            ItemStack grabbedItemOverride = this.itemDragHandler.getHeldItemRenderOverride();
            if (grabbedItemOverride != null) {
                grabbedItem = grabbedItemOverride;
            }
        }
        if (grabbedItem != null) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
            this.guiRenderItem.render(grabbedItem, x - centerX - 8, y - centerY - 8);
        }
        this.drawGuiContainerForegroundLayer();
        GL11.glPopMatrix();
        super.drawScreen(x, y, renderPartialTicks);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (inventoryplayer.getHeldItemStack() == null && slot != null && slot.hasStack()) {
            boolean showDescription = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
            String str = this.guiTooltip.getTooltipText(slot.getStack(), showDescription, slot);
            if (str.length() > 0) {
                this.guiTooltip.render(str, x, y, 8, -8);
            }
        }
        GL11.glEnable((int)2929);
    }

    public boolean getIsMouseOverSlot(Slot slot, int i, int j) {
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        return (i -= k) >= slot.xDisplayPosition - 1 && i < slot.xDisplayPosition + 16 + 1 && (j -= l) >= slot.yDisplayPosition - 1 && j < slot.yDisplayPosition + 16 + 1;
    }

    public Slot getSlotAtPosition(int i, int j) {
        for (int k = 0; k < this.inventorySlots.inventorySlots.size(); ++k) {
            Slot slot = this.inventorySlots.inventorySlots.get(k);
            if (!this.getIsMouseOverSlot(slot, i, j)) continue;
            return slot;
        }
        return null;
    }

    @Override
    public void initGui() {
        super.initGui();
        this.mc.thePlayer.craftingInventory = this.inventorySlots;
    }

    @Override
    public void keyTyped(char c, int i, int mouseX, int mouseY) {
        int slotId;
        if (i == 1 || this.mc.gameSettings.keyInventory.isKey(i) || i == 14) {
            this.mc.thePlayer.closeScreen();
        }
        if ((slotId = this.getSlotId(mouseX, mouseY)) >= 0) {
            if (i == this.mc.gameSettings.keyDrop.keyCode()) {
                boolean ctrl = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
                int amount = 1;
                if (ctrl) {
                    amount = 64;
                }
                this.mc.playerController.doInventoryAction(this.inventorySlots.windowId, InventoryAction.DROP, new int[]{slotId, amount}, this.mc.thePlayer);
            }
            if (c >= '1' && c <= '9') {
                int numberPressed = c - 48;
                this.mc.playerController.doInventoryAction(this.inventorySlots.windowId, InventoryAction.HOTBAR_ITEM_SWAP, new int[]{slotId, numberPressed}, this.mc.thePlayer);
            }
        }
    }

    @Override
    public void mouseClicked(int x, int y, int mouseButton) {
        super.mouseClicked(x, y, mouseButton);
        if (((Boolean)this.mc.gameSettings.enableItemDragging.value).booleanValue()) {
            this.itemDragHandler.mouseEvent(x, y, mouseButton, true);
            return;
        }
        if (mouseButton == 0 || mouseButton == 1 || mouseButton == 10) {
            this.clickInventory(x, y, mouseButton);
        }
    }

    @Override
    public void mouseMovedOrUp(int x, int y, int mouseButton) {
        if (mouseButton >= 0 && ((Boolean)this.mc.gameSettings.enableItemDragging.value).booleanValue()) {
            this.itemDragHandler.mouseEvent(x, y, mouseButton, false);
        }
        super.mouseMovedOrUp(x, y, mouseButton);
    }

    public void clickInventory(int x, int y, int mouseButton) {
        int slotId = this.getSlotId(x, y);
        if (slotId == -1) {
            return;
        }
        if (slotId == -999) {
            InventoryAction action = InventoryAction.DROP_HELD_STACK;
            if (mouseButton == 1) {
                action = InventoryAction.DROP_HELD_SINGLE;
            }
            this.mc.playerController.doInventoryAction(this.inventorySlots.windowId, action, null, this.mc.thePlayer);
            return;
        }
        if (!this.mc.thePlayer.getGamemode().consumeBlocks && mouseButton == 2) {
            this.mc.playerController.doInventoryAction(this.inventorySlots.windowId, InventoryAction.CREATIVE_GRAB, new int[]{slotId, 64}, this.mc.thePlayer);
            return;
        }
        InventoryAction action = InventoryAction.CLICK_LEFT;
        boolean shiftPressed = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        boolean ctrlPressed = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
        boolean altPressed = Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
        boolean spacePressed = Keyboard.isKeyDown((int)57);
        if (mouseButton == 10) {
            shiftPressed = true;
            mouseButton = 0;
        }
        int target = 0;
        Slot slot = this.inventorySlots.getSlot(slotId);
        ItemStack stackInSlot = slot != null ? slot.getStack() : null;
        Item itemInSlot = stackInSlot != null ? stackInSlot.getItem() : null;
        int clickedItemId = stackInSlot != null ? stackInSlot.getItem().id : 0;
        ItemStack grabbedItem = this.mc.thePlayer.inventory.getHeldItemStack();
        if (mouseButton == 1) {
            action = InventoryAction.CLICK_RIGHT;
        }
        if (slot instanceof SlotCrafting) {
            if (((Boolean)this.mc.gameSettings.swapCraftingButtons.value).booleanValue()) {
                if (shiftPressed && ctrlPressed) {
                    action = InventoryAction.MOVE_SIMILAR;
                } else if (shiftPressed) {
                    action = InventoryAction.MOVE_SINGLE_ITEM;
                } else if (ctrlPressed) {
                    action = InventoryAction.MOVE_STACK;
                }
            } else if (shiftPressed && ctrlPressed) {
                action = InventoryAction.MOVE_SIMILAR;
            } else if (shiftPressed) {
                action = InventoryAction.MOVE_STACK;
            } else if (ctrlPressed) {
                action = InventoryAction.MOVE_SINGLE_ITEM;
            }
        } else if (spacePressed) {
            action = InventoryAction.MOVE_ALL;
        } else if (shiftPressed && ctrlPressed) {
            action = InventoryAction.MOVE_SIMILAR;
        } else if (shiftPressed || altPressed) {
            action = InventoryAction.MOVE_STACK;
        } else if (ctrlPressed) {
            action = InventoryAction.MOVE_SINGLE_ITEM;
        }
        if (slot instanceof SlotCreative) {
            ItemStack heldItem = this.mc.thePlayer.inventory.getHeldItemStack();
            if (heldItem != null) {
                if (heldItem.canStackWith(stackInSlot)) {
                    if (shiftPressed || ctrlPressed) {
                        this.mc.playerController.doInventoryAction(this.inventorySlots.windowId, InventoryAction.CREATIVE_GRAB, new int[]{slot.id, heldItem.getMaxStackSize()}, this.mc.thePlayer);
                    } else {
                        this.mc.playerController.doInventoryAction(this.inventorySlots.windowId, InventoryAction.CREATIVE_GRAB, new int[]{slot.id, heldItem.stackSize + 1}, this.mc.thePlayer);
                    }
                } else {
                    this.mc.playerController.doInventoryAction(this.inventorySlots.windowId, InventoryAction.CREATIVE_GRAB, new int[]{slot.id, 0}, this.mc.thePlayer);
                }
            } else if (shiftPressed || ctrlPressed) {
                int amount = 1;
                if (shiftPressed && stackInSlot != null) {
                    amount = stackInSlot.getMaxStackSize();
                }
                this.mc.playerController.doInventoryAction(this.inventorySlots.windowId, InventoryAction.CREATIVE_MOVE, new int[]{slot.id, amount}, this.mc.thePlayer);
            } else {
                this.mc.playerController.doInventoryAction(this.inventorySlots.windowId, InventoryAction.CREATIVE_GRAB, new int[]{slot.id, 1}, this.mc.thePlayer);
            }
            return;
        }
        if (this.inventorySlots instanceof ContainerPlayer && itemInSlot instanceof ItemArmor) {
            target = 2;
        }
        if (this.inventorySlots instanceof ContainerFurnace) {
            boolean isFuel;
            boolean isIngredient;
            ContainerFurnace furnace = (ContainerFurnace)this.inventorySlots;
            boolean isBlastFurnace = furnace.tileEntity instanceof TileEntityBlastFurnace;
            if (isBlastFurnace) {
                isIngredient = RecipesBlastFurnace.smelting().getSmeltingResult(clickedItemId) != null;
                isFuel = LookupFuelFurnaceBlast.instance.getFuelYield(clickedItemId) > 0;
            } else {
                isIngredient = RecipesFurnace.smelting().getSmeltingResult(clickedItemId) != null;
                boolean bl = isFuel = LookupFuelFurnace.instance.getFuelYield(clickedItemId) > 0;
            }
            if (isIngredient) {
                target = 1;
            } else if (isFuel) {
                target = 2;
            }
        }
        if (this.inventorySlots instanceof ContainerTrommel) {
            target = LookupFuelFurnace.instance.getFuelYield(clickedItemId) > 0 ? 2 : 1;
        }
        if ((this.inventorySlots instanceof ContainerWorkbench || this.inventorySlots instanceof ContainerPlayer) && altPressed) {
            target = 1;
        }
        if (this.inventorySlots instanceof ContainerPlayerCreative && altPressed) {
            this.mc.playerController.doInventoryAction(this.inventorySlots.windowId, InventoryAction.CREATIVE_DELETE, new int[]{slot.id}, this.mc.thePlayer);
            return;
        }
        if (slot != null && itemInSlot != null && itemInSlot instanceof ItemArmor && mouseButton == 1 && shiftPressed) {
            this.mc.playerController.doInventoryAction(this.inventorySlots.windowId, InventoryAction.EQUIP_ARMOR, new int[]{slot.id}, this.mc.thePlayer);
            return;
        }
        if (slot != null && slot.allowItemInteraction() && grabbedItem != null && grabbedItem.getItem().hasInventoryInteraction() && mouseButton == 1) {
            this.mc.playerController.doInventoryAction(this.inventorySlots.windowId, InventoryAction.INTERACT_GRABBED, new int[]{slot.id}, this.mc.thePlayer);
            return;
        }
        if (slot != null && stackInSlot != null && slot.allowItemInteraction() && stackInSlot.getItem().hasInventoryInteraction() && mouseButton == 1) {
            this.mc.playerController.doInventoryAction(this.inventorySlots.windowId, InventoryAction.INTERACT_SLOT, new int[]{slot.id}, this.mc.thePlayer);
            return;
        }
        int[] args = new int[]{slotId, target};
        this.mc.playerController.doInventoryAction(this.inventorySlots.windowId, action, args, this.mc.thePlayer);
    }

    private int getSlotId(int x, int y) {
        Slot slot = this.getSlotAtPosition(x, y);
        int x2 = (this.width - this.xSize) / 2;
        int y2 = (this.height - this.ySize) / 2;
        boolean flag = x < x2 || y < y2 || x >= x2 + this.xSize || y >= y2 + this.ySize;
        int slotId = -1;
        if (slot != null) {
            slotId = slot.id;
        }
        if (flag) {
            slotId = -999;
        }
        return slotId;
    }

    @Override
    public void onGuiClosed() {
        if (this.mc.thePlayer == null) {
            return;
        }
        this.mc.playerController.func_20086_a(this.inventorySlots.windowId, this.mc.thePlayer);
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (!this.mc.thePlayer.isAlive() || this.mc.thePlayer.removed) {
            this.mc.thePlayer.closeScreen();
        }
    }
}

