/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.option.Option;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Colors;
import net.minecraft.core.util.helper.Time;
import org.lwjgl.opengl.GL11;

public class GuiHeldItemTooltip
extends Gui {
    private Minecraft mc;
    private int lastItemID;
    private int lastSelectedItem;
    private String string;
    private int color;
    private double time = 0.0;
    private final double displayTime = 2.5;
    private final double fadeTime = 0.5;

    public void updateAndRender(Minecraft mc, int width, int height, int sp) {
        this.mc = mc;
        ItemStack item = mc.thePlayer.getCurrentEquippedItem();
        int id = this.getItemID(item);
        int i = mc.thePlayer.inventory.currentItem;
        if (id != this.lastItemID || i != this.lastSelectedItem) {
            this.updateString(item);
            this.time = 2.5;
            this.lastItemID = id;
            this.lastSelectedItem = i;
        }
        this.render(mc, width, height, sp);
    }

    private void updateString(ItemStack item) {
        if (item == null) {
            this.string = null;
            return;
        }
        this.string = item.getDisplayName();
        this.color = Colors.allChatColors[item.getDisplayColor()].getARGB();
    }

    public void setOptionNameAndValueString(Option<?> option) {
        this.setString(option.getDisplayStringName() + ": " + this.mc.gameSettings.getDisplayString(option));
    }

    public void setString(String string) {
        this.setString(string, 0xFFFFFF);
    }

    public void setString(String string, int color) {
        this.string = string;
        this.color = color;
        this.time = 2.5;
    }

    public void render(Minecraft mc, int width, int height, int sp) {
        int a;
        if (this.string == null) {
            return;
        }
        if (this.time < 0.0) {
            return;
        }
        double alpha = this.time < 0.5 ? this.time / 0.5 : 1.0;
        if (!mc.isGamePaused) {
            this.time -= Time.delta;
        }
        if ((a = (int)(alpha * 255.0)) < 1) {
            return;
        }
        int rgb = this.color & 0xFFFFFF | a << 24;
        if (a < 255) {
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3008);
            GL11.glBlendFunc((int)770, (int)771);
        }
        mc.fontRenderer.drawStringWithShadow(this.string, (width - mc.fontRenderer.getStringWidth(this.string)) / 2, height - 50 - sp, rgb);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
    }

    private int getItemID(ItemStack stack) {
        if (stack == null) {
            return -1;
        }
        return stack.getItem().id;
    }
}

