/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.EntityClientPlayerMP;
import net.minecraft.client.entity.player.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiHeldItemTooltip;
import net.minecraft.client.gui.GuiPhotoMode;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.Tessellator;
import net.minecraft.client.render.dynamictexture.DynamicTexture;
import net.minecraft.client.render.entity.ItemEntityRenderer;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemBucketIceCream;
import net.minecraft.core.item.ItemFood;
import net.minecraft.core.item.ItemMap;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.ChatLine;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.inventory.InventoryPlayer;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Utils;
import net.minecraft.core.world.saveddata.maps.ItemMapSavedData;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.weather.Weather;
import org.lwjgl.opengl.GL11;

public class GuiIngame
extends Gui {
    public static final String[] directions = new String[]{"North", "East", "South", "West"};
    private static ItemEntityRenderer itemRenderer = new ItemEntityRenderer();
    private List<ChatLine> chatMessageList = new ArrayList<ChatLine>();
    private Random rand = new Random();
    protected Minecraft mc;
    public String field_933_a;
    protected int updateCounter = 0;
    private String recordPlaying = "";
    private int recordPlayingUpFor = 0;
    private boolean field_22065_l = false;
    public float damageGuiPartialTime;
    float prevVignetteBrightness = 1.0f;
    protected FontRenderer fontrenderer;
    public int chatScroll = 0;
    public final GuiHeldItemTooltip guiHeldItemTooltip = new GuiHeldItemTooltip();
    private int debugLine = 0;
    private int debugLineRight = 0;
    private int debugOffset = 0;
    private int debugOffsetRight = 0;
    private int debugLineHeight = 10;
    private List<String> playerListScoreStrings = new ArrayList<String>();

    public GuiIngame(Minecraft minecraft) {
        this.mc = minecraft;
        this.fontrenderer = this.mc.fontRenderer;
    }

    public void renderGameOverlay(float partialTicks, boolean flag, int mouseX, int mouseY) {
        ItemStack heldItemStack;
        int l;
        int y;
        float portalIntensity;
        if (this.mc.currentScreen instanceof GuiPhotoMode) {
            return;
        }
        I18n stringtranslate = I18n.getInstance();
        int width = this.mc.resolution.scaledWidth;
        int height = this.mc.resolution.scaledHeight;
        int sp = (int)(((Float)this.mc.gameSettings.screenPadding.value).floatValue() * (float)height / 8.0f);
        FontRenderer fontrenderer = this.mc.fontRenderer;
        this.mc.worldRenderer.setupScaledResolution();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (this.mc.gameSettings.immersiveMode.drawVignette() && ((Boolean)this.mc.gameSettings.vignette.value).booleanValue()) {
            this.renderVignette(this.mc.thePlayer.getBrightness(partialTicks), width, height);
        }
        ItemStack headSlotItem = this.mc.thePlayer.inventory.armorItemInSlot(3);
        if ((Integer)this.mc.gameSettings.thirdPersonView.value == 0 && headSlotItem != null && headSlotItem.itemID == Block.pumpkinCarvedIdle.id) {
            this.renderPumpkinBlur(width, height);
        }
        if ((portalIntensity = this.mc.thePlayer.prevTimeInPortal + (this.mc.thePlayer.timeInPortal - this.mc.thePlayer.prevTimeInPortal) * partialTicks) > 0.0f) {
            this.renderPortalOverlay(portalIntensity, width, height);
        }
        if (this.mc.gameSettings.immersiveMode.drawHotbar()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/gui.png"));
            InventoryPlayer inventoryplayer = this.mc.thePlayer.inventory;
            this.zLevel = -90.0f;
            int x = width / 2 - 91;
            y = height - 22 - sp;
            this.drawTexturedModalRect(x, y, 0, 0, 182, 22);
            int selectedHotbar = (inventoryplayer.hotbarOffset + 27) % 36 / 9;
            this.drawTexturedModalRect(x - 5, y, 24, 22, 6, 22);
            this.drawTexturedModalRect(x - 5, y + 1 + selectedHotbar * 5, 30, 23 + selectedHotbar * 5, 6, 5);
            this.drawTexturedModalRect(x - 1 + inventoryplayer.currentItem % 9 * 20, y - 1, 0, 22, 24, 22 + (sp > 0 ? 2 : 0));
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/icons.png"));
        if (this.mc.gameSettings.immersiveMode.drawCrosshair() && (Integer)this.mc.gameSettings.thirdPersonView.value == 0) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)775, (int)769);
            this.drawTexturedModalRect(width / 2 - 7, height / 2 - 7, 0, 0, 16, 16);
            GL11.glDisable((int)3042);
            this.drawRotationOverlay(width, height, sp);
        }
        if (this.mc.gameSettings.immersiveMode.drawHotbar()) {
            int y2;
            int itemIndex;
            boolean heartsFlash;
            boolean bl = heartsFlash = this.mc.thePlayer.heartsFlashTime / 3 % 2 == 1;
            if (this.mc.thePlayer.heartsFlashTime < 10) {
                heartsFlash = false;
            }
            int health = this.mc.thePlayer.health;
            int prevHealth = this.mc.thePlayer.prevHealth;
            this.rand.setSeed((long)this.updateCounter * 312871L);
            if (this.mc.playerController.shouldDrawHUD()) {
                int y3;
                int armorValue = this.mc.thePlayer.getPlayerProtectionAmount();
                for (int index = 0; index < 10; ++index) {
                    y3 = height - 32 - sp;
                    if (armorValue > 0) {
                        int x = width / 2 + 91 - index * 8 - 9;
                        if (index * 2 + 1 < armorValue) {
                            this.drawTexturedModalRect(x, y3, 34, 9, 9, 9);
                        }
                        if (index * 2 + 1 == armorValue) {
                            this.drawTexturedModalRect(x, y3, 25, 9, 9, 9);
                        }
                        if (index * 2 + 1 > armorValue) {
                            this.drawTexturedModalRect(x, y3, 16, 9, 9, 9);
                        }
                    }
                    if (this.mc.thePlayer.getGamemode().isPlayerInvulnerable) continue;
                    int heartOffset = 0;
                    if (heartsFlash) {
                        heartOffset = 1;
                    }
                    int x = width / 2 - 91 + index * 8;
                    if (health <= 4) {
                        y3 += this.rand.nextInt(2);
                    }
                    this.drawTexturedModalRect(x, y3, 16 + heartOffset * 9, 0, 9, 9);
                    if (heartsFlash) {
                        if (index * 2 + 1 < prevHealth) {
                            this.drawTexturedModalRect(x, y3, 70, 0, 9, 9);
                        }
                        if (index * 2 + 1 == prevHealth) {
                            this.drawTexturedModalRect(x, y3, 79, 0, 9, 9);
                        }
                    }
                    if (index * 2 + 1 < health) {
                        this.drawTexturedModalRect(x, y3, 52, 0, 9, 9);
                    }
                    if (index * 2 + 1 == health) {
                        this.drawTexturedModalRect(x, y3, 61, 0, 9, 9);
                    }
                    if (this.mc.thePlayer.inventory.getCurrentItem() == null || !(this.mc.thePlayer.inventory.getCurrentItem().getItem() instanceof ItemFood) && !(this.mc.thePlayer.inventory.getCurrentItem().getItem() instanceof ItemBucketIceCream) || !((Boolean)this.mc.gameSettings.foodHealthRegenOverlay.value).booleanValue()) continue;
                    int healing = 0;
                    healing = this.mc.thePlayer.inventory.getCurrentItem().getItem() instanceof ItemFood ? ((ItemFood)this.mc.thePlayer.inventory.getCurrentItem().getItem()).getHealAmount() : ((ItemBucketIceCream)this.mc.thePlayer.inventory.getCurrentItem().getItem()).getHealAmount();
                    if (index * 2 + 1 < health) continue;
                    if (index * 2 + 1 == health) {
                        this.drawTexturedModalRect(x, y3, 106, 0, 9, 9);
                        continue;
                    }
                    if (index * 2 + 1 < health + healing) {
                        this.drawTexturedModalRect(x, y3, 88, 0, 9, 9);
                        continue;
                    }
                    if (index * 2 + 1 != health + healing) continue;
                    this.drawTexturedModalRect(x, y3, 97, 0, 9, 9);
                }
                if (this.mc.thePlayer.isUnderLiquid(Material.water) && !this.mc.thePlayer.getGamemode().isPlayerInvulnerable) {
                    int k2 = (int)Math.ceil((double)(this.mc.thePlayer.airSupply - 2) * 10.0 / 300.0);
                    int l3 = (int)Math.ceil((double)this.mc.thePlayer.airSupply * 10.0 / 300.0) - k2;
                    for (int l5 = 0; l5 < k2 + l3; ++l5) {
                        if (l5 < k2) {
                            this.drawTexturedModalRect(width / 2 - 91 + l5 * 8, height - 32 - 9 - sp, 16, 18, 9, 9);
                            continue;
                        }
                        this.drawTexturedModalRect(width / 2 - 91 + l5 * 8, height - 32 - 9 - sp, 25, 18, 9, 9);
                    }
                }
                if (this.mc.thePlayer.remainingFireTicks > 0) {
                    int x = width / 2 - 91;
                    y3 = height - 42 - sp;
                    float fire = (float)this.mc.thePlayer.remainingFireTicks / (float)this.mc.thePlayer.maxFireTicks;
                    int fireBar = (int)(fire * 20.0f);
                    for (int k = 0; k < fireBar / 2; ++k) {
                        this.drawTexturedModalRect(x + 8 * k, y3, 16, 27, 9, 9);
                    }
                    if (fireBar % 2 == 1) {
                        this.drawTexturedModalRect(x + 8 * (fireBar / 2), y3, 25, 27, 9, 9);
                    }
                }
            }
            GL11.glEnable((int)2929);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)32826);
            Lighting.enableInventoryLight();
            int lastHotbarStart = (this.mc.thePlayer.inventory.hotbarOffset + 27) % 36;
            int nextHotbarStart = (this.mc.thePlayer.inventory.hotbarOffset + 9) % 36;
            if (this.mc.hotbarSwapAnimationProgress > 0.0f) {
                GL11.glEnable((int)3089);
                GL11.glScissor((int)((width / 2 - 90 + 2) * this.mc.resolution.scale), (int)((3 + sp) * this.mc.resolution.scale), (int)(182 * this.mc.resolution.scale), (int)(16 * this.mc.resolution.scale));
                this.mc.hotbarSwapAnimationProgress -= partialTicks * this.mc.hotbarSwapAnimationProgress * 2.0f / 16.0f;
                for (itemIndex = 0; itemIndex < 9; ++itemIndex) {
                    int x = width / 2 - 90 + itemIndex * 20 + 2;
                    y2 = height - 16 - 3 - 22 + (int)(22.0f * this.mc.hotbarSwapAnimationProgress);
                    this.renderInventorySlot(itemIndex + lastHotbarStart, x, y2 - sp, partialTicks, 1.0f);
                }
                if (this.mc.hotbarSwapAnimationProgress < 0.05f) {
                    this.mc.hotbarSwapAnimationProgress = 0.0f;
                }
            } else if (this.mc.hotbarSwapAnimationProgress < 0.0f) {
                GL11.glEnable((int)3089);
                GL11.glScissor((int)((width / 2 - 90 + 2) * this.mc.resolution.scale), (int)((3 + sp) * this.mc.resolution.scale), (int)(182 * this.mc.resolution.scale), (int)(16 * this.mc.resolution.scale));
                Minecraft itemIndex2 = this.mc;
                itemIndex2.hotbarSwapAnimationProgress = itemIndex2.hotbarSwapAnimationProgress + partialTicks * -this.mc.hotbarSwapAnimationProgress * 2.0f / 16.0f;
                for (itemIndex = 0; itemIndex < 9; ++itemIndex) {
                    int x = width / 2 - 90 + itemIndex * 20 + 2;
                    y2 = height - 16 - 3 + 22 + (int)(22.0f * this.mc.hotbarSwapAnimationProgress);
                    this.renderInventorySlot(itemIndex + nextHotbarStart, x, y2 - sp, partialTicks, 1.0f);
                }
                if (this.mc.hotbarSwapAnimationProgress > -0.05f) {
                    this.mc.hotbarSwapAnimationProgress = 0.0f;
                }
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (itemIndex = 0; itemIndex < 9; ++itemIndex) {
                int x = width / 2 - 90 + itemIndex * 20 + 2;
                y2 = height - 16 - 3 + (int)(22.0f * this.mc.hotbarSwapAnimationProgress);
                this.renderInventorySlot(itemIndex + this.mc.thePlayer.inventory.hotbarOffset, x, y2 - sp, partialTicks, 1.0f);
            }
            GL11.glDisable((int)3089);
        }
        Lighting.disable();
        GL11.glDisable((int)32826);
        if (this.mc.thePlayer.getSleepTimer() > 0) {
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3008);
            int i2 = this.mc.thePlayer.getSleepTimer();
            float f3 = (float)i2 / 100.0f;
            if (f3 > 1.0f) {
                f3 = 1.0f - (float)(i2 - 100) / 10.0f;
            }
            int j4 = (int)(220.0f * f3) << 24 | 0x101020;
            this.drawRect(0, 0, width, height, j4);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)2929);
        }
        if (this.mc.gameSettings.immersiveMode.drawOverlays()) {
            this.drawRecordPlayingOverlay(width, height, partialTicks);
            int tsp = 2 + sp;
            int line = 0;
            int lineHeight = 10;
            boolean clock = false;
            boolean compass = false;
            boolean rotaryCalendar = false;
            if (this.mc.thePlayer.getGamemode() == Gamemode.creative) {
                clock = true;
                compass = true;
                rotaryCalendar = true;
            } else {
                for (int iinv = 0; iinv < this.mc.thePlayer.inventory.getSizeInventory(); ++iinv) {
                    ItemStack item = this.mc.thePlayer.inventory.getStackInSlot(iinv);
                    if (item == null) continue;
                    if (item.itemID == Item.toolClock.id) {
                        clock = true;
                    }
                    if (item.itemID == Item.toolCompass.id) {
                        compass = true;
                    }
                    if (item.itemID != Item.toolCalendar.id) continue;
                    rotaryCalendar = true;
                }
            }
            if (!((Boolean)this.mc.gameSettings.showDebugScreen.value).booleanValue()) {
                this.drawPlayerList(width, height, sp);
            }
            if (((Boolean)this.mc.gameSettings.showDebugScreen.value).booleanValue()) {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                this.debugLine = 0;
                this.debugLineRight = 0;
                this.debugOffset = 0;
                this.debugOffsetRight = 0;
                long memMax = Runtime.getRuntime().maxMemory();
                long memTotal = Runtime.getRuntime().totalMemory();
                long memFree = Runtime.getRuntime().freeMemory();
                long memUsed = memTotal - memFree;
                int space = 6;
                this.drawDebugScreenLineRight("Used memory: " + memUsed * 100L / memMax + "% (" + memUsed / 1024L / 1024L + "MB) of " + memMax / 1024L / 1024L + "MB");
                this.drawDebugScreenLineRight("Allocated memory: " + memTotal * 100L / memMax + "% (" + memTotal / 1024L / 1024L + "MB)");
                this.drawDebugScreenLineRight("JRE: " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
                this.debugOffsetRight += space;
                this.drawDebugScreenLineRight(GL11.glGetString((int)7936));
                this.drawDebugScreenLineRight(GL11.glGetString((int)7937));
                this.drawDebugScreenLineRight(GL11.glGetString((int)7938));
                this.drawDebugScreenLineRight("Resolution: " + this.mc.resolution.width + "x" + this.mc.resolution.height);
                this.drawDebugScreenLineRight("Render Resolution: " + this.mc.render.renderWidth + "x" + this.mc.render.renderHeight);
                this.drawDebugScreenLine("Better than Adventure! " + Minecraft.VERSION);
                this.drawDebugScreenLine(this.mc.debug);
                this.drawDebugScreenLine(this.mc.getRendererDebugInfo());
                this.drawDebugScreenLine(this.mc.getEntityDebugInfoString());
                this.drawDebugScreenLine(this.mc.getEntityCountsInfoString());
                this.drawDebugScreenLine(this.mc.getChunkProviderInfoString());
                this.debugOffset += space;
                this.debugOffsetRight += space;
                if (compass) {
                    this.drawDebugScreenLine("X: " + this.mc.thePlayer.x);
                    this.drawDebugScreenLine("Y: " + this.mc.thePlayer.y);
                    this.drawDebugScreenLine("Z: " + this.mc.thePlayer.z);
                    int yaw = DynamicTexture.pmod(Math.round(this.mc.thePlayer.yRot), 360);
                    int pitch = Math.round(this.mc.thePlayer.xRot);
                    this.drawDebugScreenLine("Facing: " + yaw + "\u00b0, " + pitch + "\u00b0 (" + GuiIngame.getFacingDirection(this.mc.thePlayer) + ")");
                } else {
                    this.drawDebugScreenLine("Hold a compass for more information");
                }
                if (clock) {
                    if (!compass) {
                        this.debugOffset += space;
                    }
                    int playerX = MathHelper.floor_double(this.mc.thePlayer.x);
                    int playerY = MathHelper.floor_double(this.mc.thePlayer.y);
                    int playerZ = MathHelper.floor_double(this.mc.thePlayer.z);
                    this.drawDebugScreenLine("Light: Sky: " + this.mc.theWorld.getSavedLightValue(LightLayer.Sky, playerX, playerY, playerZ) + " Block: " + this.mc.theWorld.getSavedLightValue(LightLayer.Block, playerX, playerY, playerZ));
                }
                this.debugOffset += space;
                if (clock) {
                    this.drawDebugScreenLine("Time: " + this.getTimeString() + " (Day " + this.mc.theWorld.getWorldTime() / (long)Global.DAY_LENGTH_TICKS + ")");
                } else {
                    this.drawDebugScreenLine("Hold a clock for more information");
                }
                this.debugOffset += space;
                if (rotaryCalendar) {
                    Season season = this.mc.theWorld.seasonManager.getCurrentSeason();
                    String seasonString = season != null ? season.getTranslatedName() : "None";
                    Weather weather = this.mc.theWorld.getCurrentWeather();
                    String weatherString = weather != null ? weather.getTranslatedName() : "None";
                    this.drawDebugScreenLine("Season: " + seasonString);
                    this.drawDebugScreenLine("Weather: " + weatherString + " (" + this.mc.theWorld.weatherDuration / 20L + "s I: " + Utils.percentRound(this.mc.theWorld.weatherIntensity) + "% P: " + Utils.percentRound(this.mc.theWorld.weatherPower) + "%)");
                    this.drawDebugScreenLine("Biome: " + Registries.BIOMES.getKey(this.mc.theWorld.getBlockBiome((int)this.mc.thePlayer.x, (int)this.mc.thePlayer.y, (int)this.mc.thePlayer.z)));
                } else {
                    this.drawDebugScreenLine("Hold a rotary calendar for more information");
                }
                this.debugOffset += space;
                this.drawDebugScreenLine("Seed: " + this.mc.theWorld.getRandomSeed());
                this.debugOffset += space;
                this.drawDebugScreenLine("CTRL + F3: Show Frametimes");
                this.drawDebugScreenLine("F3 + Q: Show Keyboard Shortcuts");
                if (this.mc.objectMouseOver != null && this.mc.objectMouseOver.entity == null) {
                    this.debugOffset += space;
                    Block block = Block.blocksList[this.mc.theWorld.getBlockId(this.mc.objectMouseOver.x, this.mc.objectMouseOver.y, this.mc.objectMouseOver.z)];
                    if (block.id > 0 && block.id < Block.blocksList.length) {
                        String name;
                        this.drawDebugScreenLineRight("Looking at:");
                        int meta = this.mc.theWorld.getBlockMetadata(this.mc.objectMouseOver.x, this.mc.objectMouseOver.y, this.mc.objectMouseOver.z);
                        try {
                            name = stringtranslate.translateKey(Item.itemsList[block.id].getLanguageKey(new ItemStack(block, 1, meta)) + ".name");
                        }
                        catch (Exception e) {
                            name = "<ERROR>";
                        }
                        String id = block.getLanguageKey(meta) + " [" + block.id + ":" + meta + "]";
                        this.drawDebugScreenLineRight(name);
                        this.drawDebugScreenLineRight(id);
                        if (compass) {
                            this.drawDebugScreenLineRight("[" + this.mc.objectMouseOver.x + ", " + this.mc.objectMouseOver.y + ", " + this.mc.objectMouseOver.z + "]");
                        }
                        this.drawDebugScreenLineRight("Harvest: " + this.mc.thePlayer.canHarvestBlock(block));
                        if (clock) {
                            int lightX = this.mc.objectMouseOver.x;
                            int lightY = this.mc.objectMouseOver.y;
                            int lightZ = this.mc.objectMouseOver.z;
                            Side side = this.mc.objectMouseOver.side;
                            this.drawDebugScreenLineRight("Light: Sky: " + this.mc.theWorld.getSavedLightValue(LightLayer.Sky, lightX += side.getOffsetX(), lightY += side.getOffsetY(), lightZ += side.getOffsetZ()) + " Block: " + this.mc.theWorld.getSavedLightValue(LightLayer.Block, lightX, lightY, lightZ));
                        }
                        for (Tag<Block> tag : BlockTags.TAG_LIST) {
                            if (!tag.appliesTo(block)) continue;
                            this.drawDebugScreenLineRight(tag.getName());
                        }
                    }
                }
            }
            if (!((Boolean)this.mc.gameSettings.showDebugScreen.value).booleanValue()) {
                if (((Boolean)this.mc.gameSettings.fpsInOverlay.value).booleanValue()) {
                    this.drawString(fontrenderer, this.mc.debugFPS, tsp, tsp + lineHeight * line++, 0xFFFFFF);
                }
                if (compass) {
                    if (((Boolean)this.mc.gameSettings.overlayShowCoords.value).booleanValue()) {
                        if ((Integer)this.mc.gameSettings.overlayMode.value == 0) {
                            this.drawString(fontrenderer, "x: " + Utils.floor10(this.mc.thePlayer.x) + " y: " + Utils.floor10(this.mc.thePlayer.y) + " z: " + Utils.floor10(this.mc.thePlayer.z), tsp, tsp + lineHeight * line++, 0xFFFFFF);
                        }
                        if ((Integer)this.mc.gameSettings.overlayMode.value == 1) {
                            this.drawString(fontrenderer, "x: " + Utils.floor10(this.mc.thePlayer.x), tsp, tsp + lineHeight * line++, 0xFFFFFF);
                            this.drawString(fontrenderer, "y: " + Utils.floor10(this.mc.thePlayer.y), tsp, tsp + lineHeight * line++, 0xFFFFFF);
                            this.drawString(fontrenderer, "z: " + Utils.floor10(this.mc.thePlayer.z), tsp, tsp + lineHeight * line++, 0xFFFFFF);
                        }
                        if ((Integer)this.mc.gameSettings.overlayMode.value == 2) {
                            this.drawString(fontrenderer, "x: " + Utils.floor10(this.mc.thePlayer.x), tsp, tsp + lineHeight * line++, 0xFF8080);
                            this.drawString(fontrenderer, "y: " + Utils.floor10(this.mc.thePlayer.y), tsp, tsp + lineHeight * line++, 0x80FF80);
                            this.drawString(fontrenderer, "z: " + Utils.floor10(this.mc.thePlayer.z), tsp, tsp + lineHeight * line++, 0x8080FF);
                        }
                    }
                    if (((Boolean)this.mc.gameSettings.overlayShowDirection.value).booleanValue()) {
                        this.drawString(fontrenderer, GuiIngame.getFacingDirection(this.mc.thePlayer), tsp, tsp + lineHeight * line++, 0xFFFFFF);
                    }
                }
                if (clock && ((Boolean)this.mc.gameSettings.overlayShowTime.value).booleanValue()) {
                    if ((Integer)this.mc.gameSettings.overlayMode.value == 0) {
                        this.drawString(fontrenderer, this.getTimeString() + " Day " + this.mc.theWorld.getWorldTime() / (long)Global.DAY_LENGTH_TICKS, tsp, tsp + lineHeight * line++, (Integer)this.mc.gameSettings.overlayMode.value == 2 ? 0xFFFF80 : 0xFFFFFF);
                    }
                    if ((Integer)this.mc.gameSettings.overlayMode.value > 0) {
                        this.drawString(fontrenderer, this.getTimeString(), tsp, tsp + lineHeight * line++, (Integer)this.mc.gameSettings.overlayMode.value == 2 ? 0xFFFF80 : 0xFFFFFF);
                        this.drawString(fontrenderer, "Day " + this.mc.theWorld.getWorldTime() / (long)Global.DAY_LENGTH_TICKS, tsp, tsp + lineHeight * line++, (Integer)this.mc.gameSettings.overlayMode.value == 2 ? 0xFFFF80 : 0xFFFFFF);
                    }
                }
                if (rotaryCalendar) {
                    Weather weather;
                    Season season;
                    if (((Boolean)this.mc.gameSettings.overlayShowSeason.value).booleanValue() && (season = this.mc.theWorld.seasonManager.getCurrentSeason()) != null) {
                        this.drawString(fontrenderer, season.getTranslatedName(), tsp, tsp + lineHeight * line++, (Integer)this.mc.gameSettings.overlayMode.value == 2 ? 0x80FFFF : 0xFFFFFF);
                    }
                    if (((Boolean)this.mc.gameSettings.overlayShowWeather.value).booleanValue() && (weather = this.mc.theWorld.getCurrentWeather()) != null && weather != this.mc.theWorld.worldType.getDefaultWeather()) {
                        this.drawString(fontrenderer, weather.getTranslatedName(), tsp, tsp + lineHeight * line++, (Integer)this.mc.gameSettings.overlayMode.value == 2 ? 0xFF80FF : 0xFFFFFF);
                    }
                }
            }
        }
        if (this.mc.gameSettings.immersiveMode.drawOverlays() && ((Boolean)this.mc.gameSettings.armorDurabilityOverlay.value).booleanValue()) {
            for (int i = 0; i < 4; ++i) {
                ItemStack stack = this.mc.thePlayer.inventory.armorInventory[3 - i];
                if (stack == null) continue;
                int x = 2 + sp;
                int y4 = height - sp - 64 + i * 16;
                itemRenderer.renderItemIntoGUI(fontrenderer, this.mc.renderEngine, stack, x, y4, 1.0f);
                if (!stack.isItemStackDamageable()) continue;
                float durability = (float)(stack.getMaxDamage() - stack.getMetadata()) / (float)stack.getMaxDamage();
                l = (int)(durability * 255.0f);
                int i1 = 255 - l << 16 | l << 8;
                GL11.glDisable((int)3042);
                GL11.glDisable((int)2896);
                fontrenderer.drawStringWithShadow("" + (stack.getMaxDamage() - stack.getMetadata() + 1), x + 20, y4 + 4, i1);
            }
            GL11.glDisable((int)3042);
            GL11.glDisable((int)2896);
        }
        if (this.mc.gameSettings.immersiveMode.drawOverlays() && ((Boolean)this.mc.gameSettings.heldItemCountOverlay.value).booleanValue() && (heldItemStack = this.mc.thePlayer.inventory.getCurrentItem()) != null) {
            int x = width / 2 + 96;
            y = height - sp - 19;
            boolean renderItem = false;
            if (heldItemStack.isItemStackDamageable()) {
                renderItem = true;
                float durability = (float)(heldItemStack.getMaxDamage() - heldItemStack.getMetadata()) / (float)heldItemStack.getMaxDamage();
                l = (int)(durability * 255.0f);
                int i1 = 255 - l << 16 | l << 8;
                int remainingDurability = heldItemStack.getMaxDamage() - heldItemStack.getMetadata() + 1;
                fontrenderer.drawStringWithShadow("" + remainingDurability, x + 18, y + 4, i1);
            } else {
                int itemCount = 0;
                int stackCount = 0;
                for (int i = 0; i < this.mc.thePlayer.inventory.getSizeInventory(); ++i) {
                    ItemStack itemStack = this.mc.thePlayer.inventory.getStackInSlot(i);
                    if (itemStack == null || itemStack.itemID != heldItemStack.itemID || itemStack.getMetadata() != heldItemStack.getMetadata()) continue;
                    itemCount += itemStack.stackSize;
                    ++stackCount;
                }
                boolean bl = renderItem = stackCount >= 1;
                if (renderItem) {
                    fontrenderer.drawStringWithShadow("" + itemCount, x + 18, y + 4, 0xFFFFFF);
                }
            }
            if (renderItem) {
                GL11.glEnable((int)2929);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)32826);
                Lighting.enableInventoryLight();
                itemRenderer.renderItemIntoGUI(fontrenderer, this.mc.renderEngine, heldItemStack, x, y, 1.0f);
                Lighting.disable();
            }
        }
        if (this.mc.gameSettings.immersiveMode.drawChat()) {
            this.drawChat(width, height, sp);
        }
        if (((Boolean)this.mc.gameSettings.heldItemTooltips.value).booleanValue() && this.mc.gameSettings.immersiveMode.drawHotbar()) {
            this.guiHeldItemTooltip.updateAndRender(this.mc, width, height, sp);
        }
    }

    private void drawDebugScreenLine(String string, boolean right, int line, int offset) {
        int width = this.fontrenderer.getStringWidth(string);
        int height = this.debugLineHeight;
        int x = right ? this.mc.resolution.scaledWidth - width - 2 : 2;
        int y = 3 + line * this.debugLineHeight + offset;
        GL11.glDisable((int)3553);
        GL11.glColor4d((double)0.2, (double)0.2, (double)0.2, (double)0.6);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.drawRectangle(x - 1, y - 1, width + 2, height);
        tessellator.draw();
        GL11.glEnable((int)3553);
        this.fontrenderer.drawString(string, x, y, 0xFFFFFF);
    }

    private void drawDebugScreenLine(String string) {
        this.drawDebugScreenLine(string, false, this.debugLine++, this.debugOffset);
    }

    private void drawDebugScreenLineRight(String string) {
        this.drawDebugScreenLine(string, true, this.debugLineRight++, this.debugOffsetRight);
    }

    public void drawPlayerList(int screenWidth, int screenHeight, int screenPadding) {
        if (!this.mc.isMultiplayerWorld()) {
            return;
        }
        if ((Integer)this.mc.gameSettings.playerListPosition.value == 1) {
            this.mc.gameSettings.showPlayerList.value = this.mc.gameSettings.keyPlayerList.isPressed() && this.mc.currentScreen == null;
        }
        if (!((Boolean)this.mc.gameSettings.showPlayerList.value).booleanValue()) {
            return;
        }
        if (!(this.mc.thePlayer instanceof EntityClientPlayerMP)) {
            return;
        }
        EntityClientPlayerMP player = (EntityClientPlayerMP)this.mc.thePlayer;
        HashMap<String, String> players = player.sendQueue.playerList;
        int longestNameWidth = 0;
        int longestScoreWidth = 0;
        this.playerListScoreStrings.clear();
        for (Map.Entry<String, String> a1 : players.entrySet()) {
            longestNameWidth = Math.max(this.fontrenderer.getStringWidth(a1.getKey()), longestNameWidth);
            longestScoreWidth = Math.max(this.fontrenderer.getStringWidth(a1.getValue()), longestScoreWidth);
            this.playerListScoreStrings.add(a1.getValue());
        }
        int nameScoreSpace = 4;
        int lineHeight = 8;
        int outerPadding = 12;
        int innerPadding = 8;
        int columnWidth = longestNameWidth + longestScoreWidth + 4;
        int columns = (int)Math.ceil((float)players.size() / 8.0f);
        int rows = (int)Math.ceil((float)players.size() / (float)columns) + 1;
        int width = columns * columnWidth + 8 * (columns - 1) + 24;
        int height = rows * 8 + 8 * (rows - 1) + 2 + 12 - 8 + 2;
        int listX = 0;
        int listY = screenPadding;
        if ((Integer)this.mc.gameSettings.playerListPosition.value == 0) {
            listX = (screenWidth - width) / 2;
        }
        if ((Integer)this.mc.gameSettings.playerListPosition.value == 1) {
            listX = (screenWidth - width) / 2;
            listY = screenHeight / 6 + screenPadding;
        }
        if ((Integer)this.mc.gameSettings.playerListPosition.value == 2) {
            listX = screenWidth - width - screenPadding;
        }
        this.drawRect(listX, listY, listX + width, listY + height, -1475868664);
        int i = 0;
        for (Map.Entry<String, String> a2 : players.entrySet()) {
            int x = i % columns;
            int y = i / columns;
            int posX = listX + x * columnWidth + x * 8 + 12;
            int posY = listY + y * 8 + y * 8 + 12;
            int scoreStringWidth = this.fontrenderer.getStringWidth(a2.getValue());
            this.drawRect(posX - 2, posY - 2, posX + columnWidth + 2, posY + 10, -5921371);
            this.drawRect(posX - 1, posY - 1, posX + columnWidth + 1, posY + 9, -1475868664);
            this.fontrenderer.drawStringWithShadow(a2.getKey(), posX, posY, 0xFFFFFF);
            this.fontrenderer.drawStringWithShadow(TextFormatting.YELLOW + a2.getValue(), posX + columnWidth - scoreStringWidth, posY, 0xFFFFFF);
            ++i;
        }
    }

    public void drawRecordPlayingOverlay(int width, int height, float partialTicks) {
        if (this.recordPlayingUpFor > 0) {
            float f2 = (float)this.recordPlayingUpFor - partialTicks;
            int j3 = (int)(f2 * 256.0f / 20.0f);
            if (j3 > 255) {
                j3 = 255;
            }
            if (j3 > 0) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)width / 2.0f), (float)(height - 48), (float)0.0f);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                int k4 = 0xFFFFFF;
                if (this.field_22065_l) {
                    k4 = Color.HSBtoRGB(f2 / 50.0f, 0.7f, 0.6f) & 0xFFFFFF;
                }
                this.fontrenderer.drawString(this.recordPlaying, -this.fontrenderer.getStringWidth(this.recordPlaying) / 2, -4, k4 + (j3 << 24));
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
            }
        }
    }

    public void drawChat(int width, int height, int sp) {
        int messagesToShow = 10;
        boolean ignoreFadeout = false;
        if (this.mc.currentScreen instanceof GuiChat) {
            int acceptableSize = height - 48 - 48;
            messagesToShow = acceptableSize / 9;
            ignoreFadeout = true;
        }
        if (this.chatScroll > this.chatMessageList.size() - messagesToShow) {
            this.chatScroll = this.chatMessageList.size() - messagesToShow;
        }
        if (this.chatScroll < 0) {
            this.chatScroll = 0;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(height - 48), (float)0.0f);
        for (int i = this.chatScroll; i < this.chatMessageList.size() && i < this.chatScroll + messagesToShow; ++i) {
            if (this.chatMessageList.get((int)i).updateCounter >= 190 && !ignoreFadeout) continue;
            double fadeAmount = (double)this.chatMessageList.get((int)i).updateCounter / 200.0;
            fadeAmount = 1.0 - fadeAmount;
            if ((fadeAmount *= 10.0) < 0.0) {
                fadeAmount = 0.0;
            }
            if (fadeAmount > 1.0) {
                fadeAmount = 1.0;
            }
            fadeAmount *= fadeAmount;
            int alpha = (int)(255.0 * fadeAmount);
            if (ignoreFadeout) {
                alpha = 255;
            }
            if (alpha <= 0) continue;
            int xPad = 2;
            int y = -(i - this.chatScroll) * 9;
            String s1 = this.chatMessageList.get((int)i).message;
            this.drawRect(xPad, y - 1 - sp, xPad + 320, y + 8 - sp, alpha / 2 << 24);
            GL11.glEnable((int)3042);
            this.mc.fontRenderer.drawStringWithShadow(s1, xPad, y - sp, 0xFFFFFF + (alpha << 24));
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    public void drawRotationOverlay(int width, int height, int sp) {
        int x = 0;
        int y = 0;
        if ((Integer)this.mc.gameSettings.rotationOverlayMode.value / 2 == 0) {
            x = width / 2 - 92 - 32;
            y = height - 20 - sp;
        }
        if ((Integer)this.mc.gameSettings.rotationOverlayMode.value / 2 == 1) {
            x = width / 2 - 7 + 16;
            y = height / 2 - 7;
        }
        int u = (Integer)this.mc.gameSettings.rotationOverlayMode.value % 2 == 1 ? 16 : 0;
        int v = 160;
        EntityPlayerSP player = this.mc.thePlayer;
        if (player.rotationLock != null && player.rotationLock != Direction.NONE) {
            boolean facingUp = player.xRot < -45.0f;
            boolean facingDown = player.xRot > 45.0f;
            Direction dir = Direction.getDirection(player);
            if (dir.isHorizontal()) {
                dir = dir.rotate(-Direction.getHorizontalDirection((double)((double)player.yRot)).rotate((int)2).index);
                if (facingUp) {
                    if (dir == Direction.SOUTH) {
                        dir = Direction.UP;
                    }
                    if (dir == Direction.NORTH) {
                        dir = Direction.DOWN;
                    }
                }
                if (facingDown) {
                    if (dir == Direction.SOUTH) {
                        dir = Direction.DOWN;
                    }
                    if (dir == Direction.NORTH) {
                        dir = Direction.UP;
                    }
                }
            } else if (dir == Direction.UP) {
                dir = Direction.DOWN;
                if (facingUp) {
                    dir = Direction.SOUTH;
                } else if (facingDown) {
                    dir = Direction.NORTH;
                }
            } else if (dir == Direction.DOWN) {
                dir = Direction.UP;
                if (facingDown) {
                    dir = Direction.SOUTH;
                } else if (facingUp) {
                    dir = Direction.NORTH;
                }
            }
            this.drawTexturedModalRect(x, y, u, v + dir.index * 16, 16, 16);
            dir = Direction.getVerticalDirection(player);
            this.drawTexturedModalRect(x + 16, y + 4, u + (dir.index - 4) * 8, v - 8, 8, 8);
        }
    }

    public String getTimeString() {
        long worldTime = this.mc.theWorld.getWorldTime();
        int dayLength = Global.DAY_LENGTH_TICKS;
        int dayTime = (int)(worldTime % (long)dayLength);
        int hourLength = dayLength / 24;
        int hour = dayTime / hourLength;
        hour = (hour + 6) % 24;
        double hp = (double)(dayTime % hourLength) / (double)hourLength;
        int minute = (int)(hp * 60.0);
        return hour + ":" + GuiIngame.addZero(minute);
    }

    public static String addZero(int i) {
        if (i < 10) {
            return "0" + i;
        }
        return "" + i;
    }

    protected void renderPumpkinBlur(int i, int j) {
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("%blur%/misc/pumpkinblur.png"));
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(0.0, j, -90.0, 0.0, 1.0);
        tessellator.addVertexWithUV(i, j, -90.0, 1.0, 1.0);
        tessellator.addVertexWithUV(i, 0.0, -90.0, 1.0, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, -90.0, 0.0, 0.0);
        tessellator.draw();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void renderVignette(float f, int i, int j) {
        if ((f = 1.0f - f) < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.prevVignetteBrightness = (float)((double)this.prevVignetteBrightness + (double)(f - this.prevVignetteBrightness) * 0.01);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)0, (int)769);
        GL11.glColor4f((float)this.prevVignetteBrightness, (float)this.prevVignetteBrightness, (float)this.prevVignetteBrightness, (float)1.0f);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("%blur%/misc/vignette.png"));
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(0.0, j, -90.0, 0.0, 1.0);
        tessellator.addVertexWithUV(i, j, -90.0, 1.0, 1.0);
        tessellator.addVertexWithUV(i, 0.0, -90.0, 1.0, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, -90.0, 0.0, 0.0);
        tessellator.draw();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBlendFunc((int)770, (int)771);
    }

    protected void renderPortalOverlay(float f, int i, int j) {
        if (f < 1.0f) {
            f *= f;
            f *= f;
            f = f * 0.8f + 0.2f;
        }
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
        float f1 = (float)(Block.texCoordToIndex(14, 0) % Global.TEXTURE_ATLAS_WIDTH_TILES) / (float)Global.TEXTURE_ATLAS_WIDTH_TILES;
        float f2 = (float)(Block.texCoordToIndex(14, 0) / Global.TEXTURE_ATLAS_WIDTH_TILES) / (float)Global.TEXTURE_ATLAS_WIDTH_TILES;
        float f3 = (float)(Block.texCoordToIndex(14, 0) % Global.TEXTURE_ATLAS_WIDTH_TILES + 1) / (float)Global.TEXTURE_ATLAS_WIDTH_TILES;
        float f4 = (float)(Block.texCoordToIndex(14, 0) / Global.TEXTURE_ATLAS_WIDTH_TILES + 1) / (float)Global.TEXTURE_ATLAS_WIDTH_TILES;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(0.0, j, -90.0, f1, f4);
        tessellator.addVertexWithUV(i, j, -90.0, f3, f4);
        tessellator.addVertexWithUV(i, 0.0, -90.0, f3, f2);
        tessellator.addVertexWithUV(0.0, 0.0, -90.0, f1, f2);
        tessellator.draw();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderInventorySlot(int itemIndex, int x, int y, float delta, float alpha) {
        ItemStack itemstack = this.mc.thePlayer.inventory.mainInventory[itemIndex];
        if (itemstack == null) {
            return;
        }
        float animProgress = (float)itemstack.animationsToGo - delta;
        if (animProgress > 0.0f) {
            GL11.glPushMatrix();
            float f2 = 1.0f + animProgress / 5.0f;
            GL11.glTranslatef((float)(x + 8), (float)(y + 12), (float)0.0f);
            GL11.glScalef((float)(1.0f / f2), (float)((f2 + 1.0f) / 2.0f), (float)1.0f);
            GL11.glTranslatef((float)(-(x + 8)), (float)(-(y + 12)), (float)0.0f);
        }
        itemRenderer.renderItemIntoGUI(this.mc.fontRenderer, this.mc.renderEngine, itemstack, x, y, alpha);
        if (animProgress > 0.0f) {
            GL11.glPopMatrix();
        }
        itemRenderer.renderItemOverlayIntoGUI(this.mc.fontRenderer, this.mc.renderEngine, itemstack, x, y, alpha);
    }

    public void updateTick() {
        if (this.recordPlayingUpFor > 0) {
            --this.recordPlayingUpFor;
        }
        ++this.updateCounter;
        for (int i = 0; i < this.chatMessageList.size(); ++i) {
            ++this.chatMessageList.get((int)i).updateCounter;
        }
    }

    public void clearChatMessages() {
        this.chatMessageList.clear();
    }

    public void addChatMessage(String s) {
        System.out.println("[CHAT] " + s);
        while (this.mc.fontRenderer.getStringWidth(s) > 320) {
            int i;
            for (i = 1; i < s.length() && this.mc.fontRenderer.getStringWidth(s.substring(0, i + 1)) <= 320; ++i) {
            }
            this.addChatMessage(s.substring(0, i));
            s = s.substring(i);
        }
        this.chatMessageList.add(0, new ChatLine(s));
        while (this.chatMessageList.size() > 100) {
            this.chatMessageList.remove(this.chatMessageList.size() - 1);
        }
    }

    public void setRecordPlayingMessage(String s) {
        this.recordPlaying = "Now playing: " + s;
        this.recordPlayingUpFor = 60;
        this.field_22065_l = true;
    }

    public void addChatMessageTranslate(String s) {
        I18n stringtranslate = I18n.getInstance();
        String s1 = stringtranslate.translateKey(s);
        this.addChatMessage(s1);
    }

    public static String getFacingDirection(EntityPlayer player) {
        return directions[MathHelper.floor_double((double)(player.yRot * 4.0f / 360.0f) + 0.5) + 2 & 3];
    }

    public boolean isPlayerOnMap(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.getItem() instanceof ItemMap) {
            ItemMapSavedData mapData = Item.map.getOrCreateSavedData(stack, this.mc.theWorld);
            int level = (int)Math.pow(2.0, mapData.scale);
            int distance = (int)Math.max(Math.abs((double)mapData.x - this.mc.thePlayer.x), Math.abs((double)mapData.z - this.mc.thePlayer.z));
            return distance < 64 * level;
        }
        return false;
    }
}

