/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiAchievements;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiPhotoMode;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiStats;
import net.minecraft.client.gui.options.GuiOptionsPageGeneral;
import net.minecraft.client.input.InputType;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.util.helper.MathHelper;

public class GuiIngameMenu
extends GuiScreen {
    private int updateCounter2 = 0;
    private int updateCounter = 0;
    public static boolean photoModeDisabled = false;

    @Override
    public void initGui() {
        this.updateCounter2 = 0;
        this.controlList.clear();
        int byte0 = -16;
        this.controlList.add(new GuiButton(1, this.width / 2 - 100, this.height / 4 + 120 + byte0, I18n.getInstance().translateKey("menu.saveAndQuit")));
        if (this.mc.isMultiplayerWorld()) {
            ((GuiButton)this.controlList.get((int)0)).displayString = "Disconnect";
        }
        this.controlList.add(new GuiButton(4, this.width / 2 - 100, this.height / 4 + 24 + byte0, "Back to game"));
        this.controlList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 96 + byte0, 98, 20, "Options..."));
        GuiButton photoModeButton = new GuiButton(7, this.width / 2 + 2, this.height / 4 + 96 + byte0, 98, 20, "Photo Mode...");
        this.controlList.add(photoModeButton);
        if (photoModeDisabled) {
            photoModeButton.enabled = false;
        }
        this.controlList.add(new GuiButton(5, this.width / 2 - 100, this.height / 4 + 48 + byte0, 98, 20, I18n.getInstance().translateKey("gui.achievements")));
        this.controlList.add(new GuiButton(6, this.width / 2 + 2, this.height / 4 + 48 + byte0, 98, 20, I18n.getInstance().translateKey("gui.stats")));
    }

    @Override
    protected void buttonPressed(GuiButton guibutton) {
        if (guibutton.id == 0) {
            this.mc.displayGuiScreen(new GuiOptionsPageGeneral(this, this.mc.gameSettings));
        }
        if (guibutton.id == 1) {
            this.mc.statFileWriter.writeStat(StatList.leaveGameStat, 1);
            if (this.mc.isMultiplayerWorld()) {
                this.mc.theWorld.sendQuittingDisconnectingPacket();
            }
            this.mc.changeWorld1(null);
            this.mc.displayGuiScreen(new GuiMainMenu());
        }
        if (guibutton.id == 4) {
            this.mc.displayGuiScreen(null);
            this.mc.setIngameFocus();
            if (this.mc.inputType == InputType.CONTROLLER) {
                this.mc.controllerInput.buttonA.cancelButtonPress();
            }
        }
        if (guibutton.id == 5) {
            this.mc.displayGuiScreen(new GuiAchievements(this, this.mc.statFileWriter));
        }
        if (guibutton.id == 6) {
            this.mc.displayGuiScreen(new GuiStats(this, this.mc.statFileWriter));
        }
        if (guibutton.id == 7) {
            this.mc.displayGuiScreen(new GuiPhotoMode());
        }
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        ++this.updateCounter;
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        boolean flag;
        this.drawDefaultBackground();
        if (this.mc == null || this.mc.theWorld == null) {
            Minecraft.getMinecraft(this).displayGuiScreen(null);
            return;
        }
        boolean bl = flag = !this.mc.theWorld.func_650_a(this.updateCounter2++);
        if (flag || this.updateCounter < 20) {
            float f1 = ((float)(this.updateCounter % 10) + renderPartialTicks) / 10.0f;
            f1 = MathHelper.sin(f1 * 3.141593f * 2.0f) * 0.2f + 0.8f;
            int k = (int)(255.0f * f1);
            this.drawString(this.fontRenderer, "Saving...", 8, this.height - 16, k << 16 | k << 8 | k);
        }
        this.drawStringCentered(this.fontRenderer, "Game Menu", this.width / 2, 40, 0xFFFFFF);
        this.drawStringCentered(this.fontRenderer, "Score: " + TextFormatting.YELLOW + this.mc.thePlayer.getScore(), this.width / 2, 56, 0xFEFEFE);
        super.drawScreen(x, y, renderPartialTicks);
    }
}

