/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.render.Renderer;
import net.minecraft.client.render.shader.PhotoModeRenderer;
import net.minecraft.client.render.shader.Shaders;
import net.minecraft.core.Global;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.ScreenShot;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiPhotoMode
extends GuiScreen {
    private GuiButton buttonRotateLeft;
    private GuiButton buttonRotateRight;
    private GuiButton buttonCenterScreen;
    private GuiSlider sliderTimeOfDay;
    private GuiButton buttonSeason;
    private GuiButton buttonTakeScreenshot;
    private GuiButton buttonExit;
    private GuiSlider sliderFog;
    private GuiSlider sliderTilt;
    private GuiButton buttonShaders;
    private GuiSlider sliderIntensity;
    private GuiButton buttonShowPlayer;
    private long originalTOD;
    private long desiredTOD = -1L;
    private long desiredDay = -1L;
    private int desiredSeason = -1;
    public boolean showPlayer = true;
    private float iRotation = 0.0f;
    private float lastIRotation = 0.0f;
    private float iRotationGoal = 0.0f;
    private float iZoom = 1.0f;
    private float lastIZoom = 1.0f;
    private float iZoomGoal = 1.0f;
    private float iTilt = 30.0f;
    private float lastITilt = 30.0f;
    private float iTiltGoal = 30.0f;
    private float iFog = 1.0f;
    private float lastIFog = 1.0f;
    private float iFogGoal = 1.0f;
    private float iPanX = 0.0f;
    private float lastIPanX = 0.0f;
    private float iPanXGoal = 0.0f;
    private float iPanY = 0.0f;
    private float lastIPanY = 0.0f;
    private float iPanYGoal = 0.0f;
    private boolean isMouseDown = false;
    private int mouseButton;
    private int mouseDownX;
    private int mouseDownY;
    private float lastEndPanX;
    private float lastEndPanY;
    private float lastEndRotation;
    public float intensityValue = 1.0f;
    boolean shouldScreenshot = false;
    private PhotoModeRenderer photoModeRenderer;
    public Renderer previousRenderer;
    private boolean showHelpText = true;
    private long lastUpdateTime = 0L;

    public GuiPhotoMode() {
        Minecraft mc = Minecraft.getMinecraft(this);
        if (Shaders.enableShaders) {
            this.photoModeRenderer = new PhotoModeRenderer(mc, this);
        }
        this.previousRenderer = mc.render;
        mc.renderGlobal.allChanged();
    }

    public float getRotation(float renderPartialTicks) {
        return this.lastIRotation + (this.iRotation - this.lastIRotation) * renderPartialTicks;
    }

    public float getZoom(float renderPartialTicks) {
        return this.lastIZoom + (this.iZoom - this.lastIZoom) * renderPartialTicks;
    }

    public float getTilt(float renderPartialTicks) {
        return this.lastITilt + (this.iTilt - this.lastITilt) * renderPartialTicks;
    }

    public float getFog(float renderPartialTicks) {
        return this.lastIFog + (this.iFog - this.lastIFog) * renderPartialTicks;
    }

    public float getPanX(float renderPartialTicks) {
        return this.lastIPanX + (this.iPanX - this.lastIPanX) * renderPartialTicks;
    }

    public float getPanY(float renderPartialTicks) {
        return this.lastIPanY + (this.iPanY - this.lastIPanY) * renderPartialTicks;
    }

    @Override
    public void initGui() {
        super.initGui();
        this.buttonExit = new GuiButton(5, 0, 0, 20, 20, "X");
        this.buttonRotateLeft = new GuiButton(0, this.width / 2 - 49 - 2 - 20, this.height - 20, 20, 20, "<");
        this.buttonRotateRight = new GuiButton(1, this.width / 2 + 49 + 2, this.height - 20, 20, 20, ">");
        this.buttonTakeScreenshot = new GuiButton(4, this.width / 2 - 49, this.height - 20, 98, 20, "Take Screenshot");
        this.buttonCenterScreen = new GuiButton(10, this.width - 120, 0, 120, 20, "Center Screen");
        this.buttonShowPlayer = new GuiButton(11, this.width - 120, 0, 120, 20, "Show Player: On");
        this.sliderTimeOfDay = new GuiSlider(2, this.width - 120, 0, 120, 20, "Time of Day: Default", 0.0f);
        this.buttonSeason = new GuiButton(3, this.width - 120, 0, 120, 20, "Season: Default");
        this.sliderFog = new GuiSlider(6, this.width - 120, 0, 120, 20, "Fog: 1.0", 1.0f);
        this.sliderTilt = new GuiSlider(7, this.width - 120, 0, 120, 20, "Tilt: Default", 0.33333334f);
        if (Shaders.enableShaders) {
            this.buttonShaders = new GuiButton(8, this.width - 120, 0, 120, 20, "Shader: None");
            this.sliderIntensity = new GuiSlider(9, this.width - 120, 0, 120, 20, "Intensity: 100%", this.intensityValue);
            if (this.photoModeRenderer.getActiveShader() == null) {
                this.sliderIntensity.enabled = false;
            }
        }
        this.controlList.add(this.buttonCenterScreen);
        this.controlList.add(this.buttonShowPlayer);
        this.controlList.add(this.sliderTilt);
        if (Shaders.enableShaders) {
            this.mc.setRenderer(this.photoModeRenderer);
        }
        if (!this.mc.theWorld.isClientSide) {
            this.controlList.add(this.sliderTimeOfDay);
            this.controlList.add(this.sliderFog);
            this.controlList.add(this.buttonSeason);
        }
        if (Shaders.enableShaders) {
            this.controlList.add(this.buttonShaders);
            this.controlList.add(this.sliderIntensity);
        }
        int i = 0;
        for (GuiButton button : this.controlList) {
            button.yPosition = i++ * 21;
        }
        this.controlList.add(this.buttonRotateLeft);
        this.controlList.add(this.buttonRotateRight);
        this.controlList.add(this.buttonTakeScreenshot);
        this.controlList.add(this.buttonExit);
        this.originalTOD = this.mc.theWorld.getWorldTime();
        if (this.desiredTOD == -1L) {
            this.desiredTOD = this.originalTOD % (long)Global.DAY_LENGTH_TICKS;
        } else {
            this.sliderTimeOfDay.sliderValue = (float)this.desiredTOD / (float)Global.DAY_LENGTH_TICKS;
        }
        if (this.desiredDay == -1L) {
            this.desiredDay = this.originalTOD / (long)Global.DAY_LENGTH_TICKS;
        }
        this.updateButtonsText();
    }

    @Override
    public void onGuiClosed() {
        this.mc.theWorld.setWorldTimeUpdateTicks(this.originalTOD);
        if (Shaders.enableShaders) {
            this.mc.setRenderer(this.previousRenderer);
        }
        this.mc.renderGlobal.allChanged();
    }

    @Override
    protected void buttonPressed(GuiButton guibutton) {
        if (guibutton == this.buttonRotateLeft) {
            this.iRotationGoal += 1.0f;
            this.iRotationGoal = (int)this.iRotationGoal;
        } else if (guibutton == this.buttonRotateRight) {
            this.iRotationGoal -= 1.0f;
            this.iRotationGoal = (int)this.iRotationGoal;
        } else if (guibutton == this.buttonSeason) {
            ++this.desiredSeason;
            if (this.desiredSeason > 3) {
                this.desiredSeason = -1;
            }
            this.desiredDay = this.desiredSeason == -1 ? this.originalTOD / (long)Global.DAY_LENGTH_TICKS : (long)Global.DAY_LENGTH_TICKS * 7L * (long)this.desiredSeason + (long)Global.DAY_LENGTH_TICKS * 3L;
            this.mc.theWorld.setWorldTimeUpdateTicks(this.desiredDay + this.desiredTOD);
            this.mc.theWorld.doSeasonUpdate();
        } else if (guibutton == this.buttonTakeScreenshot) {
            this.shouldScreenshot = true;
        } else if (guibutton == this.buttonExit) {
            this.mc.displayGuiScreen(null);
        } else if (guibutton == this.buttonShaders) {
            boolean ctrl;
            boolean bl = ctrl = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
            if (ctrl) {
                this.photoModeRenderer.first();
            } else {
                this.photoModeRenderer.next();
            }
            this.sliderIntensity.enabled = this.photoModeRenderer.getActiveShader() != null;
        } else if (guibutton == this.buttonCenterScreen) {
            this.iPanXGoal = 0.0f;
            this.iPanYGoal = 0.0f;
        } else if (guibutton == this.buttonShowPlayer) {
            this.showPlayer = !this.showPlayer;
        }
        this.updateButtonsText();
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        super.mouseClicked(x, y, button);
        if (!this.isMouseDown && this.selectedButton == null) {
            this.showHelpText = false;
            this.isMouseDown = true;
            this.mouseDownX = x;
            this.mouseDownY = y;
            this.lastEndPanX = this.iPanX;
            this.lastEndPanY = this.iPanY;
            this.lastEndRotation = this.iRotation;
            this.mouseButton = button;
        }
    }

    @Override
    public void mouseMovedOrUp(int x, int y, int mouseButton) {
        super.mouseMovedOrUp(x, y, mouseButton);
        if (this.isMouseDown && mouseButton != -1) {
            this.isMouseDown = false;
        } else if (this.isMouseDown) {
            if (this.mouseButton == 0) {
                float div = (float)Math.pow(2.0, this.iZoom) / 3.0f;
                this.iPanXGoal = this.lastEndPanX + (float)(x - this.mouseDownX) / div;
                this.iPanYGoal = this.lastEndPanY + (float)(y - this.mouseDownY) / div;
            } else {
                this.iRotationGoal = this.lastEndRotation + (float)(x - this.mouseDownX) / 128.0f;
            }
        }
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        GL11.glViewport((int)0, (int)0, (int)this.mc.resolution.width, (int)this.mc.resolution.height);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.mc.resolution.scaledWidth, (double)this.mc.resolution.scaledHeight, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        long currentTime = System.currentTimeMillis();
        if (currentTime > this.lastUpdateTime + 5L) {
            this.lastIZoom = this.iZoom;
            if (this.iZoom != this.iZoomGoal) {
                this.iZoom += (this.iZoomGoal - this.iZoom) * 0.08f;
                if (Math.abs(this.iZoom - this.iZoomGoal) < 5.0E-4f) {
                    this.iZoom = this.iZoomGoal;
                }
            }
            this.lastIRotation = this.iRotation;
            if (this.iRotation != this.iRotationGoal) {
                this.iRotation += (this.iRotationGoal - this.iRotation) * 0.08f;
                if (Math.abs(this.iRotation - this.iRotationGoal) < 5.0E-4f) {
                    this.iRotation = this.iRotationGoal;
                }
            }
            this.lastITilt = this.iTilt;
            if (this.iTilt != this.iTiltGoal) {
                this.iTilt += (this.iTiltGoal - this.iTilt) * 0.08f;
                if (Math.abs(this.iTilt - this.iTiltGoal) < 0.01f) {
                    this.iTilt = this.iTiltGoal;
                }
            }
            this.lastIFog = this.iFog;
            if (this.iFog != this.iFogGoal) {
                this.iFog += (this.iFogGoal - this.iFog) * 0.08f;
                if (Math.abs(this.iFog - this.iFogGoal) < 5.0E-5f) {
                    this.iFog = this.iFogGoal;
                }
            }
            this.lastIPanX = this.iPanX;
            if (this.iPanX != this.iPanXGoal) {
                this.iPanX += (this.iPanXGoal - this.iPanX) * 0.4f;
                if (Math.abs(this.iPanX - this.iPanXGoal) < 0.01f) {
                    this.iPanX = this.iPanXGoal;
                }
            }
            this.lastIPanY = this.iPanY;
            if (this.iPanY != this.iPanYGoal) {
                this.iPanY += (this.iPanYGoal - this.iPanY) * 0.4f;
                if (Math.abs(this.iPanY - this.iPanYGoal) < 0.01f) {
                    this.iPanY = this.iPanYGoal;
                }
            }
            this.lastUpdateTime = currentTime;
        }
        boolean bl = this.buttonCenterScreen.enabled = !(this.iPanX == 0.0f && this.iPanY == 0.0f || this.iPanXGoal == 0.0f && this.iPanYGoal == 0.0f);
        if (!this.shouldScreenshot) {
            super.drawScreen(x, y, renderPartialTicks);
        } else {
            ScreenShot.saveScreenshot(Global.accessor.getMinecraftDir(), this.mc.resolution.width, this.mc.resolution.height);
            this.shouldScreenshot = false;
        }
        this.scroll(Mouse.getDWheel());
        if (this.sliderTimeOfDay.dragging) {
            long sliderTOD = (long)(this.sliderTimeOfDay.sliderValue * (float)Global.DAY_LENGTH_TICKS);
            this.desiredTOD = this.sliderTimeOfDay.sliderValue == 0.0f ? this.originalTOD % (long)Global.DAY_LENGTH_TICKS : sliderTOD;
            this.mc.theWorld.setWorldTimeUpdateTicks(this.desiredDay + this.desiredTOD);
            this.mc.theWorld.doLightingUpdate();
            this.updateButtonsText();
        }
        if (this.sliderTilt.dragging) {
            this.iTiltGoal = (int)(this.sliderTilt.sliderValue * 90.0f);
            this.updateButtonsText();
        }
        if (this.sliderFog.dragging) {
            this.iFogGoal = (float)Math.pow(2.0, 8.0f * this.sliderFog.sliderValue - 8.0f);
            this.updateButtonsText();
        }
        if (Shaders.enableShaders && this.sliderIntensity.dragging) {
            this.intensityValue = this.sliderIntensity.sliderValue;
            this.updateButtonsText();
        }
        if (this.showHelpText) {
            this.drawStringCentered(this.fontRenderer, I18n.getInstance().translateKey("gui.photomode.help_text"), this.width / 2, this.height - 36, 0xFFFFFF);
        }
    }

    private void updateButtonsText() {
        if (this.buttonSeason != null) {
            if (this.desiredSeason == -1) {
                this.buttonSeason.displayString = "Season: Default";
            } else if (this.desiredSeason == 0) {
                this.buttonSeason.displayString = "Season: Spring";
            } else if (this.desiredSeason == 1) {
                this.buttonSeason.displayString = "Season: Summer";
            } else if (this.desiredSeason == 2) {
                this.buttonSeason.displayString = "Season: Fall";
            } else if (this.desiredSeason == 3) {
                this.buttonSeason.displayString = "Season: Winter";
            }
        }
        this.sliderTimeOfDay.displayString = this.sliderTimeOfDay.sliderValue == 0.0f ? "Time of Day: Default" : "Time of Day: " + (long)(this.sliderTimeOfDay.sliderValue * (float)Global.DAY_LENGTH_TICKS);
        this.sliderFog.displayString = "Fog Distance: " + (int)(this.sliderFog.sliderValue * 100.0f) + "%";
        this.sliderTilt.displayString = (int)(this.sliderTilt.sliderValue * 90.0f) == 30 ? "Tilt: Default" : "Tilt: " + (int)(this.sliderTilt.sliderValue * 90.0f) + " degrees";
        if (Shaders.enableShaders) {
            String activeShader = this.photoModeRenderer.getActiveShader();
            if (activeShader == null) {
                activeShader = "none";
            }
            activeShader = activeShader.substring(0, 1).toUpperCase() + activeShader.substring(1);
            this.buttonShaders.displayString = "Shader: " + activeShader;
            this.sliderIntensity.displayString = "Intensity: " + (int)(this.sliderIntensity.sliderValue * 100.0f) + "%";
        }
        this.buttonShowPlayer.displayString = "Show Player: " + (this.showPlayer ? "On" : "Off");
    }

    public void scroll(int i) {
        if (i < 0) {
            this.iZoomGoal -= 0.25f;
        } else if (i > 0) {
            this.iZoomGoal += 0.25f;
        }
    }
}

