/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.save.LevelData;
import org.lwjgl.input.Keyboard;

public class GuiRenameWorld
extends GuiScreen {
    private GuiScreen field_22112_a;
    private GuiTextField field_22114_h;
    private final String field_22113_i;

    public GuiRenameWorld(GuiScreen guiscreen, String s) {
        this.field_22112_a = guiscreen;
        this.field_22113_i = s;
    }

    @Override
    public void updateScreen() {
        this.field_22114_h.updateCursorCounter();
    }

    @Override
    public void initGui() {
        I18n stringtranslate = I18n.getInstance();
        Keyboard.enableRepeatEvents((boolean)true);
        this.controlList.clear();
        this.controlList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 96 + 12, stringtranslate.translateKey("selectWorld.renameButton")));
        this.controlList.add(new GuiButton(1, this.width / 2 - 100, this.height / 4 + 120 + 12, stringtranslate.translateKey("gui.cancel")));
        ISaveFormat saveFormat = this.mc.getSaveFormat();
        LevelData levelData = saveFormat.getLevelData(this.field_22113_i);
        String s = levelData.getWorldName();
        this.field_22114_h = new GuiTextField(this, this.fontRenderer, this.width / 2 - 100, 60, 200, 20, s, "");
        this.field_22114_h.isFocused = true;
        this.field_22114_h.setMaxStringLength(32);
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void buttonPressed(GuiButton guibutton) {
        if (!guibutton.enabled) {
            return;
        }
        if (guibutton.id == 1) {
            this.mc.displayGuiScreen(this.field_22112_a);
        } else if (guibutton.id == 0) {
            ISaveFormat isaveformat = this.mc.getSaveFormat();
            isaveformat.renameWorld(this.field_22113_i, this.field_22114_h.getText().trim());
            this.mc.displayGuiScreen(this.field_22112_a);
        }
    }

    @Override
    public void keyTyped(char c, int i, int mouseX, int mouseY) {
        this.field_22114_h.textboxKeyTyped(c, i);
        boolean bl = ((GuiButton)this.controlList.get((int)0)).enabled = this.field_22114_h.getText().trim().length() > 0;
        if (c == '\r') {
            this.buttonPressed((GuiButton)this.controlList.get(0));
        }
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        super.mouseClicked(x, y, button);
        this.field_22114_h.mouseClicked(x, y, button);
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        I18n stringtranslate = I18n.getInstance();
        this.drawDefaultBackground();
        this.drawStringCentered(this.fontRenderer, stringtranslate.translateKey("selectWorld.renameTitle"), this.width / 2, this.height / 4 - 60 + 20, 0xFFFFFF);
        this.drawString(this.fontRenderer, stringtranslate.translateKey("selectWorld.enterName"), this.width / 2 - 100, 47, 0xA0A0A0);
        this.field_22114_h.drawTextBox();
        super.drawScreen(x, y, renderPartialTicks);
    }
}

