/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

public class GuiTexturedButton
extends GuiButton {
    private final String texturePath;
    private int u;
    private int v;

    public GuiTexturedButton(int id, String texturePath, int xPosition, int yPosition, int u, int v, int width, int height) {
        super(id, xPosition, yPosition, width, height, "");
        this.texturePath = texturePath;
        this.u = u;
        this.v = v;
    }

    @Override
    public void drawButton(Minecraft minecraft, int i, int j) {
        boolean isHovered;
        if (!this.visible) {
            return;
        }
        GL11.glBindTexture((int)3553, (int)minecraft.renderEngine.getTexture(this.texturePath));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean bl = isHovered = i >= this.xPosition && j >= this.yPosition && i < this.xPosition + this.width && j < this.yPosition + this.height;
        if (!this.enabled) {
            this.drawTexturedModalRect(this.xPosition, this.yPosition, this.u, this.v, this.width, this.height);
        } else if (!isHovered) {
            this.drawTexturedModalRect(this.xPosition, this.yPosition, this.u, this.v + this.height, this.width, this.height);
        } else {
            this.drawTexturedModalRect(this.xPosition, this.yPosition, this.u, this.v + this.height * 2, this.width, this.height);
        }
        this.mouseDragged(minecraft, i, j);
    }
}

