/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options;

import java.util.ListIterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.Tessellator;
import net.minecraft.core.lang.Language;
import org.lwjgl.opengl.GL11;

public class GuiButtonLanguage
extends GuiButton {
    private final Language language;
    public boolean isSelected = false;

    public GuiButtonLanguage(int id, int xPosition, int yPosition, int width, int height, Language language) {
        super(id, xPosition, yPosition, width, height, "");
        this.language = language;
    }

    public Language getLanguage() {
        return this.language;
    }

    @Override
    public void drawButton(Minecraft minecraft, int i, int j) {
        FontRenderer textRenderer = Minecraft.getMinecraft((Object)this).fontRenderer;
        Tessellator tessellator = Tessellator.instance;
        if (this.isSelected) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3553);
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(2139127936);
            tessellator.addVertexWithUV(this.xPosition - 2, this.yPosition + this.height + 2, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(this.xPosition + this.width + 2, this.yPosition + this.height + 2, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(this.xPosition + this.width + 2, this.yPosition - 2, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(this.xPosition - 2, this.yPosition - 2, 0.0, 0.0, 0.0);
            tessellator.setColorOpaque_I(0);
            tessellator.addVertexWithUV(this.xPosition - 1, this.yPosition + this.height + 1, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(this.xPosition + this.width + 1, this.yPosition + this.height + 1, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(this.xPosition + this.width + 1, this.yPosition - 1, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(this.xPosition - 1, this.yPosition - 1, 0.0, 0.0, 0.0);
            tessellator.draw();
            GL11.glEnable((int)3553);
        }
        StringBuilder sb = new StringBuilder();
        String name = this.language.getName();
        String region = this.language.getRegion();
        if (name != null) {
            sb.append(name);
        } else {
            sb.append("Unknown Language");
        }
        if (region != null) {
            sb.append(" (").append(region).append(")");
        }
        String fullName = sb.toString();
        StringBuilder csb = new StringBuilder();
        ListIterator<String> creditsList = this.language.getCredits().listIterator();
        while (creditsList.hasNext()) {
            csb.append((String)creditsList.next());
            if (!creditsList.hasNext()) continue;
            csb.append(", ");
        }
        String credits = csb.toString();
        this.drawStringCentered(textRenderer, fullName, this.xPosition + this.width / 2, this.yPosition + 1, 0xFFFFFF);
        this.drawStringCentered(textRenderer, credits.isEmpty() ? "Unknown Credits" : credits, this.xPosition + this.width / 2, this.yPosition + 12, 0x808080);
    }
}

