/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.options.GuiButtonLanguage;
import net.minecraft.client.gui.options.GuiOptionsPageBase;
import net.minecraft.client.option.GameSettings;
import net.minecraft.core.Global;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.lang.Language;
import net.minecraft.core.lang.LanguageSeeker;
import org.lwjgl.Sys;

public class GuiOptionsPageLanguages
extends GuiOptionsPageBase {
    private final List<GuiButtonLanguage> availableLanguages = new ArrayList<GuiButtonLanguage>();
    private int mouseX;
    private int mouseY;
    GuiButton btnOpenFolder = null;
    String fileLocation = "";
    WatchService fileWatcher = null;

    public GuiOptionsPageLanguages(GuiScreen parent, GameSettings settings) {
        super(parent, settings);
    }

    @Override
    public void initGui() {
        this.controlList.clear();
        this.availableLanguages.clear();
        super.initGui();
        int i = 0;
        try {
            for (Language lang : LanguageSeeker.getAvailableLanguages()) {
                this.availableLanguages.add(new GuiButtonLanguage(5000 + i, 0, 0, 0, 0, lang));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        I18n trans = I18n.getInstance();
        this.btnOpenFolder = new GuiButton(1, this.width / 2 - 100, this.top + 4, 200, 20, trans.translateKey("options.button.openFolder"));
        this.controlList.add(this.btnOpenFolder);
        this.fileLocation = new File(Global.accessor.getMinecraftDir(), "languages").getAbsolutePath();
        if (this.fileWatcher == null) {
            try {
                this.fileWatcher = FileSystems.getDefault().newWatchService();
                Path dirPath = new File(this.fileLocation).toPath();
                dirPath.register(this.fileWatcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.fileWatcher != null) {
            this.fileWatcher.close();
        }
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        ArrayList btns = new ArrayList(this.controlList);
        this.controlList.addAll(this.availableLanguages);
        super.mouseClicked(x, y, button);
        this.controlList.clear();
        this.controlList.addAll(btns);
    }

    @Override
    protected void buttonPressed(GuiButton button) {
        if (button == this.btnOpenFolder) {
            Sys.openURL((String)("file://" + this.fileLocation));
        } else {
            int index;
            super.buttonPressed(button);
            for (index = 0; index < this.availableLanguages.size() && button != this.availableLanguages.get(index); ++index) {
            }
            if (index >= this.availableLanguages.size()) {
                return;
            }
            String lang = this.availableLanguages.get(index).getLanguage().getId();
            this.mc.gameSettings.language.set(lang);
            I18n.getInstance().reload(lang, true);
            this.initGui();
        }
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        super.drawScreen(x, y, renderPartialTicks);
        this.mouseX = x;
        this.mouseY = y;
        WatchKey key = this.fileWatcher.poll();
        if (key != null) {
            key.pollEvents();
            key.reset();
            this.initGui();
        }
    }

    @Override
    protected void drawPageItems(int x, int y, int width) {
        this.btnOpenFolder.yPosition = y + 4;
        int previousHeights = y + 4 + 20 + 6;
        for (int i = 0; i < this.availableLanguages.size(); ++i) {
            GuiButtonLanguage button = this.availableLanguages.get(i);
            button.isSelected = ((String)this.mc.gameSettings.language.value).equals(this.availableLanguages.get(i).getLanguage().getId());
            button.width = width;
            button.height = 32;
            button.xPosition = x + width - button.width;
            button.yPosition = previousHeights;
            button.visible = true;
            button.drawButton(this.mc, this.mouseX, this.mouseY);
            previousHeights += button.height + 3;
        }
    }

    @Override
    protected int getTotalPageHeight() {
        return 3 + 35 * this.availableLanguages.size();
    }

    public List<Language> getAvailableLanguages() {
        ArrayList<Language> ret = new ArrayList<Language>();
        for (GuiButtonLanguage btn : this.availableLanguages) {
            ret.add(btn.getLanguage());
        }
        return ret;
    }
}

