/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.gui.GuiSliderInteger;
import net.minecraft.client.gui.GuiToggleButton;
import net.minecraft.client.gui.options.GuiOptionsPageBase;
import net.minecraft.client.option.FloatOption;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.IntegerOption;
import net.minecraft.client.option.Option;
import net.minecraft.client.option.ToggleableOption;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.core.lang.I18n;

public abstract class GuiOptionsPageOptionBase
extends GuiOptionsPageBase {
    int padding = 2;
    List<String> categoryKeys = new ArrayList<String>();
    List<Option<?>[]> options = new ArrayList<Option<?>[]>();
    List<GuiButton[]> buttons = new ArrayList<GuiButton[]>();
    int mouseX;
    int mouseY;
    protected int yOffset = 0;

    public GuiOptionsPageOptionBase(GuiScreen parent, GameSettings settings) {
        super(parent, settings);
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        super.drawScreen(x, y, renderPartialTicks);
        this.mouseX = x;
        this.mouseY = y;
        for (int i = 0; i < this.buttons.size(); ++i) {
            for (int j = 0; j < this.buttons.get(i).length; ++j) {
                try {
                    if (!this.buttons.get(i)[j].isHovered(x, y)) continue;
                    this.onButtonHovered(this.buttons.get(i)[j], this.options.get(i)[j]);
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    public void onButtonHovered(GuiButton button, Option<?> option) {
    }

    @Override
    protected void buttonPressed(GuiButton guibutton) {
        int categoryIndex;
        super.buttonPressed(guibutton);
        boolean foundButtonIndex = false;
        int optionIndex = 0;
        for (categoryIndex = 0; categoryIndex < this.buttons.size(); ++categoryIndex) {
            for (optionIndex = 0; optionIndex < this.buttons.get(categoryIndex).length; ++optionIndex) {
                if (guibutton != this.buttons.get(categoryIndex)[optionIndex]) continue;
                foundButtonIndex = true;
                break;
            }
            if (foundButtonIndex) break;
        }
        if (!foundButtonIndex) {
            return;
        }
        this.handleButtonClick(guibutton, categoryIndex, optionIndex);
    }

    @Override
    protected void buttonReleased(GuiButton guibutton) {
        int categoryIndex;
        super.buttonReleased(guibutton);
        boolean foundButtonIndex = false;
        int optionIndex = 0;
        for (categoryIndex = 0; categoryIndex < this.buttons.size(); ++categoryIndex) {
            for (optionIndex = 0; optionIndex < this.buttons.get(categoryIndex).length; ++optionIndex) {
                if (guibutton != this.buttons.get(categoryIndex)[optionIndex]) continue;
                foundButtonIndex = true;
                break;
            }
            if (foundButtonIndex) break;
        }
        if (!foundButtonIndex) {
            return;
        }
        this.handleButtonRelease(guibutton, categoryIndex, optionIndex);
    }

    @Override
    public void initGui() {
        super.initGui();
        for (int catIndex = 0; catIndex < this.options.size(); ++catIndex) {
            Option<?>[] optionsInCategory = this.options.get(catIndex);
            GuiButton[] buttonsInCategory = this.buttons.get(catIndex);
            for (int optIndex = 0; optIndex < optionsInCategory.length; ++optIndex) {
                Option<?> option = optionsInCategory[optIndex];
                GuiButton button = buttonsInCategory[optIndex];
                button.displayString = option.getDisplayStringValue();
            }
        }
    }

    protected void handleButtonClick(GuiButton guibutton, int categoryIndex, int optionIndex) {
        Option<?> option = this.options.get(categoryIndex)[optionIndex];
        if (guibutton instanceof GuiSlider || guibutton instanceof GuiSliderInteger) {
            return;
        }
        if (guibutton instanceof GuiToggleButton) {
            GuiToggleButton guiToggleButton = (GuiToggleButton)guibutton;
            guiToggleButton.getOption().toggle();
        } else if (option instanceof IntegerOption) {
            IntegerOption integerOption = (IntegerOption)option;
            integerOption.value = (Integer)integerOption.value + 1;
        }
        option.onUpdate();
        if (option == this.mc.gameSettings.guiScale) {
            this.mc.resolution.update();
            this.setWorldAndResolution(this.mc, this.mc.resolution.scaledWidth, this.mc.resolution.scaledHeight);
        }
        guibutton.displayString = option.getDisplayString();
    }

    protected void handleButtonRelease(GuiButton guibutton, int categoryIndex, int optionIndex) {
        Option<?> option = this.options.get(categoryIndex)[optionIndex];
        if (guibutton instanceof GuiSlider || guibutton instanceof GuiSliderInteger) {
            option.onUpdate();
        }
    }

    protected void addOptionsCategory(String languageKey, Option<?> ... options) {
        int numButtons = this.buttons.size();
        this.categoryKeys.add(languageKey);
        this.options.add(options);
        this.buttons.add(new GuiButton[options.length]);
        int categoryIndex = this.categoryKeys.size() - 1;
        for (int i = 0; i < options.length; ++i) {
            Option<?> option = options[i];
            if (option == null) continue;
            int id = 1000 + numButtons + i;
            GuiButton[] array = this.buttons.get(categoryIndex);
            GuiButton button = null;
            if (option instanceof ToggleableOption) {
                ToggleableOption toggleableOption = (ToggleableOption)option;
                button = toggleableOption.isSlider() ? new GuiSliderInteger(id, 0, 0, toggleableOption) : new GuiToggleButton(id, 0, 0, 0, 0, toggleableOption);
            } else if (option instanceof FloatOption) {
                FloatOption floatOption = (FloatOption)option;
                button = new GuiSlider(id, 0, 0, 0, 0, floatOption);
            } else if (option instanceof IntegerOption) {
                button = new GuiButton(id, 0, 0, option.getDisplayStringValue());
            }
            if (button == null) {
                throw new NullPointerException("No button for Option: " + option.getDisplayStringName());
            }
            Minecraft mc = Minecraft.getMinecraft(Minecraft.class);
            if (option == mc.gameSettings.borderlessFullscreen && !mc.gameWindow.isBorderlessFullscreenSupported()) {
                button.enabled = false;
            }
            array[i] = button;
        }
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        int oldGuiScale = (Integer)this.gameSettings.guiScale.value;
        boolean oldFullscreen = (Boolean)this.gameSettings.fullscreen.value;
        ArrayList btns = new ArrayList(this.controlList);
        for (GuiButton[] arr : this.buttons) {
            this.controlList.addAll(Arrays.asList(arr));
        }
        super.mouseClicked(x, y, button);
        this.controlList.clear();
        this.controlList.addAll(btns);
        if (oldGuiScale != (Integer)this.gameSettings.guiScale.value || oldFullscreen != (Boolean)this.gameSettings.fullscreen.value) {
            this.controlList.clear();
            this.initGui();
            this.clickX = null;
            this.clickY = null;
        }
    }

    @Override
    protected void drawPageItems(int x, int y, int width) {
        FontRenderer fr = this.mc.fontRenderer;
        int previousHeights = y + this.yOffset;
        for (int i = 0; i < this.options.size(); ++i) {
            String languageKey = this.categoryKeys.get(i);
            Option<?>[] options = this.options.get(i);
            GuiButton[] buttons = this.buttons.get(i);
            int textHeight = this.padding + 10 + 10 + this.padding;
            fr.drawStringWithShadow(I18n.getInstance().translateKey(languageKey), x + this.padding, previousHeights + this.padding + 10, 0x7F7F7F);
            previousHeights += textHeight;
            for (int j = 0; j < options.length; ++j) {
                GuiButton button = buttons[j];
                int myHeight = this.padding + button.height + this.padding;
                button.width = 100;
                button.height = 20;
                button.xPosition = x + width - button.width - this.padding;
                button.yPosition = previousHeights + this.padding;
                button.drawButton(this.mc, this.mouseX, this.mouseY);
                fr.drawStringWithShadow(options[j].getDisplayStringName(), x + this.padding + 16, previousHeights + myHeight / 2 - 4, 0xFFFFFF);
                int stringWidth = fr.getStringWidth(options[j].getDisplayStringName());
                this.drawRect(x + this.padding + 16 + (stringWidth += 8), previousHeights + myHeight / 2, button.xPosition - 8, previousHeights + myHeight / 2 + 1, 0x5F7F7F7F);
                previousHeights += myHeight;
            }
        }
    }

    @Override
    protected int getTotalPageHeight() {
        int height = this.options.size() * (this.padding + 10 + 10 + this.padding);
        for (Option<?>[] option : this.options) {
            height += option.length * (this.padding + 20 + this.padding);
        }
        return height + this.yOffset;
    }
}

