/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.popup;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.popup.GuiPopup;
import net.minecraft.client.gui.popup.InteractivePopupComponent;

public class TextInputComponent
extends InteractivePopupComponent<String> {
    private final GuiTextField textField;

    public TextInputComponent(int width, String defaultText, String placeholder) {
        super(width);
        this.textField = new GuiTextField(null, Minecraft.getMinecraft((Object)this).fontRenderer, 0, 0, width, this.getHeight(), defaultText, placeholder);
    }

    @Override
    public void setParent(GuiPopup parent) {
        super.setParent(parent);
        this.textField.parentGuiScreen = parent;
    }

    @Override
    public String getOutput() {
        return this.textField.getText();
    }

    @Override
    public int getHeight() {
        return 20;
    }

    @Override
    public void render(int x, int y, int mouseX, int mouseY) {
        this.textField.xPosition = x;
        this.textField.yPosition = y;
        this.textField.drawTextBox();
    }

    @Override
    public void onClick(int x, int y, int button) {
        this.textField.mouseClicked(x, y, button);
    }

    @Override
    public void onKeyDown(int keyCode, char c) {
        this.textField.textboxKeyTyped(c, keyCode);
    }

    @Override
    public void tick() {
        this.textField.updateCursorCounter();
    }
}

