/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.option;

import net.minecraft.core.lang.I18n;
import org.lwjgl.input.Keyboard;

public class KeyBinding {
    public String name;
    public int key;

    public KeyBinding(String s, int i) {
        this.name = s;
        this.key = i;
    }

    public boolean isPressed() {
        if (this.key != -1) {
            return Keyboard.isKeyDown((int)this.key);
        }
        return false;
    }

    public boolean isEventKey() {
        if (this.key == -1) {
            return false;
        }
        return Keyboard.getEventKey() == this.key;
    }

    public int keyCode() {
        return this.key;
    }

    public void setKeyCode(int keyCode) {
        this.key = keyCode;
    }

    public boolean isKey(int key) {
        if (this.key == -1) {
            return false;
        }
        return this.key == key;
    }

    public boolean isEnabled() {
        return this.key != -1;
    }

    public String getKeyName() {
        if (this.key == -1) {
            return I18n.getInstance().translateKey("key.disabled");
        }
        try {
            return Keyboard.getKeyName((int)this.key);
        }
        catch (Exception e) {
            return String.valueOf(this.key);
        }
    }
}

